/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.udf.IFunctionDescriptor;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.util.CommandContext;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class FunctionDescriptor
implements Serializable,
Cloneable,
IFunctionDescriptor {
    private static final long serialVersionUID = 5374103983118037242L;
    private static final boolean ALLOW_NAN_INFINITY = PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.allowNanInfinity", false);
    private final ITeiidServerVersion teiidVersion;
    private Class<?>[] types;
    private Class<?> returnType;
    private boolean requiresContext;
    private FunctionMethod method;
    private String schema;
    private Object metadataID;
    private boolean hasWrappedArgs;
    private boolean calledWithVarArgArrayParam;
    private transient Method invocationMethod;

    FunctionDescriptor(ITeiidServerVersion teiidVersion, FunctionMethod method, Class<?>[] types, Class<?> outputType, Method invocationMethod, boolean requiresContext) {
        this.teiidVersion = teiidVersion;
        this.types = types;
        this.returnType = outputType;
        this.invocationMethod = invocationMethod;
        this.requiresContext = requiresContext;
        this.method = method;
    }

    public Object newInstance() {
        try {
            return this.invocationMethod.getDeclaringClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(Messages.gs(Messages.TEIID.TEIID30602, this.method.getName(), this.method.getInvocationClass()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(Messages.gs(Messages.TEIID.TEIID30602, this.method.getName(), this.method.getInvocationClass()));
        }
    }

    public void setHasWrappedArgs(boolean hasWrappedArgs) {
        this.hasWrappedArgs = hasWrappedArgs;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.method.getName();
    }

    public String getFullName() {
        if ("SYS".equals(this.schema)) {
            return this.getName();
        }
        return String.valueOf(this.schema) + '.' + this.getName();
    }

    public FunctionMethod.PushDown getPushdown() {
        return this.method.getPushdown();
    }

    public Class<?>[] getTypes() {
        return this.types;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    Method getInvocationMethod() {
        return this.invocationMethod;
    }

    public boolean requiresContext() {
        return this.requiresContext;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.method.getName());
        str.append("(");
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i] != null) {
                str.append(this.types[i].getName());
            } else {
                str.append("null");
            }
            if (i < this.types.length - 1) {
                str.append(", ");
            }
            ++i;
        }
        str.append(") : ");
        if (this.returnType == null) {
            str.append("null");
        } else {
            str.append(this.returnType.getName());
        }
        return str.toString();
    }

    public boolean isNullDependent() {
        return !this.method.isNullOnNull();
    }

    public FunctionMethod.Determinism getDeterministic() {
        return this.method.getDeterminism();
    }

    public FunctionDescriptor clone() {
        try {
            return (FunctionDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public FunctionMethod getMethod() {
        return this.method;
    }

    void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public Object getMetadataID() {
        return this.metadataID;
    }

    public void setMetadataID(Object metadataID) {
        this.metadataID = metadataID;
    }

    public void checkNotPushdown() throws Exception {
        if (this.getPushdown() == FunctionMethod.PushDown.MUST_PUSHDOWN) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30341, this.getFullName()));
        }
    }

    public Object invokeFunction(Object[] values, CommandContext context, Object functionTarget) throws Exception {
        int i;
        if (!this.isNullDependent()) {
            i = this.requiresContext ? 1 : 0;
            while (i < values.length) {
                if (values[i] == null) {
                    return null;
                }
                ++i;
            }
        }
        if (this.invocationMethod == null) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30382, this.getFullName()));
        }
        try {
            if (this.hasWrappedArgs) {
                i = 0;
                while (i < values.length) {
                    Object val = values[i];
                    if (val != null && this.types[i] == DataTypeManagerService.DefaultDataTypes.VARBINARY.getTypeClass()) {
                        values[i] = ((BinaryType)val).getBytesDirect();
                    }
                    ++i;
                }
            }
            if (this.method.isVarArgs()) {
                if (this.calledWithVarArgArrayParam) {
                    ArrayImpl av = (ArrayImpl)values[values.length - 1];
                    if (av != null) {
                        Class<?> arrayType;
                        Object[] vals;
                        values[values.length - 1] = vals = av.getValues();
                        if (this.hasWrappedArgs && this.types[this.types.length - 1] == DataTypeManagerService.DefaultDataTypes.VARBINARY.getTypeClass()) {
                            vals = Arrays.copyOf(vals, vals.length);
                            int i2 = 0;
                            while (i2 < vals.length) {
                                if (vals[i2] != null) {
                                    vals[i2] = ((BinaryType)vals[i2]).getBytesDirect();
                                }
                                ++i2;
                            }
                            values[values.length - 1] = vals;
                        }
                        if ((arrayType = this.invocationMethod.getParameterTypes()[this.types.length - 1]).getComponentType() != Object.class && vals.getClass() != arrayType) {
                            Object varArgs = Array.newInstance(arrayType.getComponentType(), vals.length);
                            int i3 = 0;
                            while (i3 < vals.length) {
                                Array.set(varArgs, i3, vals[i3]);
                                ++i3;
                            }
                            values[values.length - 1] = varArgs;
                        }
                    }
                } else {
                    i = this.invocationMethod.getParameterTypes().length;
                    Object[] newValues = Arrays.copyOf(values, i);
                    Object varArgs = null;
                    if (this.invocationMethod.getParameterTypes()[i - 1].getComponentType() != Object.class) {
                        int varArgCount = values.length - i + 1;
                        varArgs = Array.newInstance(this.invocationMethod.getParameterTypes()[i - 1].getComponentType(), varArgCount);
                        int j = 0;
                        while (j < varArgCount) {
                            Array.set(varArgs, j, values[i - 1 + j]);
                            ++j;
                        }
                    } else {
                        varArgs = Arrays.copyOfRange(values, i - 1, values.length);
                    }
                    newValues[i - 1] = varArgs;
                    values = newValues;
                }
            }
            Object result = this.invocationMethod.invoke(functionTarget, values);
            if (context != null && this.getDeterministic().ordinal() <= FunctionMethod.Determinism.USER_DETERMINISTIC.ordinal()) {
                context.setDeterminismLevel(this.getDeterministic());
            }
            return this.importValue(result, this.getReturnType());
        }
        catch (ArithmeticException e) {
            throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID30384, this.getFullName()));
        }
        catch (InvocationTargetException e) {
            throw new TeiidClientException(e.getTargetException(), Messages.gs(Messages.TEIID.TEIID30384, this.getFullName()));
        }
        catch (IllegalAccessException e) {
            throw new TeiidClientException(e, Messages.gs(Messages.TEIID.TEIID30385, this.method.toString()));
        }
        catch (Exception e) {
            throw new TeiidClientException(e);
        }
    }

    public Object importValue(Object result, Class<?> expectedType) throws Exception {
        String s;
        Number floatVal;
        if (!ALLOW_NAN_INFINITY && (result instanceof Double ? Double.isInfinite((Double)(floatVal = (Double)result)) || Double.isNaN((Double)floatVal) : result instanceof Float && (Float.isInfinite(((Float)(floatVal = (Float)result)).floatValue()) || Float.isNaN(((Float)floatVal).floatValue())))) {
            throw new ArithmeticException("Infinite or invalid result");
        }
        DataTypeManagerService dataTypeManager = DataTypeManagerService.getInstance(this.teiidVersion);
        result = dataTypeManager.convertToRuntimeType(result, expectedType != DataTypeManagerService.DefaultDataTypes.OBJECT.getTypeClass());
        if (expectedType.isArray() && result instanceof ArrayImpl) {
            return result;
        }
        if ((result = dataTypeManager.transformValue(result, expectedType)) instanceof String && (s = (String)result).length() > DataTypeManagerService.MAX_STRING_LENGTH) {
            return s.substring(0, DataTypeManagerService.MAX_STRING_LENGTH);
        }
        return result;
    }

    public boolean isCalledWithVarArgArrayParam() {
        return this.calledWithVarArgArrayParam;
    }

    public void setCalledWithVarArgArrayParam(boolean calledWithVarArgArrayParam) {
        this.calledWithVarArgArrayParam = calledWithVarArgArrayParam;
    }

    public boolean isSystemFunction(String name) {
        return this.getName().equalsIgnoreCase(name) && "SYS".equals(this.getSchema());
    }

    public boolean isSystemFunction(IFunctionLibrary.FunctionName name) {
        return name.equalsIgnoreCase(this.getName()) && "SYS".equals(this.getSchema());
    }
}

