/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teiid.core.util.ApplicationInfo;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.ConnectionProfile;
import org.teiid.jdbc.JDBCURL;
import org.teiid.jdbc.SocketProfile;
import org.teiid.runtime.client.Messages;

public class TeiidDriver
implements Driver {
    static Logger logger = Logger.getLogger("org.teiid.jdbc");
    static final String DRIVER_NAME = "Teiid JDBC Driver";
    private static TeiidDriver INSTANCE = new TeiidDriver();
    private ConnectionProfile socketProfile = new SocketProfile();
    private ITeiidServerVersion teiidVersion = TeiidServerVersion.Version.TEIID_DEFAULT.get();

    static {
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException e) {
            String logMsg = Messages.getString(Messages.JDBC.Err_registering, e.getMessage());
            logger.log(Level.SEVERE, logMsg);
        }
    }

    public static TeiidDriver getInstance() {
        return INSTANCE;
    }

    public ITeiidServerVersion getTeiidVersion() {
        return this.teiidVersion;
    }

    public void setTeiidVersion(ITeiidServerVersion teiidVersion) {
        this.teiidVersion = teiidVersion;
        ApplicationInfo.getInstance().setTeiidVersion(teiidVersion);
    }

    @Override
    public ConnectionImpl connect(String url, Properties info) throws SQLException {
        JDBCURL.ConnectionType conn = JDBCURL.acceptsUrl(url);
        if (conn == null) {
            return null;
        }
        info = info == null ? new Properties() : PropertiesUtils.clone(info);
        TeiidDriver.parseURL(url, info);
        ConnectionImpl myConnection = null;
        info.setProperty("org.teiid.version", this.getTeiidVersion().toString());
        try {
            myConnection = this.socketProfile.connect(url, info);
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Could not create connection", e);
            throw e;
        }
        String logMsg = Messages.getString(Messages.JDBC.Connection_success, new Object[0]);
        logger.fine(logMsg);
        return myConnection;
    }

    public void setSocketProfile(ConnectionProfile socketProfile) {
        this.socketProfile = socketProfile;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return JDBCURL.acceptsUrl(url) != null;
    }

    @Override
    public int getMajorVersion() {
        return Integer.parseInt(this.teiidVersion.getMajor());
    }

    @Override
    public int getMinorVersion() {
        return Integer.parseInt(this.teiidVersion.getMinor());
    }

    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        info = info == null ? new Properties() : PropertiesUtils.clone(info);
        LinkedList<DriverPropertyInfo> driverProps = new LinkedList<DriverPropertyInfo>();
        TeiidDriver.parseURL(url, info);
        for (String property : JDBCURL.KNOWN_PROPERTIES.keySet()) {
            DriverPropertyInfo dpi = new DriverPropertyInfo(property, info.getProperty(property));
            if (property.equals("VirtualDatabaseName")) {
                dpi.required = true;
            }
            driverProps.add(dpi);
        }
        DriverPropertyInfo[] propInfo = new DriverPropertyInfo[driverProps.size()];
        return driverProps.toArray(propInfo);
    }

    protected static void parseURL(String url, Properties info) throws SQLException {
        if (url == null) {
            String msg = Messages.getString(Messages.JDBC.urlFormat, new Object[0]);
            throw new SQLException(msg);
        }
        try {
            JDBCURL jdbcURL = new JDBCURL(url);
            info.setProperty("VirtualDatabaseName", jdbcURL.getVDBName());
            if (jdbcURL.getConnectionURL() != null) {
                info.setProperty("serverURL", jdbcURL.getConnectionURL());
            }
            Properties optionalParams = jdbcURL.getProperties();
            JDBCURL.normalizeProperties(info);
            Enumeration<Object> keys = optionalParams.keys();
            while (keys.hasMoreElements()) {
                String propName = (String)keys.nextElement();
                if (info.containsKey(propName)) continue;
                info.setProperty(propName, optionalParams.getProperty(propName));
            }
            if (!info.containsKey("VirtualDatabaseVersion") && jdbcURL.getVDBVersion() != null) {
                info.setProperty("VirtualDatabaseVersion", jdbcURL.getVDBVersion());
            }
            if (!info.containsKey("ApplicationName")) {
                info.setProperty("ApplicationName", "JDBC");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(Messages.getString(Messages.JDBC.urlFormat, new Object[0]));
        }
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return logger;
    }
}

