/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teiid.client.ResultsMessage;
import org.teiid.client.lob.LobChunkInputStream;
import org.teiid.client.lob.StreamingLobChunckProducer;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.jdbc.AsynchPositioningException;
import org.teiid.jdbc.BatchResults;
import org.teiid.jdbc.DataTypeTransformer;
import org.teiid.jdbc.DeferredMetadataProvider;
import org.teiid.jdbc.FilteredResultsMetadata;
import org.teiid.jdbc.ResultSetMetaDataImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TeiidResultSet;
import org.teiid.jdbc.WrapperImpl;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class ResultSetImpl
extends WrapperImpl
implements TeiidResultSet,
BatchResults.BatchFetcher {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    private static final int BEFORE_FIRST_ROW = 0;
    public static final String DISABLE_FETCH_SIZE = "disableResultSetFetchSize";
    private Object currentValue;
    private ResultSetMetaData rmetadata;
    private StatementImpl statement;
    private int cursorType;
    private boolean isClosed;
    private long requestID;
    private BatchResults batchResults;
    private int columnCount;
    private int resultColumns;
    private int parameters;
    private TimeZone serverTimeZone;
    private PlanNode updatedPlanDescription;
    private int maxFieldSize;
    private int fetchSize;
    private int maxRows;
    private Map<String, Integer> columnMap;
    private ResultsFuture<ResultsMessage> asynchResults;
    boolean asynch;
    private ResultsFuture<ResultsMessage> prefetch;
    private boolean usePrefetch;
    private int skipTo;
    private static boolean DISABLE_FETCH_SIZE_DEFAULT = PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.disableResultSetFetchSize", false);
    private Boolean disableFetchSize;

    ResultSetImpl(ResultsMessage resultsMsg, StatementImpl statement) throws SQLException {
        this(resultsMsg, statement, null, 0);
    }

    ResultSetImpl(ResultsMessage resultsMsg, StatementImpl statement, ResultSetMetaData metadata, int parameters) throws SQLException {
        this.statement = statement;
        this.parameters = parameters;
        this.requestID = statement.getCurrentRequestID();
        this.cursorType = statement.getResultSetType();
        this.serverTimeZone = statement.getServerTimeZone();
        if (metadata == null) {
            DeferredMetadataProvider provider = new DeferredMetadataProvider(resultsMsg.getColumnNames(), resultsMsg.getDataTypes(), statement, statement.getCurrentRequestID());
            this.rmetadata = new ResultSetMetaDataImpl(provider, this.statement.getExecutionProperty("useJDBC4ColumnNameAndLabelSemantics"));
        } else {
            this.rmetadata = metadata;
        }
        this.columnCount = this.rmetadata.getColumnCount();
        this.resultColumns = this.columnCount - parameters;
        if (this.parameters > 0) {
            this.rmetadata = new FilteredResultsMetadata(this.rmetadata, this.resultColumns);
        }
        this.fetchSize = statement.getFetchSize();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Creating ResultSet requestID: " + this.requestID + " beginRow: " + resultsMsg.getFirstRow() + " resultsColumns: " + this.resultColumns + " parameters: " + parameters);
        }
        this.usePrefetch = this.cursorType == 1003 && !statement.useCallingThread();
        this.maxRows = statement.getMaxRows();
        this.batchResults = new BatchResults(this, this.getCurrentBatch(resultsMsg), this.cursorType == 1003 ? 1 : 3);
    }

    private ITeiidServerVersion getTeiidVersion() {
        return this.statement.getTeiidVersion();
    }

    private boolean isLessThanTeiidEight() {
        return this.getTeiidVersion().isLessThan(TeiidServerVersion.Version.TEIID_8_0.get());
    }

    private void checkSupportedVersion() {
        if (this.isLessThanTeiidEight()) {
            throw new UnsupportedOperationException();
        }
    }

    public void setMaxFieldSize(int maxFieldSize) {
        this.maxFieldSize = maxFieldSize;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            this.statement.checkStatement();
            if (this.requestID >= 0L) {
                try {
                    this.statement.getDQP().closeRequest(this.requestID);
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }
            this.isClosed = true;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            String msg = Messages.getString(Messages.JDBC.MMResultSet_Cant_call_closed_resultset, new Object[0]);
            throw new SQLException(msg);
        }
    }

    Object getOutputParamValue(int index) throws SQLException {
        if (index <= this.resultColumns || index > this.resultColumns + this.parameters) {
            throw new SQLException(Messages.getString(Messages.JDBC.StoredProcedureResultsImpl_Invalid_parameter_index__0_2, index));
        }
        int originalRow = this.getAbsoluteRowNumber();
        this.batchResults.absolute(-1);
        try {
            Object object = this.getObjectDirect(index);
            return object;
        }
        finally {
            this.batchResults.absolute(originalRow);
        }
    }

    @Override
    public Object getObject(int column) throws SQLException {
        if (this.isAfterLast()) {
            throw new SQLException(Messages.getString(Messages.JDBC.StoredProcedureResultsImpl_ResultSet_cursor_is_after_the_last_row_1, new Object[0]));
        }
        if (column > this.resultColumns) {
            throw new SQLException(Messages.getString(Messages.JDBC.ResultsImpl_Invalid_col_index, column));
        }
        return this.getObjectDirect(column);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public ResultsFuture<Boolean> submitNext() throws SQLException {
        Boolean hasNext = this.batchResults.hasNext(this.getOffset() + 1, false);
        if (hasNext != null) {
            return StatementImpl.booleanFuture(this.next());
        }
        ResultsFuture<ResultsMessage> pendingResult = this.submitRequestBatch(this.batchResults.getCurrentRowNumber() + 1);
        final ResultsFuture<Boolean> result = new ResultsFuture<Boolean>();
        pendingResult.addCompletionListener(new ResultsFuture.CompletionListener<ResultsMessage>(){

            @Override
            public void onCompletion(ResultsFuture<ResultsMessage> future) {
                try {
                    ResultSetImpl.this.batchResults.setBatch(ResultSetImpl.this.processBatch(future.get()));
                    result.getResultsReceiver().receiveResults(ResultSetImpl.this.next());
                }
                catch (Throwable t) {
                    result.getResultsReceiver().exceptionOccurred(t);
                }
            }
        });
        return result;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.hasNext()) {
            return this.batchResults.next();
        }
        this.batchResults.next();
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        return this.batchResults.previous();
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.isAfterLast()) {
            return 0;
        }
        return this.getAbsoluteRowNumber();
    }

    public Object getObjectDirect(int column) throws SQLException {
        this.checkClosed();
        if (column < 1 || column > this.columnCount) {
            throw new IllegalArgumentException(Messages.getString(Messages.JDBC.ResultsImpl_Invalid_col_index, column));
        }
        List<?> cursorRow = this.batchResults.getCurrentRow();
        if (cursorRow == null) {
            throw new SQLException(Messages.getString(Messages.JDBC.ResultsImpl_The_cursor_is_not_on_a_valid_row_1, new Object[0]));
        }
        this.currentValue = cursorRow.get(column - 1);
        if (this.currentValue instanceof Streamable) {
            Object reference = ((Streamable)this.currentValue).getReference();
            if (reference != null) {
                this.currentValue = reference;
                return this.currentValue;
            }
            if (this.currentValue instanceof ClobType) {
                this.currentValue = new ClobImpl(this.createInputStreamFactory((ClobType)this.currentValue), ((ClobType)this.currentValue).getLength());
            } else if (this.currentValue instanceof BlobType) {
                InputStreamFactory isf = this.createInputStreamFactory((BlobType)this.currentValue);
                isf.setLength(((BlobType)this.currentValue).getLength());
                this.currentValue = new BlobImpl(isf);
            } else if (this.currentValue instanceof XMLType) {
                XMLType val = (XMLType)this.currentValue;
                this.currentValue = new SQLXMLImpl(this.createInputStreamFactory(val));
                ((SQLXMLImpl)this.currentValue).setEncoding(val.getEncoding());
            }
        } else {
            if (this.currentValue instanceof java.util.Date) {
                return TimestampWithTimezone.create((java.util.Date)this.currentValue, this.serverTimeZone, this.getDefaultCalendar(), this.currentValue.getClass());
            }
            if (this.maxFieldSize > 0 && this.currentValue instanceof String) {
                String val = (String)this.currentValue;
                this.currentValue = val.substring(0, Math.min(this.maxFieldSize / 2, val.length()));
            } else if (this.currentValue instanceof BinaryType) {
                BinaryType val = (BinaryType)this.currentValue;
                this.currentValue = val.getBytesDirect();
            }
        }
        return this.currentValue;
    }

    private InputStreamFactory createInputStreamFactory(Streamable<?> type) {
        final StreamingLobChunckProducer.Factory factory = new StreamingLobChunckProducer.Factory(this.statement.getDQP(), this.requestID, type);
        InputStreamFactory isf = new InputStreamFactory(){

            @Override
            public InputStream getInputStream() throws IOException {
                return new LobChunkInputStream(factory.getLobChunkProducer());
            }
        };
        return isf;
    }

    public List<?> getCurrentRecord() throws SQLException {
        this.checkClosed();
        return this.batchResults.getCurrentRow();
    }

    @Override
    public int getType() throws SQLException {
        return this.cursorType;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        return this.batchResults.absolute(row, this.getOffset());
    }

    protected PlanNode getUpdatedPlanDescription() {
        return this.updatedPlanDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchResults.Batch requestBatch(int beginRow) throws SQLException {
        this.checkClosed();
        try {
            if (this.prefetch != null) {
                ResultsMessage result = this.getResults(this.prefetch);
                this.prefetch = null;
                BatchResults.Batch nextBatch = this.processBatch(result);
                return nextBatch;
            }
            ResultsFuture<ResultsMessage> results = this.submitRequestBatch(beginRow);
            if (this.asynch && !results.isDone()) {
                ResultSetImpl nextBatch = this;
                synchronized (nextBatch) {
                    this.asynchResults = results;
                }
                throw new AsynchPositioningException();
            }
            ResultsMessage currentResultMsg = this.getResults(results);
            return this.processBatch(currentResultMsg);
        }
        catch (InterruptedException e) {
            throw new SQLException(e);
        }
        catch (ExecutionException e) {
            throw new SQLException(e);
        }
        catch (TimeoutException e) {
            throw new SQLException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultsFuture<ResultsMessage> submitRequestBatch(int beginRow) throws SQLException {
        ResultsFuture<ResultsMessage> results;
        if (beginRow > this.maxRows && this.skipTo > 0) {
            beginRow = this.skipTo;
        }
        if (this.asynch) {
            ResultSetImpl resultSetImpl = this;
            synchronized (resultSetImpl) {
                if (this.asynchResults != null) {
                    ResultsFuture<ResultsMessage> results2 = this.asynchResults;
                    this.asynchResults = null;
                    return results2;
                }
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("requestBatch requestID: " + this.requestID + " beginRow: " + beginRow);
        }
        try {
            results = this.statement.getDQP().processCursorRequest(this.requestID, beginRow, this.fetchSize);
        }
        catch (TeiidClientException e) {
            throw new SQLException(e);
        }
        return results;
    }

    private BatchResults.Batch processBatch(ResultsMessage currentResultMsg) throws SQLException {
        if (currentResultMsg.getException() != null) {
            throw new SQLException(currentResultMsg.getException());
        }
        this.accumulateWarnings(currentResultMsg);
        return this.getCurrentBatch(currentResultMsg);
    }

    private ResultsMessage getResults(ResultsFuture<ResultsMessage> results) throws SQLException, InterruptedException, ExecutionException, TimeoutException {
        int timeoutSeconds = this.statement.getQueryTimeout();
        if (timeoutSeconds == 0) {
            timeoutSeconds = Integer.MAX_VALUE;
        }
        ResultsMessage currentResultMsg = results.get(timeoutSeconds, TimeUnit.SECONDS);
        return currentResultMsg;
    }

    private BatchResults.Batch getCurrentBatch(ResultsMessage currentResultMsg) throws SQLException {
        this.updatedPlanDescription = currentResultMsg.getPlanDescription();
        if (this.usePrefetch && !this.asynch && this.prefetch == null && currentResultMsg.getLastRow() != currentResultMsg.getFinalRow()) {
            this.prefetch = this.submitRequestBatch(currentResultMsg.getLastRow() + 1);
        }
        currentResultMsg.processResults();
        List<?> lastTuple = null;
        List<List<?>> resultsList = currentResultMsg.getResultsList();
        List[] tuples = null;
        int firstRow = currentResultMsg.getFirstRow();
        int endRow = currentResultMsg.getLastRow();
        int lastRow = currentResultMsg.getFinalRow();
        if (this.maxRows > 0) {
            if (this.parameters > 0) {
                if (currentResultMsg.getLastRow() == currentResultMsg.getFinalRow()) {
                    lastTuple = resultsList.get(resultsList.size() - 1);
                } else if (this.maxRows < currentResultMsg.getFirstRow()) {
                    this.skipTo = lastRow != 0 ? lastRow : endRow + 1;
                    return new BatchResults.Batch(new List[0], firstRow, firstRow - 1);
                }
            }
            if (this.maxRows < currentResultMsg.getLastRow()) {
                firstRow = Math.min(this.maxRows + 1, firstRow);
                resultsList = resultsList.subList(0, this.maxRows - firstRow + 1);
                lastRow = endRow = this.maxRows;
            }
            tuples = resultsList.toArray(new List[resultsList.size() + (lastTuple != null ? 1 : 0)]);
            if (lastTuple != null) {
                lastRow = ++endRow;
                tuples[tuples.length - 1] = lastTuple;
            }
        } else {
            tuples = resultsList.toArray(new List[resultsList.size()]);
        }
        BatchResults.Batch result = new BatchResults.Batch(tuples, firstRow, endRow);
        result.setLastRow(lastRow);
        return result;
    }

    protected int getFinalRowNumber() {
        return Math.max(-1, this.batchResults.getFinalRowNumber() - this.getOffset());
    }

    protected boolean hasNext() throws SQLException {
        return this.batchResults.hasNext(this.getOffset() + 1, true);
    }

    @Override
    public int available() throws SQLException {
        int current = this.batchResults.getCurrentRowNumber();
        int highest = this.batchResults.getHighestRowNumber();
        return highest - current - this.getOffset() - (this.batchResults.isTailLast() ? 1 : 0);
    }

    protected int getOffset() {
        return this.parameters > 0 ? 1 : 0;
    }

    protected int getAbsoluteRowNumber() {
        return this.batchResults.getCurrentRowNumber();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return DataTypeTransformer.getBigDecimal(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal bigDecimalObject = DataTypeTransformer.getBigDecimal(this.getTeiidVersion(), this.getObject(columnIndex));
        if (bigDecimalObject == null) {
            return null;
        }
        return bigDecimalObject.setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof Blob) {
            return ((Blob)value).getBinaryStream();
        }
        if (value instanceof SQLXML) {
            return ((SQLXML)value).getBinaryStream();
        }
        throw new SQLException(Messages.getString(Messages.JDBC.MMResultSet_cannot_convert_to_binary_stream, new Object[0]));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return DataTypeTransformer.getBlob(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return DataTypeTransformer.getBoolean(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return DataTypeTransformer.getByte(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return DataTypeTransformer.getBytes(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        return DataTypeTransformer.getCharacterStream(this.getTeiidVersion(), value);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date value = DataTypeTransformer.getDate(this.getTeiidVersion(), this.getObject(columnIndex));
        if (value != null && cal != null) {
            value = TimestampWithTimezone.createDate(value, this.getDefaultCalendar().getTimeZone(), cal);
        }
        return value;
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return DataTypeTransformer.getDouble(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return DataTypeTransformer.getFloat(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return DataTypeTransformer.getInteger(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return DataTypeTransformer.getLong(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return DataTypeTransformer.getShort(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return DataTypeTransformer.getString(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time value = DataTypeTransformer.getTime(this.getTeiidVersion(), this.getObject(columnIndex));
        if (value != null && cal != null) {
            value = TimestampWithTimezone.createTime(value, this.getDefaultCalendar().getTimeZone(), cal);
        }
        return value;
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp value = DataTypeTransformer.getTimestamp(this.getTeiidVersion(), this.getObject(columnIndex));
        if (value != null && cal != null) {
            value = TimestampWithTimezone.createTimestamp(value, this.getDefaultCalendar().getTimeZone(), cal);
        }
        return value;
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.currentValue == null;
    }

    protected void accumulateWarnings(ResultsMessage resultsMsg) {
        this.statement.accumulateWarnings(resultsMsg.getWarnings());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.rmetadata;
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public StatementImpl getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.getAbsoluteRowNumber() == 1 && this.hasNext();
    }

    @Override
    public boolean isLast() throws SQLException {
        return !this.hasNext() && this.getAbsoluteRowNumber() > 0 && this.getAbsoluteRowNumber() == this.getFinalRowNumber();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.getFinalRowNumber() == -1) {
            return false;
        }
        return !this.hasNext() && this.getAbsoluteRowNumber() > 0 && this.getAbsoluteRowNumber() > this.getFinalRowNumber();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.getAbsoluteRowNumber() == 0 && this.hasNext();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isBeforeFirst() || this.isAfterLast() || this.getFinalRowNumber() == 0) {
            throw new SQLException(Messages.getString(Messages.JDBC.ResultsImpl_The_cursor_is_not_on_a_valid_row_1, new Object[0]));
        }
        this.checkNotForwardOnly();
        return this.absolute(Math.max(0, this.getAbsoluteRowNumber() + rows));
    }

    @Override
    public boolean last() throws SQLException {
        this.checkNotForwardOnly();
        return this.absolute(-1);
    }

    protected void checkNotForwardOnly() throws SQLException {
        if (this.getType() == 1003) {
            String msg = Messages.getString(Messages.JDBC.ResultsImpl_Op_invalid_fwd_only, new Object[0]);
            throw new SQLException(msg);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.last()) {
            this.next();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.first()) {
            this.previous();
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkNotForwardOnly();
        return this.absolute(1);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        this.checkClosed();
        return this.findColumnIndex(columnName);
    }

    protected int findColumnIndex(String columnName) throws SQLException {
        Integer index;
        if (this.columnMap == null) {
            this.columnMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            int colCount = this.getMetaData().getColumnCount();
            int i = 1;
            while (i <= colCount) {
                this.columnMap.put(this.getMetaData().getColumnLabel(i), i);
                ++i;
            }
        }
        if ((index = this.columnMap.get(columnName)) != null) {
            return index;
        }
        String msg = Messages.getString(Messages.JDBC.MMResultsImpl_Col_doesnt_exist, columnName);
        throw new SQLException(msg);
    }

    protected Calendar getDefaultCalendar() {
        return this.statement.getDefaultCalendar();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.checkSupportedVersion();
        return DataTypeTransformer.getArray(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        this.checkSupportedVersion();
        return DataTypeTransformer.getArray(this.getTeiidVersion(), this.getObject(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkSupportedVersion();
        return DataTypeTransformer.getAsciiStream(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.checkSupportedVersion();
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return DataTypeTransformer.getClob(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return DataTypeTransformer.getSQLXML(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkSupportedVersion();
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.checkSupportedVersion();
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkSupportedVersion();
        return DataTypeTransformer.getNClob(this.getTeiidVersion(), this.getObject(columnIndex));
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.checkSupportedVersion();
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.checkSupportedVersion();
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.checkSupportedVersion();
        return this.getString(columnLabel);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.checkSupportedVersion();
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new SQLException(Messages.getString(Messages.JDBC.MMStatement_Invalid_fetch_size, new Object[0]));
        }
        if (rows == 0) {
            this.fetchSize = 2048;
        } else {
            if (this.disableFetchSize == null) {
                this.disableFetchSize = PropertiesUtils.getBooleanProperty(this.statement.getConnection().getConnectionProps(), DISABLE_FETCH_SIZE, DISABLE_FETCH_SIZE_DEFAULT);
            }
            if (this.disableFetchSize == null || !this.disableFetchSize.booleanValue()) {
                this.fetchSize = rows;
            }
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return DataTypeTransformer.transform(this.getTeiidVersion(), this.getObject(columnIndex), type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return DataTypeTransformer.transform(this.getTeiidVersion(), this.getObject(columnLabel), type);
    }

    ResultsFuture<ResultsMessage> getPrefetch() {
        return this.prefetch;
    }
}

