/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.teiid.core.util.ExecutorUtils;

public class EnhancedTimer {
    private static final Logger LOGGER = Logger.getLogger("org.teiid.jdbc");
    private static AtomicLong id = new AtomicLong();
    private final ConcurrentSkipListSet<Task> queue = new ConcurrentSkipListSet();
    private final Executor taskExecutor;
    private final Executor bossExecutor;
    private boolean running;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public EnhancedTimer(String name) {
        this.taskExecutor = ExecutorUtils.getDirectExecutor();
        this.bossExecutor = ExecutorUtils.newFixedThreadPool(1, name);
    }

    public EnhancedTimer(Executor bossExecutor, Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
        this.bossExecutor = bossExecutor;
    }

    private void start() {
        this.bossExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    while (EnhancedTimer.this.doTasks()) {
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doTasks() throws InterruptedException {
        Task task;
        block16: {
            task = null;
            this.lock.writeLock().lock();
            if (this.queue.isEmpty()) {
                EnhancedTimer enhancedTimer = this;
                synchronized (enhancedTimer) {
                    this.lock.writeLock().unlock();
                    this.running = false;
                    return false;
                }
            }
            task = this.queue.first();
            long toWait = task.endTime - System.currentTimeMillis();
            if (toWait > 0L) {
                EnhancedTimer enhancedTimer = this;
                synchronized (enhancedTimer) {
                    this.lock.writeLock().unlock();
                    this.wait(toWait);
                    return true;
                }
            }
            this.queue.pollFirst();
            break block16;
            finally {
                if (this.lock.writeLock().isHeldByCurrentThread()) {
                    this.lock.writeLock().unlock();
                }
            }
        }
        try {
            this.taskExecutor.execute(task);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Unexpected exception running task", t);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task add(Runnable task, long delay) {
        Task result;
        block9: {
            result = new Task(task, delay);
            this.lock.readLock().lock();
            try {
                try {
                    if (!this.queue.add(result) || this.queue.first() != result) break block9;
                    EnhancedTimer enhancedTimer = this;
                    synchronized (enhancedTimer) {
                        if (!this.running) {
                            this.start();
                        }
                        this.notifyAll();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.lock.readLock().unlock();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return result;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public class Task
    extends FutureTask<Void>
    implements Comparable<Task> {
        final long endTime;
        final long seqId;

        public Task(Runnable task, long delay) {
            super(task, null);
            this.seqId = id.getAndIncrement();
            this.endTime = System.currentTimeMillis() + delay;
        }

        @Override
        public int compareTo(Task o) {
            int result = Long.signum(this.endTime - o.endTime);
            if (result == 0) {
                return Long.signum(this.seqId - o.seqId);
            }
            return result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.isDone()) {
                EnhancedTimer.this.lock.readLock().lock();
                try {
                    boolean bl = EnhancedTimer.this.queue.remove(this);
                    return bl;
                }
                finally {
                    EnhancedTimer.this.lock.readLock().unlock();
                }
            }
            return super.cancel(mayInterruptIfRunning);
        }

        public void cancel() {
            this.cancel(false);
        }
    }
}

