/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;
import org.teiid.core.types.BaseLob;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.LobSearchUtil;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.runtime.client.Messages;

public class BlobImpl
extends BaseLob
implements Blob,
LobSearchUtil.StreamProvider {
    public BlobImpl() {
    }

    public BlobImpl(InputStreamFactory streamFactory) {
        super(streamFactory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] byArray;
        if (pos < 1L) {
            Object[] params = new Object[]{new Long(pos)};
            throw new SQLException(Messages.getString(Messages.MMClob.MMBlob_0, params));
        }
        if (pos > this.length()) {
            return null;
        }
        --pos;
        if (length < 0) {
            Object[] params = new Object[]{new Integer(length)};
            throw new SQLException(Messages.getString(Messages.MMClob.MMBlob_3, params));
        }
        if (pos + (long)length > this.length()) {
            length = (int)(this.length() - pos);
        }
        InputStream in = this.getBinaryStream();
        try {
            long skipped = 0L;
            while (true) {
                if (pos <= 0L) {
                    byArray = ObjectConverterUtil.convertToByteArray(in, length);
                    break;
                }
                skipped = in.skip(pos);
                pos -= skipped;
            }
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            in.close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
    }

    @Override
    public long position(final Blob pattern, long start) throws SQLException {
        if (pattern == null) {
            return -1L;
        }
        return LobSearchUtil.position(new LobSearchUtil.StreamProvider(){

            @Override
            public InputStream getBinaryStream() throws SQLException {
                return pattern.getBinaryStream();
            }
        }, pattern.length(), this, this.length(), start, 1);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (pattern == null) {
            return -1L;
        }
        return this.position(new SerialBlob(pattern), start);
    }

    @Override
    public InputStream getBinaryStream(long arg0, long arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

