/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.BufferedInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.SQLException;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.Streamable;

public class BaseLob
implements Externalizable,
InputStreamFactory.StreamFactoryReference {
    private static final long serialVersionUID = -1586959324208959519L;
    private InputStreamFactory streamFactory;
    private Charset charset;

    public BaseLob() {
    }

    protected BaseLob(InputStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    @Override
    public void setStreamFactory(InputStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public InputStreamFactory getStreamFactory() throws SQLException {
        if (this.streamFactory == null) {
            throw new SQLException("Already freed");
        }
        return this.streamFactory;
    }

    public void setEncoding(String encoding) {
        this.charset = encoding != null ? Charset.forName(encoding) : null;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void free() {
        this.streamFactory = null;
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            Reader r = this.getStreamFactory().getCharacterStream();
            if (r != null) {
                return r;
            }
        }
        catch (IOException e) {
            SQLException ex = new SQLException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        Charset cs = this.getCharset();
        if (cs == null) {
            cs = Streamable.CHARSET;
        }
        return new InputStreamReader(this.getBinaryStream(), cs.newDecoder());
    }

    public InputStream getBinaryStream() throws SQLException {
        try {
            return this.getStreamFactory().getInputStream();
        }
        catch (IOException e) {
            SQLException ex = new SQLException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.streamFactory = (InputStreamFactory)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.streamFactory);
    }

    public long length() throws SQLException {
        if (this.getStreamFactory().getLength() == -1L) {
            this.getStreamFactory().setLength(BaseLob.length(this.getBinaryStream()));
        }
        return this.getStreamFactory().getLength();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long length(InputStream is) throws SQLException {
        long l;
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        try {
            long length = 0L;
            while (true) {
                if (is.read() == -1) {
                    l = length;
                    break;
                }
                ++length;
            }
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            is.close();
            return l;
        }
        catch (IOException iOException) {}
        return l;
    }
}

