/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.util;

import java.lang.reflect.Method;
import org.teiid.client.xa.XATransactionException;
import org.teiid.runtime.client.TeiidClientException;

public class ExceptionUtil {
    public static <T extends Throwable> T getExceptionOfType(Throwable ex, Class<T> cls) {
        while (ex != null) {
            if (cls.isAssignableFrom(ex.getClass())) {
                return (T)((Throwable)cls.cast(ex));
            }
            if (ex.getCause() == ex) break;
            ex = ex.getCause();
        }
        return null;
    }

    public static Throwable convertException(Method method, Throwable exception) {
        boolean canThrowXATransactionException = false;
        boolean canThrowComponentException = false;
        Class<?>[] exceptionClasses = method.getExceptionTypes();
        int i = 0;
        while (i < exceptionClasses.length) {
            if (exceptionClasses[i].isAssignableFrom(exception.getClass())) {
                return exception;
            }
            if (!canThrowComponentException) {
                canThrowComponentException = TeiidClientException.class.isAssignableFrom(exceptionClasses[i]);
            }
            if (!canThrowXATransactionException) {
                canThrowXATransactionException = XATransactionException.class.isAssignableFrom(exceptionClasses[i]);
            }
            ++i;
        }
        if (canThrowComponentException) {
            return new TeiidClientException(exception);
        }
        if (canThrowXATransactionException) {
            return new XATransactionException(exception);
        }
        if (RuntimeException.class.isAssignableFrom(exception.getClass())) {
            return exception;
        }
        return new RuntimeException(exception);
    }
}

