/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.teiid.client.batch.Batch0Serializer;
import org.teiid.client.batch.Batch1Serializer;
import org.teiid.client.batch.Batch2Serializer;
import org.teiid.client.batch.Batch3Serializer;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public abstract class BatchSerializer {
    private final ITeiidServerVersion teiidVersion;

    public BatchSerializer(ITeiidServerVersion teiidVersion) {
        this.teiidVersion = teiidVersion;
    }

    protected ITeiidServerVersion getTeiidVersion() {
        return this.teiidVersion;
    }

    protected DataTypeManagerService getDataTypeManager() {
        return DataTypeManagerService.getInstance(this.getTeiidVersion());
    }

    public static BatchSerializer getInstance(ITeiidServerVersion teiidVersion) {
        if (teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_0.get())) {
            return new Batch0Serializer(teiidVersion);
        }
        if (teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_2.get())) {
            return new Batch1Serializer(teiidVersion);
        }
        if (teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_6.get())) {
            return new Batch2Serializer(teiidVersion);
        }
        return new Batch3Serializer(teiidVersion);
    }

    public abstract List<List<Object>> readBatch(ObjectInput var1, String[] var2) throws IOException, ClassNotFoundException;

    public abstract void writeBatch(ObjectOutput var1, String[] var2, List<? extends List<?>> var3) throws IOException;

    public abstract void writeBatch(ObjectOutput var1, String[] var2, List<? extends List<?>> var3, byte var4) throws IOException;
}

