/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.preview.jobs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.runtime.preview.Messages;
import org.teiid.designer.runtime.preview.PreviewContext;
import org.teiid.designer.runtime.preview.PreviewManager;
import org.teiid.designer.runtime.preview.jobs.CompositePreviewJob;
import org.teiid.designer.runtime.preview.jobs.CreatePreviewVdbJob;
import org.teiid.designer.runtime.preview.jobs.WorkspacePreviewVdbJob;

public final class ModelProjectOpenedJob
extends CompositePreviewJob {
    private final IProject project;

    public ModelProjectOpenedJob(IProject project, PreviewContext context) throws Exception {
        super(NLS.bind((String)Messages.ModelProjectOpenedJob, (Object)project), context, null, true);
        assert (project != null);
        assert (ModelerCore.hasModelNature((IProject)project));
        this.project = project;
        CreatePreviewVdbJob job = new CreatePreviewVdbJob(project, context);
        this.add(job);
        this.process((IContainer)this.project);
    }

    public boolean belongsTo(Object family) {
        return WorkspacePreviewVdbJob.WORKSPACE_PREVIEW_FAMILY == family;
    }

    public IProject getProject() {
        return this.project;
    }

    private void process(IContainer container) throws Exception {
        PreviewContext context = this.getContext();
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IContainer) {
                this.process((IContainer)resource);
            } else if (resource instanceof IFile && PreviewManager.isPreviewableResource((IFile)resource)) {
                CreatePreviewVdbJob job = new CreatePreviewVdbJob((IFile)resource, context);
                this.add(job);
            }
            ++n2;
        }
    }
}

