/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.preview.jobs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.runtime.preview.Messages;
import org.teiid.designer.runtime.preview.PreviewContext;
import org.teiid.designer.runtime.preview.jobs.TeiidPreviewVdbCleanupJob;
import org.teiid.designer.runtime.spi.ITeiidServer;

public final class DeleteDeployedPreviewVdbJob
extends TeiidPreviewVdbCleanupJob {
    private final String jndiName;
    private final String pvdbName;

    public DeleteDeployedPreviewVdbJob(String pvdbName, String jndiName, PreviewContext context, ITeiidServer previewServer) {
        super(NLS.bind((String)Messages.DeleteDeployedPreviewVdbJob, (Object)pvdbName), context, previewServer);
        assert (!StringUtilities.isEmpty((String)pvdbName)) : "Preview VDB name is null or empty";
        assert (!StringUtilities.isEmpty((String)jndiName)) : "JNDI name is null or empty";
        this.pvdbName = pvdbName;
        this.jndiName = jndiName;
    }

    @Override
    protected IStatus runImpl(IProgressMonitor monitor) throws Exception {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        ITeiidServer teiidServer = this.getPreviewServer();
        int errors = 0;
        Status deleteVdbErrorStatus = null;
        try {
            if (teiidServer.hasVdb(this.pvdbName)) {
                teiidServer.undeployVdb(this.pvdbName);
            }
        }
        catch (Exception e) {
            ++errors;
            deleteVdbErrorStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.DeleteDeployedPreviewVdbJobError, (Object)this.pvdbName), (Throwable)e);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Status deleteDataSourceErrorStatus = null;
        try {
            if (teiidServer.dataSourceExists(this.jndiName)) {
                teiidServer.deleteDataSource(this.jndiName);
            }
        }
        catch (Exception e) {
            ++errors;
            deleteDataSourceErrorStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.DeleteDeployedPreviewVdbJobError, (Object)this.pvdbName), (Throwable)e);
        }
        if (errors == 0) {
            return new Status(1, "org.teiid.designer.dqp", NLS.bind((String)Messages.DeleteDeployedPreviewVdbJobSuccessfullyCompleted, (Object)this.pvdbName));
        }
        if (errors == 2) {
            IStatus[] statuses = new IStatus[]{deleteVdbErrorStatus, deleteDataSourceErrorStatus};
            return new MultiStatus("org.teiid.designer.dqp", 0, statuses, NLS.bind((String)Messages.DeleteDeployedPreviewVdbJobError, (Object)this.pvdbName), null);
        }
        if (deleteVdbErrorStatus != null) {
            throw new CoreException((IStatus)deleteVdbErrorStatus);
        }
        throw new CoreException((IStatus)deleteDataSourceErrorStatus);
    }
}

