/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.teiid.designer.ExtensionRegistryUtils;
import org.teiid.designer.IExtensionRegistryCallback;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.datatools.connection.ConnectionInfoProviderFactory;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.connection.spi.IPasswordProvider;
import org.teiid.designer.runtime.spi.FailedTeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidServer;

public class TeiidDataSourceFactory {
    public IPasswordProvider getPasswordProvider() throws Exception {
        final ArrayList passwordProviders = new ArrayList();
        IExtensionRegistryCallback<IPasswordProvider> callback = new IExtensionRegistryCallback<IPasswordProvider>(){

            public String getExtensionPointId() {
                return "org.teiid.designer.spi.teiidPasswordProvider";
            }

            public String getElementId() {
                return "passwordProvider";
            }

            public String getAttributeId() {
                return "class";
            }

            public boolean isSingle() {
                return true;
            }

            public void process(IPasswordProvider instance, IConfigurationElement element) {
                passwordProviders.add(instance);
            }
        };
        ExtensionRegistryUtils.createExtensionInstances((IExtensionRegistryCallback)callback);
        if (passwordProviders.isEmpty()) {
            DqpPlugin.Util.log((Object)"No password provider implementation installed.");
            return null;
        }
        return (IPasswordProvider)passwordProviders.get(0);
    }

    public ITeiidDataSource createDataSource(ITeiidServer teiidServer, IFile model, String jndiName, boolean previewVdb) throws Exception {
        ITeiidDataSource dataSource = teiidServer.getDataSource(jndiName);
        if (dataSource != null) {
            return dataSource;
        }
        ConnectionInfoProviderFactory manager = new ConnectionInfoProviderFactory();
        ModelResource modelResource = ModelUtil.getModelResource((IFile)model, (boolean)true);
        if (!manager.hasProvider(modelResource)) {
            return new FailedTeiidDataSource(model.getFullPath().removeFileExtension().lastSegment(), jndiName, 104);
        }
        IConnectionInfoProvider connInfoProvider = manager.getProvider(modelResource);
        if (connInfoProvider == null) {
            return null;
        }
        IConnectionProfile modelConnectionProfile = connInfoProvider.getConnectionProfile(modelResource);
        if (modelConnectionProfile == null) {
            return new FailedTeiidDataSource(model.getFullPath().removeFileExtension().lastSegment(), jndiName, 105);
        }
        Properties props = connInfoProvider.getTeiidRelatedProperties(modelConnectionProfile);
        if (props.isEmpty()) {
            return new FailedTeiidDataSource(model.getFullPath().removeFileExtension().lastSegment(), jndiName, 106);
        }
        String dataSourceType = connInfoProvider.getDataSourceType();
        String dsPasswordKey = connInfoProvider.getDataSourcePasswordPropertyKey();
        boolean requiresPassword = dsPasswordKey != null && connInfoProvider.requiresPassword(modelConnectionProfile);
        String pwd = null;
        if (requiresPassword) {
            pwd = modelConnectionProfile.getBaseProperties().getProperty(connInfoProvider.getPasswordPropertyKey());
            if (pwd == null) {
                IConnectionProfile existingConnectionProfile = ProfileManager.getInstance().getProfileByName(modelConnectionProfile.getName());
                if (existingConnectionProfile != null && props.getProperty(connInfoProvider.getPasswordPropertyKey()) == null) {
                    pwd = existingConnectionProfile.getBaseProperties().getProperty(connInfoProvider.getPasswordPropertyKey());
                }
                IPasswordProvider passwordProvider = this.getPasswordProvider();
                if (pwd == null && passwordProvider != null) {
                    pwd = passwordProvider.getPassword(modelResource.getItemName(), modelConnectionProfile.getName());
                }
            }
            if (pwd != null) {
                props.setProperty(dsPasswordKey, pwd);
            }
        }
        if (requiresPassword && pwd == null) {
            return new FailedTeiidDataSource(model.getFullPath().removeFileExtension().lastSegment(), jndiName, 108);
        }
        ITeiidDataSource tds = teiidServer.getOrCreateDataSource(jndiName, jndiName, dataSourceType, props);
        tds.setPreview(previewVdb);
        return tds;
    }
}

