/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.PictogramsFactory;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.util.IColorConstant;

public class ShapeDecoratorUtil {
    static final IGaService gaService = Graphiti.getGaService();
    static final IPeService peService = Graphiti.getPeService();
    private static final String DELETABLE_PROPERTY = "deletable";
    public static final int GATEWAY_RADIUS = 25;
    public static final int EVENT_SIZE = 36;
    public static final int TASK_IMAGE_SIZE = 16;
    public static final int MARKER_WIDTH = 10;
    public static final int MARKER_HEIGHT = 10;

    private static int generateRatioPointValue(float originalPointValue, float ratioValue) {
        return Math.round(Float.valueOf(originalPointValue * ratioValue).floatValue());
    }

    private static float calculateRatio(float x, float y) {
        return x / y;
    }

    static int getShapeHeight(Shape shape) {
        return shape.getGraphicsAlgorithm().getHeight();
    }

    static int getShapeWidth(Shape shape) {
        return shape.getGraphicsAlgorithm().getWidth();
    }

    public static Shape getContainedShape(ContainerShape container, String propertyKey) {
        for (Shape shape : peService.getAllContainedShapes(container)) {
            String property = peService.getPropertyValue((PropertyContainer)shape, propertyKey);
            if (property == null || !new Boolean(property).booleanValue()) continue;
            return shape;
        }
        return null;
    }

    public static List<PictogramElement> getContainedPictogramElements(PictogramElement container, String propertyKey) {
        ArrayList<PictogramElement> pictogramElements = new ArrayList<PictogramElement>();
        for (PictogramElement pe : peService.getAllContainedPictogramElements(container)) {
            String property = peService.getPropertyValue((PropertyContainer)pe, propertyKey);
            if (property == null || !new Boolean(property).booleanValue()) continue;
            pictogramElements.add(pe);
        }
        return pictogramElements;
    }

    public static Polygon createGateway(Shape container, int width, int height) {
        int widthRadius = width / 2;
        int heightRadius = height / 2;
        int[] nArray = new int[8];
        nArray[1] = heightRadius;
        nArray[2] = widthRadius;
        nArray[4] = 2 * widthRadius;
        nArray[5] = heightRadius;
        nArray[6] = widthRadius;
        nArray[7] = 2 * heightRadius;
        int[] gateWayPoints = nArray;
        return gaService.createPolygon((GraphicsAlgorithmContainer)container, gateWayPoints);
    }

    public static Polygon createGatewayPentagon(ContainerShape container) {
        Shape pentagonShape = peService.createShape(container, false);
        int gatewayHeight = ShapeDecoratorUtil.getShapeHeight((Shape)container);
        int gatewayWidth = ShapeDecoratorUtil.getShapeWidth((Shape)container);
        float heightRatio = ShapeDecoratorUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        Polygon pentagon = gaService.createPolygon((GraphicsAlgorithmContainer)pentagonShape, new int[]{gatewayWidth / 2, ShapeDecoratorUtil.generateRatioPointValue(18.0f, heightRatio), gatewayWidth / 2 + ShapeDecoratorUtil.generateRatioPointValue(8.0f, widthRatio), gatewayHeight / 2 - ShapeDecoratorUtil.generateRatioPointValue(2.0f, heightRatio), gatewayWidth / 2 + ShapeDecoratorUtil.generateRatioPointValue(5.0f, widthRatio), gatewayHeight / 2 + ShapeDecoratorUtil.generateRatioPointValue(7.0f, heightRatio), gatewayWidth / 2 - ShapeDecoratorUtil.generateRatioPointValue(5.0f, widthRatio), gatewayHeight / 2 + ShapeDecoratorUtil.generateRatioPointValue(7.0f, heightRatio), gatewayWidth / 2 - ShapeDecoratorUtil.generateRatioPointValue(8.0f, widthRatio), gatewayHeight / 2 - ShapeDecoratorUtil.generateRatioPointValue(2.0f, heightRatio)});
        peService.setPropertyValue((PropertyContainer)pentagonShape, DELETABLE_PROPERTY, "true");
        return pentagon;
    }

    public static Ellipse createGatewayInnerCircle(Ellipse outer) {
        int gatewayHeight = outer.getHeight();
        int gatewayWidth = outer.getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        Float x = Float.valueOf(5.0f * widthRatio * new Float(0.8).floatValue());
        Float y = Float.valueOf(5.0f * heightRatio * new Float(0.8).floatValue());
        Float width = Float.valueOf((float)gatewayHeight * new Float(0.8).floatValue());
        Float height = Float.valueOf((float)gatewayWidth * new Float(0.8).floatValue());
        Ellipse ellipse = gaService.createEllipse((GraphicsAlgorithmContainer)outer);
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, Math.round(x.floatValue()), Math.round(y.floatValue()), Math.round(width.floatValue()), Math.round(height.floatValue()));
        ellipse.setFilled(Boolean.valueOf(false));
        ellipse.setLineWidth(Integer.valueOf(1));
        peService.setPropertyValue((PropertyContainer)ellipse, DELETABLE_PROPERTY, "true");
        return ellipse;
    }

    public static Ellipse createGatewayOuterCircle(ContainerShape container) {
        Shape ellipseShape = peService.createShape(container, false);
        Ellipse ellipse = gaService.createEllipse((GraphicsAlgorithmContainer)ellipseShape);
        int gatewayHeight = ShapeDecoratorUtil.getShapeHeight((Shape)container);
        int gatewayWidth = ShapeDecoratorUtil.getShapeWidth((Shape)container);
        float heightRatio = ShapeDecoratorUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, ShapeDecoratorUtil.generateRatioPointValue(12.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(12.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(27.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(27.0f, heightRatio));
        ellipse.setFilled(Boolean.valueOf(false));
        ellipse.setLineWidth(Integer.valueOf(1));
        peService.setPropertyValue((PropertyContainer)ellipseShape, DELETABLE_PROPERTY, "true");
        return ellipse;
    }

    public static Cross createGatewayCross(ContainerShape container) {
        Shape verticalShape = peService.createShape(container, false);
        int gatewayHeight = ShapeDecoratorUtil.getShapeHeight((Shape)container);
        int gatewayWidth = ShapeDecoratorUtil.getShapeWidth((Shape)container);
        float heightRatio = ShapeDecoratorUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        Polyline verticalLine = gaService.createPolyline((GraphicsAlgorithmContainer)verticalShape, new int[]{ShapeDecoratorUtil.generateRatioPointValue(24.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(7.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(24.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(43.0f, heightRatio)});
        verticalLine.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)verticalShape, DELETABLE_PROPERTY, "false");
        Shape horizontalShape = peService.createShape(container, false);
        Polyline horizontalLine = gaService.createPolyline((GraphicsAlgorithmContainer)horizontalShape, new int[]{ShapeDecoratorUtil.generateRatioPointValue(7.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(24.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(43.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(24.0f, heightRatio)});
        horizontalLine.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)horizontalShape, DELETABLE_PROPERTY, "false");
        Cross cross = new Cross();
        cross.vertical = verticalLine;
        cross.horizontal = horizontalLine;
        return cross;
    }

    public static DiagonalCross createGatewayDiagonalCross(ContainerShape container) {
        int gatewayHeight = ShapeDecoratorUtil.getShapeHeight((Shape)container);
        int gatewayWidth = ShapeDecoratorUtil.getShapeWidth((Shape)container);
        float heightRatio = ShapeDecoratorUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        Shape diagonalDescShape = peService.createShape(container, false);
        Polyline diagonalDesc = gaService.createPolyline((GraphicsAlgorithmContainer)diagonalDescShape, new int[]{ShapeDecoratorUtil.generateRatioPointValue(14.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(14.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(37.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(37.0f, heightRatio)});
        diagonalDesc.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)diagonalDescShape, DELETABLE_PROPERTY, "true");
        Shape diagonalAscShape = peService.createShape(container, false);
        Polyline diagonalAsc = gaService.createPolyline((GraphicsAlgorithmContainer)diagonalAscShape, new int[]{ShapeDecoratorUtil.generateRatioPointValue(37.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(14.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(14.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(37.0f, heightRatio)});
        diagonalAsc.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)diagonalAscShape, DELETABLE_PROPERTY, "true");
        DiagonalCross diagonalCross = new DiagonalCross();
        diagonalCross.diagonalDesc = diagonalDesc;
        diagonalCross.diagonalAsc = diagonalAsc;
        return diagonalCross;
    }

    public static Polygon createEventGatewayParallelCross(ContainerShape container) {
        Shape crossShape = peService.createShape(container, false);
        int gatewayHeight = ShapeDecoratorUtil.getShapeHeight((Shape)container);
        int gatewayWidth = ShapeDecoratorUtil.getShapeWidth((Shape)container);
        float heightRatio = ShapeDecoratorUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        int n1x = ShapeDecoratorUtil.generateRatioPointValue(14.0f, widthRatio);
        int n1y = ShapeDecoratorUtil.generateRatioPointValue(14.0f, heightRatio);
        int n2x = ShapeDecoratorUtil.generateRatioPointValue(22.0f, widthRatio);
        int n2y = ShapeDecoratorUtil.generateRatioPointValue(22.0f, heightRatio);
        int n3x = ShapeDecoratorUtil.generateRatioPointValue(28.0f, widthRatio);
        int n3y = ShapeDecoratorUtil.generateRatioPointValue(28.0f, heightRatio);
        int n4x = ShapeDecoratorUtil.generateRatioPointValue(36.0f, widthRatio);
        int n4y = ShapeDecoratorUtil.generateRatioPointValue(36.0f, heightRatio);
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(gaService.createPoint(n1x, n2y));
        points.add(gaService.createPoint(n2x, n2y));
        points.add(gaService.createPoint(n2x, n1y));
        points.add(gaService.createPoint(n3x, n1y));
        points.add(gaService.createPoint(n3x, n2y));
        points.add(gaService.createPoint(n4x, n2y));
        points.add(gaService.createPoint(n4x, n3y));
        points.add(gaService.createPoint(n3x, n3y));
        points.add(gaService.createPoint(n3x, n4y));
        points.add(gaService.createPoint(n2x, n4y));
        points.add(gaService.createPoint(n2x, n3y));
        points.add(gaService.createPoint(n1x, n3y));
        Polygon cross = gaService.createPolygon((GraphicsAlgorithmContainer)crossShape, points);
        cross.setFilled(Boolean.valueOf(false));
        cross.setLineWidth(Integer.valueOf(1));
        peService.setPropertyValue((PropertyContainer)crossShape, DELETABLE_PROPERTY, "true");
        return cross;
    }

    public static Asterisk createGatewayAsterisk(ContainerShape container) {
        int gatewayHeight = ShapeDecoratorUtil.getShapeHeight((Shape)container);
        int gatewayWidth = ShapeDecoratorUtil.getShapeWidth((Shape)container);
        float heightRatio = ShapeDecoratorUtil.calculateRatio(gatewayHeight, Float.valueOf(50.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(gatewayWidth, Float.valueOf(50.0f).floatValue());
        Shape verticalShape = peService.createShape(container, false);
        Polyline vertical = gaService.createPolyline((GraphicsAlgorithmContainer)verticalShape, new int[]{ShapeDecoratorUtil.generateRatioPointValue(24.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(7.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(24.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(43.0f, heightRatio)});
        vertical.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)verticalShape, DELETABLE_PROPERTY, "true");
        Shape horizontalShape = peService.createShape(container, false);
        Polyline horizontal = gaService.createPolyline((GraphicsAlgorithmContainer)horizontalShape, new int[]{ShapeDecoratorUtil.generateRatioPointValue(7.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(24.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(43.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(24.0f, heightRatio)});
        horizontal.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)horizontalShape, DELETABLE_PROPERTY, "true");
        Shape diagonalDescShape = peService.createShape(container, false);
        Polyline diagonalDesc = gaService.createPolyline((GraphicsAlgorithmContainer)diagonalDescShape, new int[]{ShapeDecoratorUtil.generateRatioPointValue(14.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(14.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(37.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(37.0f, heightRatio)});
        diagonalDesc.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)diagonalDescShape, DELETABLE_PROPERTY, "true");
        Shape diagonalAscShape = peService.createShape(container, false);
        Polyline diagonalAsc = gaService.createPolyline((GraphicsAlgorithmContainer)diagonalAscShape, new int[]{ShapeDecoratorUtil.generateRatioPointValue(37.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(14.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(14.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(37.0f, heightRatio)});
        diagonalAsc.setLineWidth(Integer.valueOf(3));
        peService.setPropertyValue((PropertyContainer)diagonalAscShape, DELETABLE_PROPERTY, "true");
        Asterisk a = new Asterisk();
        a.horizontal = horizontal;
        a.vertical = vertical;
        a.diagonalDesc = diagonalDesc;
        a.diagonalAsc = diagonalAsc;
        return a;
    }

    public static void clearGateway(PictogramElement element) {
        for (PictogramElement pe : ShapeDecoratorUtil.getContainedPictogramElements(element, DELETABLE_PROPERTY)) {
            peService.deletePictogramElement(pe);
        }
    }

    public static Ellipse createEventShape(Shape container, int width, int height) {
        Ellipse ellipse = gaService.createEllipse((GraphicsAlgorithmContainer)container);
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, 0, 0, width, height);
        return ellipse;
    }

    public static Envelope createEventEnvelope(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        return ShapeDecoratorUtil.createEnvelope((GraphicsAlgorithmContainer)shape, ShapeDecoratorUtil.generateRatioPointValue(9.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(12.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(18.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(14.0f, heightRatio));
    }

    public static Polygon createEventPentagon(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        return gaService.createPolygon((GraphicsAlgorithmContainer)shape, new int[]{eventWidth / 2, ShapeDecoratorUtil.generateRatioPointValue(7.0f, heightRatio), eventWidth / 2 + ShapeDecoratorUtil.generateRatioPointValue(10.0f, widthRatio), eventHeight / 2 - ShapeDecoratorUtil.generateRatioPointValue(4.0f, heightRatio), eventWidth / 2 + ShapeDecoratorUtil.generateRatioPointValue(7.0f, widthRatio), eventHeight / 2 + ShapeDecoratorUtil.generateRatioPointValue(10.0f, heightRatio), eventWidth / 2 - ShapeDecoratorUtil.generateRatioPointValue(7.0f, widthRatio), eventHeight / 2 + ShapeDecoratorUtil.generateRatioPointValue(10.0f, heightRatio), eventWidth / 2 - ShapeDecoratorUtil.generateRatioPointValue(10.0f, widthRatio), eventHeight / 2 - ShapeDecoratorUtil.generateRatioPointValue(4.0f, heightRatio)});
    }

    public static Ellipse createIntermediateEventCircle(Ellipse ellipse) {
        int eventHeight = ellipse.getHeight();
        int eventWidth = ellipse.getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        Float x = Float.valueOf(5.0f * widthRatio * new Float(0.8).floatValue());
        Float y = Float.valueOf(5.0f * heightRatio * new Float(0.8).floatValue());
        Float width = Float.valueOf((float)eventWidth * new Float(0.8).floatValue());
        Float height = Float.valueOf((float)eventHeight * new Float(0.8).floatValue());
        Ellipse circle = gaService.createEllipse((GraphicsAlgorithmContainer)ellipse);
        gaService.setLocationAndSize((GraphicsAlgorithm)circle, Math.round(x.floatValue()), Math.round(y.floatValue()), width.intValue(), height.intValue());
        circle.setLineWidth(Integer.valueOf(1));
        circle.setFilled(Boolean.valueOf(false));
        return circle;
    }

    public static Image createEventImage(Shape shape, String imageId) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        Image image = gaService.createImage((GraphicsAlgorithmContainer)shape, imageId);
        image.setProportional(Boolean.valueOf(true));
        gaService.setLocationAndSize((GraphicsAlgorithm)image, ShapeDecoratorUtil.generateRatioPointValue(8.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(8.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(20.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(20.0f, heightRatio));
        return image;
    }

    public static Polygon createEventSignal(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        Polygon polygon = gaService.createPolygon((GraphicsAlgorithmContainer)shape, new int[]{ShapeDecoratorUtil.generateRatioPointValue(16.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(4.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(28.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(26.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(7.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(26.0f, heightRatio)});
        polygon.setLineWidth(Integer.valueOf(1));
        return polygon;
    }

    public static Polygon createEventEscalation(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        int heightRadius = eventHeight / 2;
        int widthRadius = eventWidth / 2;
        int[] points = new int[]{widthRadius, ShapeDecoratorUtil.generateRatioPointValue(8.0f, heightRatio), widthRadius + ShapeDecoratorUtil.generateRatioPointValue(8.0f, widthRatio), heightRadius + ShapeDecoratorUtil.generateRatioPointValue(9.0f, heightRatio), widthRadius, heightRadius + ShapeDecoratorUtil.generateRatioPointValue(2.0f, heightRatio), widthRadius - ShapeDecoratorUtil.generateRatioPointValue(8.0f, widthRatio), heightRadius + ShapeDecoratorUtil.generateRatioPointValue(9.0f, heightRatio)};
        Polygon polygon = gaService.createPolygon((GraphicsAlgorithmContainer)shape, points);
        polygon.setLineWidth(Integer.valueOf(1));
        return polygon;
    }

    public static Compensation createEventCompensation(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        Rectangle rect = gaService.createInvisibleRectangle((PictogramElement)shape);
        int w = ShapeDecoratorUtil.generateRatioPointValue(22.0f, widthRatio);
        int h = ShapeDecoratorUtil.generateRatioPointValue(18.0f, heightRatio);
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, ShapeDecoratorUtil.generateRatioPointValue(5.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(9.0f, heightRatio), w, h);
        int _w = w / 2;
        int _h = h / 2;
        int[] nArray = new int[6];
        nArray[0] = _w;
        nArray[2] = _w;
        nArray[3] = h;
        nArray[5] = _h;
        int[] pontsArrow1 = nArray;
        Polygon arrow1 = gaService.createPolygon((GraphicsAlgorithmContainer)rect, pontsArrow1);
        int[] nArray2 = new int[6];
        nArray2[0] = w;
        nArray2[2] = w;
        nArray2[3] = h;
        nArray2[4] = w / 2;
        nArray2[5] = _h;
        int[] pontsArrow2 = nArray2;
        Polygon arrow2 = gaService.createPolygon((GraphicsAlgorithmContainer)rect, pontsArrow2);
        Compensation compensation = new Compensation();
        compensation.arrow1 = arrow1;
        compensation.arrow2 = arrow2;
        return compensation;
    }

    public static Polygon createEventLink(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        int heightRadius = eventHeight / 2;
        int[] points = new int[]{ShapeDecoratorUtil.generateRatioPointValue(32.0f, widthRatio), heightRadius, ShapeDecoratorUtil.generateRatioPointValue(23.0f, widthRatio), heightRadius + ShapeDecoratorUtil.generateRatioPointValue(11.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(23.0f, widthRatio), heightRadius + ShapeDecoratorUtil.generateRatioPointValue(6.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(5.0f, widthRatio), heightRadius + ShapeDecoratorUtil.generateRatioPointValue(6.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(5.0f, widthRatio), heightRadius - ShapeDecoratorUtil.generateRatioPointValue(6.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(23.0f, widthRatio), heightRadius - ShapeDecoratorUtil.generateRatioPointValue(6.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(23.0f, widthRatio), heightRadius - ShapeDecoratorUtil.generateRatioPointValue(11.0f, heightRatio)};
        Polygon polygon = gaService.createPolygon((GraphicsAlgorithmContainer)shape, points);
        polygon.setLineWidth(Integer.valueOf(1));
        return polygon;
    }

    public static Polygon createEventError(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        int heightRadius = eventHeight / 2;
        int widthRadius = eventWidth / 2;
        int[] points = new int[]{widthRadius + ShapeDecoratorUtil.generateRatioPointValue(4.0f, widthRatio), heightRadius, widthRadius + ShapeDecoratorUtil.generateRatioPointValue(10.0f, widthRatio), heightRadius - ShapeDecoratorUtil.generateRatioPointValue(10.0f, heightRatio), widthRadius + ShapeDecoratorUtil.generateRatioPointValue(7.0f, widthRatio), heightRadius + ShapeDecoratorUtil.generateRatioPointValue(10.0f, heightRatio), widthRadius - ShapeDecoratorUtil.generateRatioPointValue(4.0f, widthRatio), heightRadius, widthRadius - ShapeDecoratorUtil.generateRatioPointValue(10.0f, widthRatio), heightRadius + ShapeDecoratorUtil.generateRatioPointValue(10.0f, heightRatio), widthRadius - ShapeDecoratorUtil.generateRatioPointValue(7.0f, widthRatio), heightRadius - ShapeDecoratorUtil.generateRatioPointValue(10.0f, heightRatio)};
        Polygon polygon = gaService.createPolygon((GraphicsAlgorithmContainer)shape, points);
        polygon.setLineWidth(Integer.valueOf(1));
        return polygon;
    }

    public static Polygon createEventCancel(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        int heightRadius = eventHeight / 2;
        int widthRadius = eventWidth / 2;
        int a1 = ShapeDecoratorUtil.generateRatioPointValue(9.0f, widthRatio);
        int a2 = ShapeDecoratorUtil.generateRatioPointValue(9.0f, heightRatio);
        int b1 = ShapeDecoratorUtil.generateRatioPointValue(12.0f, widthRatio);
        int b2 = ShapeDecoratorUtil.generateRatioPointValue(12.0f, heightRatio);
        int c1 = ShapeDecoratorUtil.generateRatioPointValue(4.0f, widthRatio);
        int c2 = ShapeDecoratorUtil.generateRatioPointValue(4.0f, heightRatio);
        int[] points = new int[]{widthRadius, heightRadius - c2, widthRadius + a1, heightRadius - b2, widthRadius + b1, heightRadius - a2, widthRadius + c1, heightRadius, widthRadius + b1, heightRadius + a2, widthRadius + a1, heightRadius + b2, widthRadius, heightRadius + c2, widthRadius - a1, heightRadius + b2, widthRadius - b1, heightRadius + a2, widthRadius - c1, heightRadius, widthRadius - b1, heightRadius - a2, widthRadius - a1, heightRadius - b2};
        Polygon polygon = gaService.createPolygon((GraphicsAlgorithmContainer)shape, points);
        polygon.setLineWidth(Integer.valueOf(1));
        return polygon;
    }

    public static Ellipse createEventTerminate(Shape terminateShape) {
        int eventHeight = terminateShape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = terminateShape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        Ellipse ellipse = gaService.createEllipse((GraphicsAlgorithmContainer)terminateShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, ShapeDecoratorUtil.generateRatioPointValue(6.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(6.0f, heightRatio), eventWidth - ShapeDecoratorUtil.generateRatioPointValue(12.0f, widthRatio), eventHeight - ShapeDecoratorUtil.generateRatioPointValue(12.0f, heightRatio));
        ellipse.setLineWidth(Integer.valueOf(1));
        ellipse.setFilled(Boolean.valueOf(true));
        return ellipse;
    }

    public static Ellipse createEventNotAllowed(Shape shape) {
        int eventHeight = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int eventWidth = shape.getContainer().getGraphicsAlgorithm().getWidth();
        float heightRatio = ShapeDecoratorUtil.calculateRatio(eventHeight, Float.valueOf(36.0f).floatValue());
        float widthRatio = ShapeDecoratorUtil.calculateRatio(eventWidth, Float.valueOf(36.0f).floatValue());
        Ellipse ellipse = gaService.createEllipse((GraphicsAlgorithmContainer)shape);
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, ShapeDecoratorUtil.generateRatioPointValue(6.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(6.0f, heightRatio), eventWidth - ShapeDecoratorUtil.generateRatioPointValue(12.0f, widthRatio), eventHeight - ShapeDecoratorUtil.generateRatioPointValue(12.0f, heightRatio));
        ellipse.setLineWidth(Integer.valueOf(2));
        ellipse.setFilled(Boolean.valueOf(false));
        ellipse.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)shape, IColorConstant.RED));
        int[] points = new int[]{ShapeDecoratorUtil.generateRatioPointValue(8.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(12.0f, heightRatio), ShapeDecoratorUtil.generateRatioPointValue(28.0f, widthRatio), ShapeDecoratorUtil.generateRatioPointValue(24.0f, heightRatio)};
        shape = peService.createShape(shape.getContainer(), false);
        Polyline polygon = gaService.createPolyline((GraphicsAlgorithmContainer)shape, points);
        polygon.setLineWidth(Integer.valueOf(2));
        polygon.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)shape, IColorConstant.RED));
        return ellipse;
    }

    public static Polygon createEventParallelMultiple(Shape shape) {
        int h = shape.getContainer().getGraphicsAlgorithm().getHeight();
        int w = shape.getContainer().getGraphicsAlgorithm().getWidth();
        int w0 = w / 5;
        int h0 = h / 5;
        int x = 2 * w0;
        int y = h0;
        int[] points = new int[]{x, y, x + w0, y, x + w0, y + h0, x + w0 + w0, y + h0, x + w0 + w0, y + h0 + h0, x + w0, y + h0 + h0, x + w0, y + h0 + h0 + h0, x, y + h0 + h0 + h0, x, y + h0 + h0, x - w0, y + h0 + h0, x - w0, y + h0, x, y + h0, x, y};
        Polygon cross = gaService.createPolygon((GraphicsAlgorithmContainer)shape, points);
        cross.setFilled(Boolean.valueOf(false));
        cross.setLineWidth(Integer.valueOf(1));
        return cross;
    }

    public static void deleteEventShape(ContainerShape containerShape) {
        ArrayList shapes = new ArrayList();
        shapes.addAll(containerShape.getChildren());
        for (PictogramElement shape : shapes) {
            String property = peService.getPropertyValue((PropertyContainer)shape, "event.definition.shape");
            if (property == null) continue;
            peService.deletePictogramElement(shape);
        }
    }

    public static Envelope createEnvelope(GraphicsAlgorithmContainer gaContainer, int x, int y, int w, int h) {
        Rectangle rect = gaService.createRectangle(gaContainer);
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, x, y, w, h);
        rect.setFilled(Boolean.valueOf(false));
        int[] nArray = new int[6];
        nArray[2] = w / 2;
        nArray[3] = h / 2;
        nArray[4] = w;
        Polyline line = gaService.createPolyline((GraphicsAlgorithmContainer)rect, nArray);
        Envelope envelope = new Envelope();
        envelope.rect = rect;
        envelope.line = line;
        return envelope;
    }

    public static Polygon createDataArrow(Polygon p) {
        int[] points = new int[]{4, 8, 14, 8, 14, 4, 18, 10, 14, 16, 14, 12, 4, 12};
        Polygon arrow = gaService.createPolygon((GraphicsAlgorithmContainer)p, points);
        arrow.setLineWidth(Integer.valueOf(1));
        return arrow;
    }

    private static GraphicsAlgorithmContainer createActivityMarkerCompensate(ContainerShape markerContainer) {
        GraphicsAlgorithmContainer algorithmContainer = ShapeDecoratorUtil.createActivityMarkerGaContainer(markerContainer, "activity.marker.compensate");
        Compensation compensation = ShapeDecoratorUtil.createCompensation(algorithmContainer, 10, 10);
        compensation.arrow1.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        compensation.arrow2.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        return algorithmContainer;
    }

    private static GraphicsAlgorithmContainer createActivityMarkerStandardLoop(ContainerShape markerContainer) {
        GraphicsAlgorithmContainer algorithmContainer = ShapeDecoratorUtil.createActivityMarkerGaContainer(markerContainer, "activity.marker.lc.standard");
        int[] nArray = new int[10];
        nArray[0] = 8;
        nArray[1] = 10;
        nArray[2] = 10;
        nArray[3] = 5;
        nArray[4] = 5;
        nArray[7] = 5;
        nArray[8] = 3;
        nArray[9] = 10;
        int[] xy = nArray;
        int[] nArray2 = new int[10];
        nArray2[2] = 3;
        nArray2[3] = 4;
        nArray2[4] = 4;
        nArray2[5] = 4;
        nArray2[6] = 4;
        nArray2[7] = 3;
        nArray2[8] = 3;
        int[] bend = nArray2;
        Polyline circle = gaService.createPolyline(algorithmContainer, xy, bend);
        Loop loop = new Loop();
        loop.circle = circle;
        int[] nArray3 = new int[6];
        nArray3[0] = 5;
        nArray3[1] = 5;
        nArray3[2] = 5;
        nArray3[3] = 10;
        nArray3[5] = 10;
        loop.arrow = gaService.createPolyline(algorithmContainer, nArray3);
        loop.circle.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        loop.arrow.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        return algorithmContainer;
    }

    private static GraphicsAlgorithmContainer createActivityMarkerMultiParallel(ContainerShape markerContainer) {
        GraphicsAlgorithmContainer algorithmContainer = ShapeDecoratorUtil.createActivityMarkerGaContainer(markerContainer, "activity.marker.lc.multi.parallel");
        MultiInstance multiInstance = new MultiInstance();
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[2] = 2;
        nArray[3] = 10;
        multiInstance.line1 = gaService.createPolyline(algorithmContainer, nArray);
        int[] nArray2 = new int[4];
        nArray2[0] = 5;
        nArray2[2] = 5;
        nArray2[3] = 10;
        multiInstance.line2 = gaService.createPolyline(algorithmContainer, nArray2);
        int[] nArray3 = new int[4];
        nArray3[0] = 8;
        nArray3[2] = 8;
        nArray3[3] = 10;
        multiInstance.line3 = gaService.createPolyline(algorithmContainer, nArray3);
        multiInstance.line1.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        multiInstance.line2.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        multiInstance.line3.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        return algorithmContainer;
    }

    private static GraphicsAlgorithmContainer createActivityMarkerMultiSequential(ContainerShape markerContainer) {
        GraphicsAlgorithmContainer algorithmContainer = ShapeDecoratorUtil.createActivityMarkerGaContainer(markerContainer, "activity.marker.lc.multi.sequential");
        MultiInstance multiInstance = new MultiInstance();
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 10;
        nArray[3] = 2;
        multiInstance.line1 = gaService.createPolyline(algorithmContainer, nArray);
        int[] nArray2 = new int[4];
        nArray2[1] = 5;
        nArray2[2] = 10;
        nArray2[3] = 5;
        multiInstance.line2 = gaService.createPolyline(algorithmContainer, nArray2);
        int[] nArray3 = new int[4];
        nArray3[1] = 8;
        nArray3[2] = 10;
        nArray3[3] = 8;
        multiInstance.line3 = gaService.createPolyline(algorithmContainer, nArray3);
        multiInstance.line1.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        multiInstance.line2.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        multiInstance.line3.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        return algorithmContainer;
    }

    private static GraphicsAlgorithmContainer createActivityMarkerAdHoc(ContainerShape markerContainer) {
        GraphicsAlgorithmContainer algorithmContainer = ShapeDecoratorUtil.createActivityMarkerGaContainer(markerContainer, "activity.marker.adhoc");
        int[] nArray = new int[8];
        nArray[1] = 8;
        nArray[2] = 3;
        nArray[3] = 2;
        nArray[4] = 7;
        nArray[5] = 8;
        nArray[6] = 10;
        nArray[7] = 2;
        int[] xy = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 3;
        nArray2[2] = 3;
        nArray2[3] = 3;
        nArray2[4] = 3;
        nArray2[5] = 3;
        nArray2[6] = 3;
        int[] bend = nArray2;
        Polyline tilde = gaService.createPolyline(algorithmContainer, xy, bend);
        tilde.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        return algorithmContainer;
    }

    private static GraphicsAlgorithmContainer createActivityMarkerExpand(ContainerShape markerContainer) {
        GraphicsAlgorithmContainer algorithmContainer = ShapeDecoratorUtil.createActivityMarkerGaContainer(markerContainer, "activity.marker.expand");
        Rectangle rect = gaService.createRectangle(algorithmContainer);
        rect.setFilled(Boolean.valueOf(false));
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, 0, 0, 10, 10);
        Expand expand = new Expand();
        expand.rect = rect;
        int[] nArray = new int[4];
        nArray[1] = 5;
        nArray[2] = 10;
        nArray[3] = 5;
        expand.horizontal = gaService.createPolyline(algorithmContainer, nArray);
        int[] nArray2 = new int[4];
        nArray2[0] = 5;
        nArray2[2] = 5;
        nArray2[3] = 10;
        expand.vertical = gaService.createPolyline(algorithmContainer, nArray2);
        expand.rect.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        expand.horizontal.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        expand.vertical.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)markerContainer, StyleUtil.CLASS_FOREGROUND));
        return algorithmContainer;
    }

    private static ContainerShape getActivityMarker(ContainerShape container) {
        String property = peService.getPropertyValue((PropertyContainer)container, "activity.marker.container");
        if (property != null && new Boolean(property).booleanValue()) {
            return container;
        }
        return (ContainerShape)ShapeDecoratorUtil.getContainedShape(container, "activity.marker.container");
    }

    private static ContainerShape createActivityMarker(ContainerShape container) {
        ContainerShape markerContainer = ShapeDecoratorUtil.getActivityMarker(container);
        if (markerContainer == null) {
            markerContainer = peService.createContainerShape(container, false);
            Rectangle markerInvisibleRect = gaService.createInvisibleRectangle((PictogramElement)markerContainer);
            GraphicsAlgorithm ga = container.getGraphicsAlgorithm();
            int x = ga.getWidth() / 2;
            int y = ga.getHeight() - 10;
            int w = 50;
            int h = 10;
            gaService.setLocationAndSize((GraphicsAlgorithm)markerInvisibleRect, x, y, w, h);
            peService.setPropertyValue((PropertyContainer)markerContainer, "activity.marker.container", Boolean.toString(true));
            peService.setPropertyValue((PropertyContainer)markerContainer, "activity.border", Boolean.toString(true));
            ShapeDecoratorUtil.createActivityMarkerCompensate(markerContainer);
            ShapeDecoratorUtil.createActivityMarkerStandardLoop(markerContainer);
            ShapeDecoratorUtil.createActivityMarkerMultiParallel(markerContainer);
            ShapeDecoratorUtil.createActivityMarkerMultiSequential(markerContainer);
            ShapeDecoratorUtil.createActivityMarkerAdHoc(markerContainer);
            ShapeDecoratorUtil.createActivityMarkerExpand(markerContainer);
            for (Shape shape : peService.getAllContainedShapes(markerContainer)) {
                shape.setVisible(false);
            }
        }
        return markerContainer;
    }

    public static void setActivityMarkerOffest(ContainerShape container, int offset) {
        peService.setPropertyValue((PropertyContainer)container, "activity.marker.offset", Integer.toString(offset));
    }

    public static int getActivityMarkerOffest(ContainerShape container) {
        int offset = 0;
        String s = peService.getPropertyValue((PropertyContainer)container, "activity.marker.offset");
        if (s != null) {
            try {
                offset = Integer.parseInt(s);
            }
            catch (Exception exception) {}
        }
        return offset;
    }

    public static void layoutActivityMarker(ContainerShape container) {
        ContainerShape markerContainer = ShapeDecoratorUtil.getActivityMarker(container);
        if (markerContainer != null) {
            GraphicsAlgorithm ga;
            int lastX = 0;
            for (Shape marker : peService.getAllContainedShapes(markerContainer)) {
                if (!marker.isVisible()) continue;
                ga = marker.getGraphicsAlgorithm();
                gaService.setLocation(ga, lastX, 0);
                lastX += ga.getWidth() + 3;
            }
            GraphicsAlgorithm parentGa = container.getGraphicsAlgorithm();
            ga = markerContainer.getGraphicsAlgorithm();
            int newWidth = parentGa.getWidth();
            int newHeight = parentGa.getHeight();
            int x = newWidth / 2 - lastX / 2;
            int y = newHeight - 13 - ShapeDecoratorUtil.getActivityMarkerOffest(container);
            gaService.setLocation(ga, x, y);
        }
    }

    public static void showActivityMarker(ContainerShape container, String property) {
        ContainerShape markerContainer = ShapeDecoratorUtil.getActivityMarker(container);
        if (markerContainer == null) {
            markerContainer = ShapeDecoratorUtil.createActivityMarker(container);
        }
        ShapeDecoratorUtil.getContainedShape(markerContainer, property).setVisible(true);
        ShapeDecoratorUtil.layoutActivityMarker(container);
    }

    public static void hideActivityMarker(ContainerShape container, String property) {
        ContainerShape markerContainer = ShapeDecoratorUtil.getActivityMarker(container);
        if (markerContainer == null) {
            markerContainer = ShapeDecoratorUtil.createActivityMarker(container);
        }
        ShapeDecoratorUtil.getContainedShape(markerContainer, property).setVisible(false);
        ShapeDecoratorUtil.layoutActivityMarker(container);
    }

    public static boolean isActivityMarker(PictogramElement pe) {
        String property = peService.getPropertyValue((PropertyContainer)pe, "activity.marker.container");
        return new Boolean(property);
    }

    public static Shape createActivityBorder(ContainerShape containerShape, BaseElement businessObject) {
        Shape shape = peService.createShape(containerShape, false);
        RoundedRectangle rect = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)shape, 5, 5);
        StyleUtil.applyStyle((GraphicsAlgorithm)rect, businessObject);
        IDimension dim = gaService.calculateSize(containerShape.getGraphicsAlgorithm());
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, 0, 0, dim.getWidth(), dim.getHeight());
        peService.setPropertyValue((PropertyContainer)shape, "activity.border", Boolean.TRUE.toString());
        ShapeDecoratorUtil.link((PictogramElement)shape, (EObject)businessObject);
        return shape;
    }

    public static boolean isActivityBorder(PictogramElement pe) {
        String value = peService.getPropertyValue((PropertyContainer)pe, "activity.border");
        return new Boolean(value);
    }

    public static Image createActivityImage(ContainerShape containerShape, String imageId) {
        if (imageId != null && !imageId.trim().isEmpty()) {
            GraphicsAlgorithm ga = ((Shape)containerShape.getChildren().get(0)).getGraphicsAlgorithm();
            Image img = gaService.createImage((GraphicsAlgorithmContainer)ga, imageId.trim());
            gaService.setLocationAndSize((GraphicsAlgorithm)img, 2, 2, 16, 16);
            return img;
        }
        return null;
    }

    private static void link(PictogramElement pe, EObject object) {
        PictogramLink link = pe.getLink();
        if (link == null) {
            link = PictogramsFactory.eINSTANCE.createPictogramLink();
            pe.setLink(link);
        }
        link.getBusinessObjects().add((Object)object);
    }

    private static Color manageColor(PictogramElement pe, IColorConstant colorConstant) {
        Diagram diagram = peService.getDiagramForPictogramElement(pe);
        return gaService.manageColor(diagram, colorConstant);
    }

    private static GraphicsAlgorithmContainer createActivityMarkerGaContainer(ContainerShape markerContainer, String property) {
        GraphicsAlgorithm ga = markerContainer.getGraphicsAlgorithm();
        int totalWidth = 10;
        int parentW = ((ContainerShape)markerContainer.eContainer()).getGraphicsAlgorithm().getWidth();
        int parentH = ((ContainerShape)markerContainer.eContainer()).getGraphicsAlgorithm().getHeight();
        int lastX = 0;
        for (Shape containedShape : peService.getAllContainedShapes(markerContainer)) {
            if (!containedShape.isVisible()) continue;
            GraphicsAlgorithm containedGa = containedShape.getGraphicsAlgorithm();
            totalWidth += containedGa.getWidth();
            lastX = containedGa.getX() + containedGa.getWidth();
        }
        gaService.setLocationAndSize(ga, parentW / 2 - totalWidth / 2, parentH - 10, totalWidth, 10);
        Shape shape = peService.createShape(markerContainer, false);
        peService.setPropertyValue((PropertyContainer)shape, property, Boolean.toString(true));
        Rectangle invisibleRect = gaService.createInvisibleRectangle((PictogramElement)shape);
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRect, lastX, 0, 10, 10);
        return invisibleRect;
    }

    private static Compensation createCompensation(GraphicsAlgorithmContainer container, int w, int h) {
        int[] nArray = new int[6];
        nArray[1] = h / 2;
        nArray[2] = w / 2;
        nArray[4] = w / 2;
        nArray[5] = h;
        int[] xy = nArray;
        Polygon arrow1 = gaService.createPolygon(container, xy);
        arrow1.setFilled(Boolean.valueOf(false));
        int[] nArray2 = new int[6];
        nArray2[0] = w / 2;
        nArray2[1] = h / 2;
        nArray2[2] = w;
        nArray2[4] = w;
        nArray2[5] = h;
        xy = nArray2;
        Polygon arrow2 = gaService.createPolygon(container, xy);
        arrow2.setFilled(Boolean.valueOf(false));
        Compensation compensation = new Compensation();
        compensation.arrow1 = arrow1;
        compensation.arrow2 = arrow2;
        return compensation;
    }

    public static boolean isValidationDecorator(PictogramElement pe) {
        String value = peService.getPropertyValue((PropertyContainer)pe, "validation.decorator");
        return new Boolean(value) != false;
    }

    public static PictogramElement createValidationDecorator(ContainerShape containerShape) {
        for (PictogramElement pe : containerShape.getChildren()) {
            if (!ShapeDecoratorUtil.isValidationDecorator(pe)) continue;
            return pe;
        }
        Shape decorator = Graphiti.getPeCreateService().createShape(containerShape, true);
        peService.setPropertyValue((PropertyContainer)decorator, "validation.decorator", "true");
        Rectangle rect = Graphiti.getGaCreateService().createInvisibleRectangle((PictogramElement)decorator);
        rect.setX(-5);
        rect.setY(-5);
        rect.setWidth(0);
        rect.setHeight(0);
        return decorator;
    }

    public static ContainerShape createEventSubProcessDecorator(ContainerShape subProcessShape, boolean isInterrupting) {
        ContainerShape decoratorShape = Graphiti.getPeCreateService().createContainerShape(subProcessShape, false);
        Rectangle invisibleRect = Graphiti.getGaCreateService().createInvisibleRectangle((PictogramElement)decoratorShape);
        ContainerShape circleShape = Graphiti.getPeCreateService().createContainerShape(decoratorShape, false);
        Ellipse circle = Graphiti.getGaCreateService().createEllipse((GraphicsAlgorithmContainer)circleShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)circle, 0, 0, 20, 20);
        circle.setForeground(ShapeDecoratorUtil.manageColor((PictogramElement)decoratorShape, StyleUtil.CLASS_FOREGROUND));
        circle.setFilled(Boolean.valueOf(false));
        if (!isInterrupting) {
            circle.setLineStyle(LineStyle.DASH);
        }
        peService.setPropertyValue((PropertyContainer)decoratorShape, "event.subprocess.decorator.container", Boolean.TRUE.toString());
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRect, 1, 1, 20, 20);
        return decoratorShape;
    }

    public static boolean isEventSubProcessDecorator(PictogramElement pe) {
        String property = peService.getPropertyValue((PropertyContainer)pe, "event.subprocess.decorator.container");
        return property != null;
    }

    public static class Asterisk {
        public Polyline horizontal;
        public Polyline vertical;
        public Polyline diagonalDesc;
        public Polyline diagonalAsc;
    }

    public static class Compensation {
        public Polygon arrow1;
        public Polygon arrow2;
    }

    public static class Cross {
        public Polyline vertical;
        public Polyline horizontal;
    }

    public static class DiagonalCross {
        public Polyline diagonalAsc;
        public Polyline diagonalDesc;
    }

    public static class Envelope {
        public Rectangle rect;
        public Polyline line;
    }

    public static class Expand {
        public Rectangle rect;
        public Polyline horizontal;
        public Polyline vertical;
    }

    public static class Loop {
        public Polyline circle;
        public Polyline arrow;
    }

    public static class MultiInstance {
        public Polyline line1;
        public Polyline line2;
        public Polyline line3;
    }
}

