/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.model;

import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.di.BpmnDiPackage;
import org.eclipse.bpmn2.impl.Bpmn2FactoryImpl;
import org.eclipse.bpmn2.impl.DocumentRootImpl;
import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectPropertyProvider;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ModelExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dd.dc.DcPackage;
import org.eclipse.dd.di.DiPackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreEMap;

public class Bpmn2ModelerFactory
extends Bpmn2FactoryImpl {
    protected static boolean enableModelExtensions = true;

    public static Bpmn2ModelerFactory getInstance() {
        return (Bpmn2ModelerFactory)eINSTANCE;
    }

    public DocumentRoot createDocumentRoot() {
        Bpmn2ModelerDocumentRootImpl documentRoot = new Bpmn2ModelerDocumentRootImpl();
        return documentRoot;
    }

    public EObject create(EClass eClass) {
        EObject object = super.create(eClass);
        ObjectPropertyProvider adapter = ObjectPropertyProvider.getAdapter((EObject)this);
        try {
            TargetRuntime rt = TargetRuntime.getCurrentRuntime();
            if (rt != null) {
                String className;
                Resource resource = null;
                String customElementId = null;
                if (adapter != null) {
                    resource = adapter.getResource();
                    adapter.setResource(null);
                    customElementId = (String)adapter.getProperty("custom.element.id");
                    adapter.setProperty("custom.element.id", null);
                }
                if (!(className = eClass.getName()).equals(Bpmn2Package.eINSTANCE.getDocumentRoot().getName()) && rt.getModelDescriptor().getEPackage() != Bpmn2Package.eINSTANCE && rt.getModelDescriptor().getEPackage() != null && rt.getModelDescriptor().getEPackage().getEClassifier(className) != null) {
                    EClass clazz = (EClass)rt.getModelDescriptor().getEPackage().getEClassifier(className);
                    object = rt.getModelDescriptor().getEFactory().create(clazz);
                }
                if (customElementId != null) {
                    CustomTaskDescriptor ctd = rt.getCustomTask(customElementId);
                    if (ctd != null) {
                        ctd.populateObject(object, resource, enableModelExtensions);
                    }
                } else {
                    List<ModelExtensionDescriptor> list = rt.getModelExtensionDescriptors();
                    for (ModelExtensionDescriptor med : list) {
                        if (!className.equals(med.getType())) continue;
                        med.populateObject(object, resource, enableModelExtensions);
                    }
                    for (ModelExtensionDescriptor med : list) {
                        for (EClass st : eClass.getEAllSuperTypes()) {
                            if (!st.getName().equals(med.getType())) continue;
                            med.populateObject(object, resource, enableModelExtensions);
                        }
                    }
                }
                rt.notify(new LifecycleEvent(LifecycleEvent.EventType.BUSINESSOBJECT_CREATED, object));
            }
        }
        finally {
            if (adapter != null) {
                adapter.setResource(null);
                adapter.setProperty("custom.element.id", null);
            }
        }
        return object;
    }

    public static void setEnableModelExtensions(boolean enable) {
        enableModelExtensions = enable;
    }

    public static boolean getEnableModelExtensions() {
        return enableModelExtensions;
    }

    public static <T extends EObject> T create(Class<T> clazz) {
        return Bpmn2ModelerFactory.create(null, clazz);
    }

    public static <T extends EObject> T create(Resource resource, Class<T> clazz) {
        EClass eClass = Bpmn2ModelerFactory.getEClass(clazz);
        EObject newObject = null;
        if (eClass != null) {
            newObject = Bpmn2ModelerFactory.create(resource, eClass);
        } else {
            EClassifier eClassifier = BpmnDiPackage.eINSTANCE.getEClassifier(clazz.getSimpleName());
            if (eClassifier instanceof EClass) {
                newObject = BpmnDiFactory.eINSTANCE.create((EClass)eClassifier);
            }
        }
        return (T)newObject;
    }

    public static EObject create(Resource resource, EClass eClass) {
        Assert.isTrue((eClass != null ? 1 : 0) != 0);
        EObject newObject = null;
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(eClass);
        if (adapter != null) {
            newObject = (EObject)adapter.getObjectDescriptor().createObject(resource, eClass);
        } else {
            EPackage pkg = eClass.getEPackage();
            if (!Bpmn2ModelerFactory.isBpmnPackage(pkg)) {
                newObject = pkg.getEFactoryInstance().create(eClass);
            }
        }
        if (newObject != null) {
            TargetRuntime rt = TargetRuntime.getCurrentRuntime();
            rt.notify(new LifecycleEvent(LifecycleEvent.EventType.BUSINESSOBJECT_CREATED, newObject));
        }
        return newObject;
    }

    public void setResource(Resource resource) {
        this.eSetDirectResource((Resource.Internal)resource);
    }

    public static EObject createFeature(EObject object, EStructuralFeature feature) {
        return Bpmn2ModelerFactory.createFeature(object.eResource(), object, feature, feature.getEType().getInstanceClass());
    }

    public static EObject createFeature(EObject object, String featureName) {
        return Bpmn2ModelerFactory.createFeature(object, object.eClass().getEStructuralFeature(featureName));
    }

    public static <T extends EObject> T createFeature(EObject object, EStructuralFeature feature, Class<T> clazz) {
        return Bpmn2ModelerFactory.createFeature(object.eResource(), object, feature, clazz);
    }

    public static <T extends EObject> T createFeature(EObject object, String featureName, Class<T> clazz) {
        return Bpmn2ModelerFactory.createFeature(object, object.eClass().getEStructuralFeature(featureName), clazz);
    }

    public static EObject createFeature(EObject object, EStructuralFeature feature, EClass eClass) {
        return Bpmn2ModelerFactory.createFeature(object.eResource(), object, feature, eClass);
    }

    public static EObject createFeature(EObject object, String featureName, EClass eClass) {
        return Bpmn2ModelerFactory.createFeature(object.eResource(), object, object.eClass().getEStructuralFeature(featureName), eClass);
    }

    public static <T extends EObject> T createFeature(Resource resource, EObject object, EStructuralFeature feature, Class<T> clazz) {
        Assert.isTrue((boolean)feature.getEType().getInstanceClass().isAssignableFrom(clazz));
        EClass eClass = Bpmn2ModelerFactory.getEClass(clazz);
        return (T)Bpmn2ModelerFactory.createFeature(resource, object, feature, eClass);
    }

    public static <T extends EObject> T createFeature(Resource resource, EObject object, String featureName, Class<T> clazz) {
        return Bpmn2ModelerFactory.createFeature(resource, object, object.eClass().getEStructuralFeature(featureName), clazz);
    }

    public static EObject createFeature(Resource resource, EObject object, EStructuralFeature feature, EClass eClass) {
        ExtendedPropertiesAdapter adapter;
        Assert.isTrue((boolean)feature.getEType().getInstanceClass().isAssignableFrom(eClass.getInstanceClass()));
        EObject newObject = null;
        if (resource == null) {
            resource = object.eResource();
        }
        if ((adapter = ExtendedPropertiesAdapter.adapt(object)) != null) {
            newObject = adapter.getFeatureDescriptor(feature).createFeature(resource, eClass);
        } else {
            EPackage pkg = eClass.getEPackage();
            if (!Bpmn2ModelerFactory.isBpmnPackage(pkg)) {
                newObject = pkg.getEFactoryInstance().create(eClass);
            }
        }
        if (newObject != null) {
            TargetRuntime rt = TargetRuntime.getCurrentRuntime();
            rt.notify(new LifecycleEvent(LifecycleEvent.EventType.BUSINESSOBJECT_CREATED, newObject));
        }
        return newObject;
    }

    private static EClass getEClass(Class clazz) {
        EClassifier eClassifier = Bpmn2Package.eINSTANCE.getEClassifier(clazz.getSimpleName());
        if (eClassifier instanceof EClass) {
            return (EClass)eClassifier;
        }
        return null;
    }

    public static boolean isBpmnPackage(EPackage pkg) {
        return pkg == Bpmn2Package.eINSTANCE || pkg == BpmnDiPackage.eINSTANCE || pkg == DcPackage.eINSTANCE || pkg == DiPackage.eINSTANCE;
    }

    public static boolean isBpmnPackage(String nsURI) {
        if (nsURI == null || nsURI.isEmpty()) {
            return true;
        }
        if (!nsURI.endsWith("-XMI")) {
            nsURI = String.valueOf(nsURI) + "-XMI";
        }
        return Bpmn2Package.eINSTANCE.getNsURI().equals(nsURI) || BpmnDiPackage.eINSTANCE.getNsURI().equals(nsURI) || DcPackage.eINSTANCE.getNsURI().equals(nsURI) || DiPackage.eINSTANCE.getNsURI().equals(nsURI);
    }

    public class Bpmn2ModelerDocumentRootImpl
    extends DocumentRootImpl {
        private boolean deliver = true;

        public void setDeliver(boolean deliver) {
            this.deliver = deliver;
        }

        public Map<String, String> getXMLNSPrefixMap() {
            if (this.xMLNSPrefixMap == null) {
                this.xMLNSPrefixMap = new EcoreEMap<String, String>(EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY, EStringToStringMapEntryImpl.class, (InternalEObject)this, 1){
                    {
                        this.initializeDelegateEList();
                    }

                    protected void initializeDelegateEList() {
                        this.delegateEList = new EcoreEMap.DelegateEObjectContainmentEList<BasicEMap.Entry<String, String>>((EcoreEMap)this, this.entryClass, (InternalEObject)Bpmn2ModelerDocumentRootImpl.this, 1){

                            protected void dispatchNotification(Notification notification) {
                                if (Bpmn2ModelerDocumentRootImpl.this.deliver) {
                                    super.dispatchNotification(notification);
                                }
                            }
                        };
                    }
                };
            }
            return this.xMLNSPrefixMap.map();
        }
    }
}

