/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.event;

import java.util.List;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.modeler.core.features.activity.AbstractUpdateMarkerFeature;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public abstract class AbstractUpdateEventFeature<T extends Event>
extends AbstractUpdateMarkerFeature<T> {
    public AbstractUpdateEventFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected boolean isPropertyChanged(Event element, String propertyValue) {
        return !AbstractUpdateEventFeature.getEventDefinitionsValue(element).equals(propertyValue);
    }

    @Override
    protected void doUpdate(Event event, ContainerShape container) {
        List<EventDefinition> eventDefinitions = ModelUtil.getEventDefinitions(event);
        int size = eventDefinitions.size();
        if (size != 0) {
            EventDefinition eventDefinition = eventDefinitions.get(0);
            Shape eventDefinitionShape = null;
            block0: for (PictogramElement pe : container.getChildren()) {
                if (pe.getLink() == null) continue;
                for (EObject object : pe.getLink().getBusinessObjects()) {
                    if (eventDefinition != object) continue;
                    eventDefinitionShape = pe;
                    continue block0;
                }
            }
            if (eventDefinitionShape == null) {
                eventDefinitionShape = Graphiti.getPeService().createShape(container, true);
                Graphiti.getCreateService().createRectangle((GraphicsAlgorithmContainer)eventDefinitionShape);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)eventDefinitionShape, "event.definition.shape", Boolean.toString(true));
                this.link((PictogramElement)eventDefinitionShape, eventDefinition);
            }
            UpdateContext context = new UpdateContext(eventDefinitionShape);
            IUpdateFeature upateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
            if (upateFeature != null) {
                context = new UpdateContext((PictogramElement)container);
                upateFeature.update((IUpdateContext)context);
            }
        } else {
            ShapeDecoratorUtil.deleteEventShape(container);
        }
    }

    @Override
    protected String convertPropertyToString(Event element) {
        return AbstractUpdateEventFeature.getEventDefinitionsValue(element);
    }

    public static String getEventDefinitionsValue(Event element) {
        String result = "";
        List<EventDefinition> eventDefinitions = ModelUtil.getEventDefinitions(element);
        for (EventDefinition ed : eventDefinitions) {
            if (!result.isEmpty()) {
                result = String.valueOf(result) + " ";
            }
            result = String.valueOf(result) + ed.getId();
        }
        if (element instanceof CatchEvent && ((CatchEvent)element).isParallelMultiple()) {
            result = String.valueOf(result) + "+";
        }
        if (element instanceof StartEvent && ((StartEvent)element).isIsInterrupting()) {
            result = String.valueOf(result) + "*";
        }
        return result;
    }
}

