/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.Hashtable;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.features.AbstractConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.DefaultConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.IConnectionRouter;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class DefaultLayoutBPMNConnectionFeature
extends AbstractLayoutFeature {
    boolean hasDoneChanges = false;
    Diagram diagram;
    Hashtable<Connection, IConnectionRouter> routers = new Hashtable();

    public DefaultLayoutBPMNConnectionFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canLayout(ILayoutContext context) {
        if (context.getPictogramElement() instanceof Connection) {
            Connection connection = (Connection)context.getPictogramElement();
            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
            Bpmn2Preferences prefs = Bpmn2Preferences.getInstance((EObject)be);
            return prefs.getEnableConnectionRouting();
        }
        return false;
    }

    public void execute(IContext context) {
        PictogramElement pe = ((IPictogramElementContext)context).getPictogramElement();
        LifecycleEvent.notify(new LifecycleEvent(LifecycleEvent.EventType.PICTOGRAMELEMENT_LAYOUT, this.getFeatureProvider(), context, pe));
        super.execute(context);
    }

    public boolean hasDoneChanges() {
        return this.hasDoneChanges;
    }

    public boolean layout(ILayoutContext context) {
        if (this.canLayout(context)) {
            Connection connection = (Connection)context.getPictogramElement();
            if (context.getProperty((Object)"initial.update") == Boolean.TRUE) {
                Graphiti.getPeService().setPropertyValue((PropertyContainer)connection, "initial.update", Boolean.TRUE.toString());
            }
            this.diagram = this.getFeatureProvider().getDiagramTypeProvider().getDiagram();
            IConnectionRouter router = this.getRouter(connection);
            if (router.canRoute(connection) && router.routingNeeded(connection)) {
                this.hasDoneChanges |= router.route(connection);
                if (router.routingNeeded(connection)) {
                    AbstractConnectionRouter.addRoutingInfo(connection, "failed");
                } else {
                    AbstractConnectionRouter.removeRoutingInfo(connection);
                }
            }
            UpdateContext uc = new UpdateContext((PictogramElement)connection);
            this.getFeatureProvider().updateIfPossible((IUpdateContext)uc);
            Graphiti.getPeService().removeProperty((PropertyContainer)connection, "initial.update");
        }
        return this.hasDoneChanges;
    }

    private IConnectionRouter getRouter(Connection connection) {
        if (this.routers.containsKey(connection)) {
            return this.routers.get(connection);
        }
        IFeatureProvider fp = this.getFeatureProvider();
        IConnectionRouter router = DefaultConnectionRouter.getRouter(fp, connection);
        if (router == null) {
            router = new BendpointConnectionRouter(fp);
        }
        this.routers.put(connection, router);
        return router;
    }
}

