/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl.importer.ui;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.ddl.importer.DdlImporter;
import org.teiid.designer.ddl.importer.ui.DdlImportDifferencesPage;
import org.teiid.designer.ddl.importer.ui.DdlImporterPage;
import org.teiid.designer.ddl.importer.ui.DdlImporterUiI18n;
import org.teiid.designer.ddl.importer.ui.DdlImporterUiPlugin;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.IPersistentWizardPage;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class DdlImporterWizard
extends AbstractWizard
implements IImportWizard {
    DdlImporter importer;
    private DdlImporterPage srcPg;
    private DdlImportDifferencesPage diffPage;

    public DdlImporterWizard() {
        super((AbstractUIPlugin)DdlImporterUiPlugin.singleton(), DdlImporterUiI18n.WIZARD_TITLE, DdlImporterUiPlugin.imageDescriptor("importWizard75x58.gif"));
        IDialogSettings pluginSettings = DdlImporterUiPlugin.singleton().getDialogSettings();
        String sectionName = DdlImporterWizard.class.getSimpleName();
        IDialogSettings section = pluginSettings.getSection(sectionName);
        if (section == null) {
            section = pluginSettings.addNewSection(sectionName);
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.srcPg);
        this.addPage((IWizardPage)this.diffPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IProject newProject;
        IStructuredSelection finalSelection = selection;
        if (finalSelection == null | finalSelection.isEmpty() && !ModelerUiViewUtils.workspaceHasOpenModelProjects() && (newProject = ModelerUiViewUtils.queryUserToCreateModelProject()) != null) {
            finalSelection = new StructuredSelection((Object)newProject);
        }
        Collection projects = DotProjectUtils.getOpenModelProjects();
        IProject[] projectArray = projects.toArray(new IProject[0]);
        this.importer = new DdlImporter(projectArray);
        this.srcPg = new DdlImporterPage(this.importer, projectArray, finalSelection);
        this.diffPage = new DdlImportDifferencesPage(this.importer);
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.diffPage) {
            result = currentPage.isPageComplete();
        }
        return result;
    }

    public boolean finish() {
        block11: {
            if (this.importer.getDifferenceReport() != null) break block11;
            return false;
        }
        try {
            final Exception[] saveException = new Exception[1];
            new ProgressMonitorDialog(this.getShell()).run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(DdlImporterUiI18n.IMPORTING_DDL_MSG, 100);
                    monitor.worked(50);
                    try {
                        DdlImporterWizard.this.importer.save(monitor, 50);
                    }
                    catch (Exception ex) {
                        saveException[0] = ex;
                    }
                    monitor.done();
                }
            });
            if (saveException[0] != null) {
                throw saveException[0];
            }
            IStatus importStatus = this.importer.getImportStatus();
            if (importStatus != null && importStatus.getSeverity() == 2) {
                if (importStatus instanceof MultiStatus) {
                    ArrayList<String> msgs = new ArrayList<String>(importStatus.getChildren().length);
                    int i = 0;
                    while (i < importStatus.getChildren().length) {
                        msgs.add(importStatus.getChildren()[i].getMessage());
                        ++i;
                    }
                    ListMessageDialog.openInformation((Shell)this.getShell(), (String)DdlImporterUiI18n.IMPORT_COMPLETED_WITH_WARNINGS_TITLE, null, (String)DdlImporterUiI18n.IMPORT_COMPLETED_WITH_WARNINGS_MESSAGE, msgs, null);
                } else {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)DdlImporterUiI18n.IMPORT_COMPLETED_WITH_WARNINGS_TITLE, (String)importStatus.getMessage());
                }
                return true;
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Exception error) {
            error.printStackTrace();
            WidgetUtil.showError((Throwable)error);
            return false;
        }
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage pg = iWizardPageArray[n2];
            if (pg instanceof IPersistentWizardPage) {
                ((IPersistentWizardPage)pg).saveSettings();
            }
            ++n2;
        }
        return true;
    }
}

