/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl.importer.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.teiid.core.designer.I18n;
import org.teiid.designer.ddl.importer.DdlImporter;
import org.teiid.designer.ddl.importer.ui.DdlImporterUiI18n;
import org.teiid.designer.ddl.importer.ui.DdlImporterUiPlugin;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.relational.compare.DifferenceReport;
import org.teiid.designer.relational.compare.OperationList;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.DefaultTreeViewerController;
import org.teiid.designer.ui.common.widget.ITreeViewerController;
import org.teiid.designer.ui.common.wizard.IPersistentWizardPage;

public class DdlImportDifferencesPage
extends WizardPage
implements IPersistentWizardPage {
    private static final int PANEL_GRID_SPAN = 3;
    final DdlImporter importer;
    private Composite stackPanel;
    private Composite differencesPanel;
    private Composite parseErrorPanel;
    private StackLayout stackLayout;
    private CheckboxTreeController controller;
    private TreeViewer treeViewer;
    private Tree tree;
    boolean treeExpanded = false;
    private StyledTextEditor ddlContentsArea;
    private org.eclipse.swt.widgets.List messagesList;

    public DdlImportDifferencesPage(DdlImporter importer) {
        super(DdlImportDifferencesPage.class.getSimpleName(), DdlImporterUiI18n.DIFFERENCE_PAGE_TITLE, null);
        this.importer = importer;
    }

    public void createControl(Composite parent) {
        Composite panel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808, (int)1, (int)3);
        this.setControl((Control)panel);
        this.stackPanel = new Composite(panel, 4);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginWidth = 0;
        this.stackLayout.marginHeight = 0;
        this.stackPanel.setLayout((Layout)this.stackLayout);
        this.stackPanel.setLayoutData((Object)new GridData(1808));
        this.createDifferencesPanel(this.stackPanel);
        this.createParseErrorPanel(this.stackPanel);
    }

    private void createDifferencesPanel(Composite parent) {
        this.differencesPanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        this.differencesPanel.setLayout((Layout)layout);
        SashForm splitter = WidgetFactory.createSplitter((Composite)this.differencesPanel, (int)512);
        GridData gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        splitter.setLayoutData((Object)gid);
        Group treeGroup = WidgetFactory.createGroup((Composite)splitter, (String)DdlImporterUiI18n.DIFFERENCE_PAGE_IMPORT_TREE_GROUP_TITLE, (int)1808, (int)1, (int)1);
        this.controller = new CheckboxTreeController();
        this.treeViewer = WidgetFactory.createTreeViewer((Composite)treeGroup, (int)36, (int)1808, (ITreeViewerController)this.controller);
        this.tree = this.treeViewer.getTree();
        this.tree.setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new CheckboxTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CheckboxTreeLabelProvider());
        this.treeViewer.setInput(null);
        Group messageGroup = WidgetFactory.createGroup((Composite)splitter, (String)DdlImporterUiI18n.DIFFERENCE_PAGE_IMPORT_MESSAGES_GROUP_TITLE, (int)1808, (int)1, (int)1);
        this.messagesList = new org.eclipse.swt.widgets.List((Composite)messageGroup, 2816);
        this.messagesList.setLayoutData((Object)new GridData(1808));
        splitter.setWeights(new int[]{10, 3});
        splitter.layout();
    }

    private void createParseErrorPanel(Composite parent) {
        this.parseErrorPanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808);
        GridLayout layout = new GridLayout(1, false);
        this.parseErrorPanel.setLayout((Layout)layout);
        Group ddlGroup = WidgetFactory.createGroup((Composite)this.parseErrorPanel, (String)DdlImporterUiI18n.DIFFERENCE_PAGE_PARSE_ERROR_DDL_GROUP_TITLE, (int)1808, (int)1, (int)1);
        Composite ddlPanel = WidgetFactory.createPanel((Composite)ddlGroup, (int)0, (int)1808);
        ddlPanel.setLayout((Layout)layout);
        int messageAreaStyle = 584;
        GridData gridData = new GridData(1808);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.ddlContentsArea = StyledTextEditor.createReadOnlyEditor((Composite)ddlPanel, (int)messageAreaStyle);
        this.ddlContentsArea.setLayoutData((Object)gridData);
        this.ddlContentsArea.setBackground(Display.getCurrent().getSystemColor(19));
    }

    public void saveSettings() {
    }

    public void setErrorMessage(String message) {
        if (message == null || this.getErrorMessage() == null) {
            super.setErrorMessage(message);
        }
        this.setPageComplete(message == null);
    }

    public void setVisible(boolean visible) {
        String msg;
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        final Exception[] importException = new Exception[1];
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(DdlImporterUiI18n.IMPORTING_DDL_MSG, 100);
                    try {
                        DdlImportDifferencesPage.this.importer.importDdl(monitor, 100);
                    }
                    catch (Exception ex) {
                        importException[0] = ex;
                    }
                    monitor.done();
                }
            });
            if (importException[0] != null) {
                throw importException[0];
            }
        }
        catch (Exception ex) {
            msg = I18n.format((String)DdlImporterUiI18n.DIFFERENCE_PAGE_DDLIMPORT_ERROR_MSG, (Object[])new Object[]{ex.getLocalizedMessage()});
            DdlImporterUiPlugin.UTIL.log(4, (Throwable)ex, msg);
            this.importer.addProgressMessage(msg);
        }
        if (importException[0] != null || this.importer.hasParseError()) {
            String title = null;
            msg = null;
            this.stackLayout.topControl = this.parseErrorPanel;
            this.ddlContentsArea.setText(this.importer.getDdlString());
            if (importException[0] != null) {
                title = DdlImporterUiI18n.DIFFERENCE_PAGE_GENERAL_ERROR_TITLE;
                msg = I18n.format((String)DdlImporterUiI18n.DIFFERENCE_PAGE_DDLIMPORT_ERROR_MSG, (Object[])new Object[]{importException[0].getLocalizedMessage()});
            } else if (this.importer.hasParseError()) {
                StyledText styledText;
                int line;
                title = DdlImporterUiI18n.DIFFERENCE_PAGE_PARSE_ERROR_TITLE;
                String parseErrorMessage = this.importer.getParseErrorMessage();
                int offset = this.importer.getParseErrorIndex();
                if (offset > -1 && (line = (styledText = this.ddlContentsArea.getTextWidget()).getLineAtOffset(offset)) > -1) {
                    int startIndx = styledText.getOffsetAtLine(line);
                    int endIndx = styledText.getOffsetAtLine(line + 1);
                    styledText.setSelection(startIndx, endIndx);
                }
                msg = I18n.format((String)DdlImporterUiI18n.DIFFERENCE_PAGE_PARSE_ERROR_MSG, (Object[])new Object[]{parseErrorMessage});
            }
            this.setErrorMessage(msg);
            this.importer.undoImport();
            this.setTitle(title);
        } else {
            this.stackLayout.topControl = this.differencesPanel;
            this.setTitle(DdlImporterUiI18n.DIFFERENCE_PAGE_TITLE);
            ArrayList<OperationList> rootList = new ArrayList<OperationList>();
            DifferenceReport diffReport = this.importer.getDifferenceReport();
            if (diffReport != null) {
                OperationList createObjs = this.importer.getDifferenceReport().getObjectsToCreate();
                OperationList deleteObjs = this.importer.getDifferenceReport().getObjectsToDelete();
                OperationList updateObjs = this.importer.getDifferenceReport().getObjectsToUpdate();
                if (!createObjs.getList().isEmpty()) {
                    rootList.add(createObjs);
                }
                if (!deleteObjs.getList().isEmpty()) {
                    rootList.add(deleteObjs);
                }
                if (!updateObjs.getList().isEmpty()) {
                    rootList.add(updateObjs);
                }
            }
            this.treeViewer.setInput(rootList);
            this.treeViewer.expandToLevel(2);
            this.setAllNodesSelected(true);
            List progressMessages = this.importer.getAllMessages();
            this.messagesList.setItems(progressMessages.toArray(new String[progressMessages.size()]));
            this.validate();
        }
        this.stackPanel.layout();
    }

    void validate() {
        this.setErrorMessage(null);
        StringBuffer errMessageBuffer = new StringBuffer();
        boolean hasImportMessages = !this.importer.getAllMessages().isEmpty();
        DifferenceReport diffReport = this.importer.getDifferenceReport();
        if (diffReport == null) {
            errMessageBuffer.append(DdlImporterUiI18n.DIFFERENCE_PAGE_NO_DIFFERENCE_REPORT_MSG);
        } else if (!this.importer.noDdlImported()) {
            if (!diffReport.hasOperations()) {
                errMessageBuffer.append(DdlImporterUiI18n.DIFFERENCE_PAGE_NO_DIFFERENCE_OPERATIONS_MSG);
            } else if (!diffReport.hasSelectedOperations()) {
                errMessageBuffer.append(DdlImporterUiI18n.DIFFERENCE_PAGE_NO_DIFFERENCE_OPERATIONS_SELECTED_MSG);
            }
        }
        if (errMessageBuffer.length() > 0) {
            if (hasImportMessages) {
                errMessageBuffer.append(String.valueOf('\n') + DdlImporterUiI18n.DIFFERENCE_PAGE_SEE_IMPORT_MESSAGES_MSG);
            }
            this.setErrorMessage(errMessageBuffer.toString());
        } else if (hasImportMessages) {
            this.setMessage(DdlImporterUiI18n.DIFFERENCE_PAGE_IMPORT_COMPLETED_WITH_MESSAGES_MSG);
        } else {
            if (this.importer.noDdlImported()) {
                this.setMessage(DdlImporterUiI18n.DIFFERENCE_PAGE_NO_DDL_IMPORTED_MSG);
            } else {
                this.setMessage(null);
            }
            this.setDescription(DdlImporterUiI18n.DIFFERENCE_PAGE_DESCRIPTION);
        }
    }

    private void setAllNodesSelected(boolean bSelected) {
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            this.setAllSelected(items[i], bSelected);
            ++i;
        }
    }

    private void setAllSelected(TreeItem item, boolean checked) {
        WidgetUtil.setChecked((TreeItem)item, (boolean)checked, (boolean)false, (ITreeViewerController)this.controller);
        TreeItem[] children = item.getItems();
        int ndx = 0;
        while (ndx < children.length) {
            this.setAllSelected(children[ndx], checked);
            ++ndx;
        }
    }

    class CheckboxTreeContentProvider
    implements ITreeContentProvider {
        String[] EMPTY_STRING_ARRAY = new String[0];

        CheckboxTreeContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object node) {
            if (node instanceof List) {
                return ((List)node).toArray();
            }
            if (node instanceof OperationList) {
                return ((OperationList)node).getList().toArray();
            }
            return this.EMPTY_STRING_ARRAY;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object node) {
            return null;
        }

        public boolean hasChildren(Object node) {
            if (node instanceof OperationList) {
                return !((OperationList)node).getList().isEmpty();
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class CheckboxTreeController
    extends DefaultTreeViewerController {
        CheckboxTreeController() {
        }

        public void checkedStateToggled(TreeItem item) {
            Object dataObj = item.getData();
            if (dataObj instanceof RelationalReference) {
                boolean isChecked = item.getChecked();
                ((RelationalReference)dataObj).setChecked(isChecked);
            }
            DdlImportDifferencesPage.this.validate();
        }

        public boolean isItemCheckable(TreeItem item) {
            return true;
        }

        public void update(TreeItem item, boolean selected) {
            Object dataObj = item.getData();
            if (dataObj != null) {
                boolean checked;
                boolean bl = checked = !WidgetUtil.isUnchecked((TreeItem)item);
                if (this.isItemCheckable(item)) {
                    item.setChecked(checked);
                }
                item.setGrayed(WidgetUtil.isPartiallyChecked((TreeItem)item));
                if (selected) {
                    this.updateChildren(item, checked);
                    TreeItem parent = item.getParentItem();
                    while (parent != null) {
                        int state = 4;
                        TreeItem[] children = parent.getItems();
                        int ndx = children.length;
                        while (--ndx >= 0) {
                            TreeItem child = children[ndx];
                            if (WidgetUtil.isPartiallyChecked((TreeItem)child)) {
                                state = 4;
                                break;
                            }
                            int childState = WidgetUtil.getCheckedState((TreeItem)child);
                            if (state == 4) {
                                state = childState;
                                continue;
                            }
                            if (state == childState) continue;
                            state = 4;
                            break;
                        }
                        if (state != WidgetUtil.getCheckedState((TreeItem)parent)) {
                            WidgetUtil.setCheckedState((TreeItem)parent, (int)state, (boolean)false, (ITreeViewerController)this);
                        }
                        parent = parent.getParentItem();
                    }
                }
                if (dataObj instanceof RelationalReference) {
                    boolean isChecked = item.getChecked();
                    ((RelationalReference)dataObj).setChecked(isChecked);
                }
                if (!this.isItemCheckable(item)) {
                    item.setGrayed(true);
                    item.setChecked(false);
                } else {
                    item.setGrayed(false);
                }
            }
        }

        private void updateChildren(TreeItem item, boolean checked) {
            TreeItem[] children = item.getItems();
            int ndx = children.length;
            while (--ndx >= 0) {
                TreeItem child = children[ndx];
                if (child.getData() == null) continue;
                this.updateChildren(child, checked);
                WidgetUtil.setChecked((TreeItem)child, (boolean)checked, (boolean)false, (ITreeViewerController)this);
            }
        }

        public void itemExpanded(TreeExpansionEvent event) {
            TreeItem item;
            if (((TreeViewer)event.getTreeViewer()).getTree().getSelection().length > 0 && (item = ((TreeViewer)event.getTreeViewer()).getTree().getSelection()[0]).getData() != null) {
                this.checkRequiredChildren(item);
            }
        }

        public void checkRequiredChildren(TreeItem item) {
            TreeItem[] children = item.getItems();
            int ndx = children.length;
            while (--ndx >= 0) {
                TreeItem child = children[ndx];
                Object childData = child.getData();
                if (childData == null || !(childData instanceof RelationalReference)) continue;
                boolean isChecked = ((RelationalReference)childData).isChecked();
                WidgetUtil.setChecked((TreeItem)child, (boolean)isChecked, (boolean)false, (ITreeViewerController)this);
            }
        }

        public void itemCollapsed(TreeExpansionEvent event) {
            super.itemCollapsed(event);
        }
    }

    class CheckboxTreeLabelProvider
    extends LabelProvider {
        private final Image TABLE_IMG = UiPlugin.getDefault().getImage("icons/full/obj16/relational-table.png");
        private final Image COLUMN_IMG = UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
        private final Image VIEW_IMG = UiPlugin.getDefault().getImage("icons/full/obj16/relational-table.png");
        private final Image PROCEDURE_IMG = UiPlugin.getDefault().getImage("icons/full/obj16/relational-procedure.png");
        private final Image INDEX_IMG = UiPlugin.getDefault().getImage("icons/full/obj16/index.png");
        private final Image VIEW_TABLE_IMG = UiPlugin.getDefault().getImage("icons/full/obj16/virtual-relational-table.png");

        CheckboxTreeLabelProvider() {
        }

        public Image getImage(Object node) {
            if (node instanceof RelationalReference) {
                int type = ((RelationalReference)node).getType();
                if (type == 3) {
                    if (DdlImportDifferencesPage.this.importer.modelType() == ModelType.VIRTUAL_LITERAL) {
                        return this.VIEW_TABLE_IMG;
                    }
                    return this.TABLE_IMG;
                }
                if (type == 7) {
                    return this.COLUMN_IMG;
                }
                if (type == 4) {
                    if (DdlImportDifferencesPage.this.importer.modelType() == ModelType.VIRTUAL_LITERAL) {
                        return this.VIEW_TABLE_IMG;
                    }
                    return this.VIEW_IMG;
                }
                if (type == 5) {
                    return this.PROCEDURE_IMG;
                }
                if (type == 13) {
                    return this.INDEX_IMG;
                }
            }
            return null;
        }

        public String getText(Object node) {
            if (node instanceof OperationList) {
                OperationList opList = (OperationList)node;
                if (opList.getOperationType() == OperationList.OperationType.CREATE) {
                    return DdlImporterUiI18n.DIFFERENCE_PAGE_CREATELIST_LABEL;
                }
                if (opList.getOperationType() == OperationList.OperationType.DELETE) {
                    return DdlImporterUiI18n.DIFFERENCE_PAGE_DELETELIST_LABEL;
                }
                if (opList.getOperationType() == OperationList.OperationType.UPDATE) {
                    return DdlImporterUiI18n.DIFFERENCE_PAGE_UPDATELIST_LABEL;
                }
            } else if (node instanceof RelationalReference) {
                return ((RelationalReference)node).getName();
            }
            return DdlImporterUiI18n.DIFFERENCE_PAGE_UNKNOWN_LABEL;
        }
    }
}

