/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.DatatypeHierarchyTreeViewer;

public class TypeInputDialog
extends Dialog {
    private final EObject selected;
    private final String dialogTitle;
    private final String dialogMessage;
    private EObject value;
    private DatatypeHierarchyTreeViewer dhtv;

    public TypeInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, EObject selected) {
        super(parentShell);
        this.setBlockOnOpen(true);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.dialogTitle = dialogTitle;
        this.dialogMessage = dialogMessage;
        this.selected = selected;
    }

    public EObject getValue() {
        return this.value;
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? SelectionUtilities.getSelectedEObject((ISelection)this.dhtv.getSelection()) : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.dialogTitle != null) {
            shell.setText(this.dialogTitle);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.dialogMessage != null) {
            Label label = new Label(composite, 64);
            label.setText(this.dialogMessage);
            GridData data = new GridData(770);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.dhtv = new DatatypeHierarchyTreeViewer(composite, 4, this.selected);
        GridData data = new GridData(1808);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        data.heightHint = this.convertVerticalDLUsToPixels(300);
        this.dhtv.getTree().setLayoutData((Object)data);
        this.dhtv.expandToLevel(2);
        this.dhtv.setSelection((ISelection)new StructuredSelection((Object)this.selected), true);
        TypeInputDialog.applyDialogFont((Control)composite);
        return composite;
    }
}

