/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.xslt;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.eclipse.core.runtime.Plugin;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.PluginUtilImpl;

public class CoreXsltPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.teiid.designer.core.xslt";
    public static final String PACKAGE_ID = CoreXsltPlugin.class.getPackage().getName();
    private static final String I18N_NAME = String.valueOf(PACKAGE_ID) + ".i18n";
    public static PluginUtil Util = new PluginUtilImpl("org.teiid.designer.core.xslt", I18N_NAME, ResourceBundle.getBundle(I18N_NAME));

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
    }

    public static TransformerFactory createFactory() throws TransformerFactoryConfigurationError {
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        return factory;
    }

    public static Source createSource(Document sourceDoc) throws TeiidDesignerException {
        CoreArgCheck.isNotNull((Object)sourceDoc);
        try {
            XMLOutputter xmlOutputter = new XMLOutputter();
            StringWriter sourceOut = new StringWriter();
            xmlOutputter.output(sourceDoc, (Writer)sourceOut);
            StringReader transformSource = new StringReader(sourceOut.toString());
            return new StreamSource(transformSource);
        }
        catch (Throwable e) {
            String msg = Util.getString("CoreXsltPlugin.Error_loading_the_XSLT_transform", new Object[0]);
            throw new TeiidDesignerException(e, msg);
        }
    }
}

