/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.relational.model.RelationalAccessPattern;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalForeignKey;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalPrimaryKey;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalProcedureResultSet;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.model.RelationalUniqueConstraint;
import org.teiid.designer.relational.model.RelationalView;

public class RelationalModel
extends RelationalReference {
    private Collection<RelationalReference> allRefs = new ArrayList<RelationalReference>();
    private Collection<RelationalReference> children;

    public RelationalModel(String name) {
        super(name);
        this.setType(0);
        this.children = new ArrayList<RelationalReference>();
    }

    public Collection<RelationalReference> getAllReferences() {
        this.allRefs.clear();
        if (this.children != null) {
            for (RelationalReference ref : this.children) {
                this.addRecursive(ref, this.allRefs);
            }
        }
        return this.allRefs;
    }

    public Collection<RelationalReference> getChildren() {
        return this.children;
    }

    public boolean addChild(RelationalReference child) {
        if (this.children == null) {
            this.children = new ArrayList<RelationalReference>();
        }
        boolean wasAdded = false;
        if (!this.children.contains(child)) {
            child.setParent(this);
            wasAdded = this.children.add(child);
        }
        return wasAdded;
    }

    public boolean removeChild(RelationalReference child) {
        if (this.children == null) {
            return false;
        }
        if (this.children.contains(child)) {
            return this.children.remove(child);
        }
        return false;
    }

    public boolean hasChild(String name) {
        CoreArgCheck.isNotNull((Object)name, (String)"name");
        for (RelationalReference child : this.children) {
            if (!name.equalsIgnoreCase(child.getName())) continue;
            return true;
        }
        return false;
    }

    public RelationalReference getChildWithName(String name) {
        CoreArgCheck.isNotNull((Object)name, (String)"name");
        for (RelationalReference child : this.children) {
            if (!name.equalsIgnoreCase(child.getName())) continue;
            return child;
        }
        return null;
    }

    private void addRecursive(RelationalReference ref, Collection<RelationalReference> allRefs) {
        if (ref instanceof RelationalTable) {
            allRefs.add(ref);
            List<RelationalAccessPattern> accessPatterns = ((RelationalTable)ref).getAccessPatterns();
            for (RelationalReference relationalReference : accessPatterns) {
                this.addRecursive(relationalReference, allRefs);
            }
            List<RelationalColumn> list = ((RelationalTable)ref).getColumns();
            for (RelationalReference relationalReference : list) {
                this.addRecursive(relationalReference, allRefs);
            }
            List<RelationalForeignKey> list2 = ((RelationalTable)ref).getForeignKeys();
            for (RelationalReference relationalReference : list2) {
                this.addRecursive(relationalReference, allRefs);
            }
            RelationalPrimaryKey relationalPrimaryKey = ((RelationalTable)ref).getPrimaryKey();
            this.addRecursive(relationalPrimaryKey, allRefs);
            List<RelationalIndex> indexes = ((RelationalTable)ref).getIndexes();
            for (RelationalReference relationalReference : indexes) {
                this.addRecursive(relationalReference, allRefs);
            }
            Collection<RelationalUniqueConstraint> collection = ((RelationalTable)ref).getUniqueConstraints();
            if (collection != null) {
                for (RelationalReference relationalReference : collection) {
                    this.addRecursive(relationalReference, allRefs);
                }
            }
        } else if (ref instanceof RelationalProcedure) {
            allRefs.add(ref);
            List<RelationalParameter> procParams = ((RelationalProcedure)ref).getParameters();
            for (RelationalReference relationalReference : procParams) {
                this.addRecursive(relationalReference, allRefs);
            }
            RelationalProcedureResultSet relationalProcedureResultSet = ((RelationalProcedure)ref).getResultSet();
            this.addRecursive(relationalProcedureResultSet, allRefs);
        } else if (ref instanceof RelationalView) {
            allRefs.add(ref);
            List<RelationalAccessPattern> accessPatterns = ((RelationalView)ref).getAccessPatterns();
            for (RelationalReference relationalReference : accessPatterns) {
                this.addRecursive(relationalReference, allRefs);
            }
            List<RelationalColumn> list = ((RelationalView)ref).getColumns();
            for (RelationalReference relationalReference : list) {
                this.addRecursive(relationalReference, allRefs);
            }
        } else {
            allRefs.add(ref);
        }
    }
}

