/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;

public class RelationalAccessPattern
extends RelationalReference {
    private List<RelationalColumn> columns;

    public RelationalAccessPattern() {
        this.setType(11);
        this.columns = new ArrayList<RelationalColumn>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public RelationalAccessPattern(String name) {
        super(name);
        this.setType(11);
        this.columns = new ArrayList<RelationalColumn>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public List<RelationalColumn> getColumns() {
        return this.columns;
    }

    public void addColumn(RelationalColumn column) {
        this.columns.add(column);
    }

    public RelationalTable getTable() {
        if (this.getParent() != null) {
            return (RelationalTable)this.getParent();
        }
        return null;
    }

    public void setProperties(Properties props) {
        for (Object key : props.keySet()) {
            String keyStr = (String)key;
            String value = props.getProperty(keyStr);
            if (value != null && value.length() == 0) continue;
            if (keyStr.equalsIgnoreCase("NAME")) {
                this.setName(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("NAMEINSOURCE")) {
                this.setNameInSource(value);
                continue;
            }
            if (!keyStr.equalsIgnoreCase("DESCRIPTION")) continue;
            this.setDescription(value);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" : name = ").append(this.getName());
        if (!this.getColumns().isEmpty()) {
            sb.append("\n\t").append(this.getColumns().size()).append(" columns");
            for (RelationalColumn col : this.getColumns()) {
                sb.append("\n\tcol = ").append(col);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationalAccessPattern other = (RelationalAccessPattern)object;
        List<RelationalColumn> thisColumns = this.getColumns();
        List<RelationalColumn> thatColumns = other.getColumns();
        if (thisColumns.size() != thatColumns.size()) {
            return false;
        }
        return thisColumns.isEmpty() || thisColumns.containsAll(thatColumns);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        List<RelationalColumn> cols = this.getColumns();
        for (RelationalColumn col : cols) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{col});
        }
        return result;
    }
}

