/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.compare;

import java.util.List;
import org.teiid.designer.relational.compare.OperationList;
import org.teiid.designer.relational.model.RelationalReference;

public class DifferenceReport {
    private OperationList objectsToCreate;
    private OperationList objectsToDelete;
    private OperationList objectsToUpdate;

    public void setObjectsToCreate(List<RelationalReference> objsToCreate) {
        this.objectsToCreate = new OperationList(objsToCreate, OperationList.OperationType.CREATE);
    }

    public void setObjectsToDelete(List<RelationalReference> objsToDelete) {
        this.objectsToDelete = new OperationList(objsToDelete, OperationList.OperationType.DELETE);
    }

    public void setObjectsToUpdate(List<RelationalReference> objsToUpdate) {
        this.objectsToUpdate = new OperationList(objsToUpdate, OperationList.OperationType.UPDATE);
    }

    public OperationList getObjectsToCreate() {
        return this.objectsToCreate;
    }

    public OperationList getObjectsToDelete() {
        return this.objectsToDelete;
    }

    public OperationList getObjectsToUpdate() {
        return this.objectsToUpdate;
    }

    public boolean hasOperations() {
        return !this.objectsToCreate.getList().isEmpty() || !this.objectsToDelete.getList().isEmpty() || !this.objectsToUpdate.getList().isEmpty();
    }

    public boolean hasSelectedOperations() {
        boolean hasSelectedOp = false;
        List<RelationalReference> createList = this.objectsToCreate.getList();
        for (RelationalReference createRef : createList) {
            if (!createRef.isChecked()) continue;
            hasSelectedOp = true;
            break;
        }
        if (!hasSelectedOp) {
            List<RelationalReference> deleteList = this.objectsToDelete.getList();
            for (RelationalReference deleteRef : deleteList) {
                if (!deleteRef.isChecked()) continue;
                hasSelectedOp = true;
                break;
            }
        }
        if (!hasSelectedOp) {
            List<RelationalReference> updateList = this.objectsToUpdate.getList();
            for (RelationalReference updateRef : updateList) {
                if (!updateRef.isChecked()) continue;
                hasSelectedOp = true;
                break;
            }
        }
        return hasSelectedOp;
    }
}

