/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.compare;

import java.util.ArrayList;
import java.util.Collection;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.relational.compare.DifferenceReport;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalReference;

public class DifferenceGenerator {
    public static DifferenceReport compare(RelationalModel targetModel, RelationalModel originalModel) {
        DifferenceReport diffReport = new DifferenceReport();
        Collection<RelationalReference> targetChildren = DifferenceGenerator.filterForPrimaryRefs(targetModel.getAllReferences());
        Collection<RelationalReference> originalChildren = DifferenceGenerator.filterForPrimaryRefs(originalModel.getAllReferences());
        ArrayList<RelationalReference> objsToCreate = new ArrayList<RelationalReference>();
        ArrayList<RelationalReference> objsToUpdate = new ArrayList<RelationalReference>();
        ArrayList<RelationalReference> objsExactMatch = new ArrayList<RelationalReference>();
        for (RelationalReference targetObj : targetChildren) {
            RelationalReference nameTypeParentMatch = DifferenceGenerator.getNameTypeParentMatch(originalChildren, targetObj);
            if (nameTypeParentMatch != null) {
                if (!nameTypeParentMatch.equals(targetObj)) {
                    objsToUpdate.add(targetObj);
                    continue;
                }
                objsExactMatch.add(targetObj);
                continue;
            }
            objsToCreate.add(targetObj);
        }
        ArrayList<RelationalReference> objsToDelete = new ArrayList<RelationalReference>();
        for (RelationalReference origObj : originalChildren) {
            RelationalReference matchObj = DifferenceGenerator.getNameTypeParentMatch(targetChildren, origObj);
            if (matchObj != null) continue;
            objsToDelete.add(origObj);
        }
        diffReport.setObjectsToCreate(objsToCreate);
        diffReport.setObjectsToDelete(objsToDelete);
        diffReport.setObjectsToUpdate(objsToUpdate);
        return diffReport;
    }

    private static RelationalReference getNameTypeParentMatch(Collection<RelationalReference> refs, RelationalReference ref) {
        RelationalReference result = null;
        for (RelationalReference listRef : refs) {
            if (!DifferenceGenerator.nameTypeParentMatch(listRef, ref)) continue;
            result = listRef;
            break;
        }
        return result;
    }

    private static boolean nameTypeParentMatch(RelationalReference ref1, RelationalReference ref2) {
        if (ref1 == null || ref2 == null) {
            return false;
        }
        if (!CoreStringUtil.valuesAreEqual((String)ref1.getName(), (String)ref2.getName())) {
            return false;
        }
        if (ref1.getType() != ref2.getType()) {
            return false;
        }
        RelationalReference ref1Parent = ref1.getParent();
        RelationalReference ref2Parent = ref2.getParent();
        if (ref1Parent == null && ref2Parent == null) {
            return true;
        }
        if (ref1Parent == null || ref2Parent == null) {
            return false;
        }
        if (ref1Parent.getType() != ref1Parent.getType()) {
            return false;
        }
        if (ref1Parent.getType() == 0) {
            return true;
        }
        return CoreStringUtil.valuesAreEqual((String)ref1Parent.getName(), (String)ref1Parent.getName());
    }

    private static Collection<RelationalReference> filterForPrimaryRefs(Collection<RelationalReference> allRefs) {
        ArrayList<RelationalReference> filteredList = new ArrayList<RelationalReference>();
        for (RelationalReference rRef : allRefs) {
            int refType;
            if (rRef == null || (refType = rRef.getType()) != 3 && refType != 5 && refType != 4 && refType != 13) continue;
            filteredList.add(rRef);
        }
        return filteredList;
    }
}

