/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.relational.impl.custom;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcTable;
import org.teiid.designer.jdbc.relational.impl.Context;
import org.teiid.designer.jdbc.relational.impl.RelationalModelProcessorImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMapping;

public class SybaseModelProcessor
extends RelationalModelProcessorImpl {
    private static final String TEXT_TYPE_NAME = "TEXT";
    private static final String IMAGE_TYPE_NAME = "IMAGE";

    public SybaseModelProcessor() {
    }

    public SybaseModelProcessor(RelationalFactory factory) {
        super(factory);
    }

    public SybaseModelProcessor(RelationalFactory factory, RelationalTypeMapping mapping) {
        super(factory, mapping);
    }

    @Override
    protected void updateModelAnnotation(ModelAnnotation modelAnnotation) {
        super.updateModelAnnotation(modelAnnotation);
        modelAnnotation.setMaxSetSize(250);
    }

    @Override
    protected List createIndexes(JdbcTable tableNode, Table table, Context context, List problems) {
        String pkName;
        BaseTable theTable;
        PrimaryKey pk;
        List indexes = super.createIndexes(tableNode, table, context, problems);
        if (table instanceof BaseTable && (pk = (theTable = (BaseTable)table).getPrimaryKey()) != null && ((pkName = pk.getName()) == null || pkName.trim().length() == 0)) {
            EList pkColumns = pk.getColumns();
            boolean foundMatchingIndex = false;
            for (Index index : indexes) {
                String indexName = index.getName();
                if (indexName == null || indexName.trim().length() == 0) continue;
                EList indexColumns = index.getColumns();
                if (indexColumns.size() == pkColumns.size()) {
                    Iterator indexColumnIter = indexColumns.iterator();
                    Iterator pkColumnIter = pkColumns.iterator();
                    while (pkColumnIter.hasNext() && indexColumnIter.hasNext()) {
                        Column pkColumn;
                        Column indexColumn = (Column)indexColumnIter.next();
                        if (indexColumn != (pkColumn = (Column)pkColumnIter.next())) break;
                    }
                    foundMatchingIndex = true;
                }
                if (!foundMatchingIndex) continue;
                this.setNameAndNameInSource((RelationalEntity)pk, indexName, (JdbcNode)tableNode, context, problems);
                break;
            }
        }
        return indexes;
    }

    @Override
    protected boolean checkExportedForeignKeysIfNoImportedForeignKeysFound() {
        return false;
    }

    @Override
    protected EObject findType(int jdbcType, String typeName, int length, int precision, int scale, List problems) {
        EObject result = null;
        if (typeName.toUpperCase().startsWith(TEXT_TYPE_NAME)) {
            result = this.findBuiltinType("clob", problems);
        } else if (typeName.toUpperCase().startsWith(IMAGE_TYPE_NAME)) {
            result = this.findBuiltinType("blob", problems);
        }
        if (result != null) {
            return result;
        }
        return super.findType(jdbcType, typeName, length, precision, scale, problems);
    }

    @Override
    protected void setColumnInfo(Column column, JdbcTable tableNode, Context context, List problems, String name, int type, String typeName, int columnSize, int numDecDigits, int numPrecRadix, int nullable, String defaultValue, int charOctetLen) {
        super.setColumnInfo(column, tableNode, context, problems, name, type, typeName, columnSize, numDecDigits, numPrecRadix, nullable, defaultValue, charOctetLen);
        if ("double precis".equalsIgnoreCase(typeName)) {
            column.setNativeType("double precision");
        }
    }
}

