/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import io.fabric8.activemq.facade.BrokerFacade;
import io.fabric8.activemq.facade.QueueViewFacade;
import java.util.Collection;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.Messages;
import org.fusesource.ide.jmx.activemq.navigator.BrokerNode;
import org.fusesource.ide.jmx.activemq.navigator.QueueNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class QueuesNode
extends RefreshableCollectionNode
implements ImageProvider,
ContextMenuProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;

    public QueuesNode(BrokerNode brokerNode) {
        super((Node)brokerNode);
        this.brokerNode = brokerNode;
        this.facade = brokerNode.getFacade();
    }

    public String toString() {
        return "Queues";
    }

    protected void loadChildren() {
        try {
            Collection queues = this.facade.getQueues();
            if (queues != null) {
                for (QueueViewFacade queue : queues) {
                    this.addChild((Node)new QueueNode(this, (QueueViewMBean)queue));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return ActiveMQJMXPlugin.getDefault().getImage("queue_folder.png");
    }

    public void provideContextMenu(IMenuManager menu) {
        Action createQueueAction = new Action(Messages.CreateQueueAction, 32){

            public void run() {
                QueuesNode.this.showCreateQueueDialog();
            }
        };
        createQueueAction.setToolTipText(Messages.CreateQueueActionToolTip);
        createQueueAction.setImageDescriptor(ActiveMQJMXPlugin.getDefault().getImageDescriptor("new_queue.png"));
        menu.add((IAction)createQueueAction);
    }

    protected void showCreateQueueDialog() {
        InputDialog dialog = new InputDialog(Shells.getShell(), Messages.CreateQueueDialogTitle, Messages.CreateQueueDialogMessage, "", null);
        int result = dialog.open();
        if (result == 0) {
            String queue = dialog.getValue();
            this.createQueue(queue);
        }
    }

    protected void createQueue(String queue) {
        if (!Strings.isBlank((String)queue)) {
            try {
                this.getFacade().getBrokerAdmin().addQueue(queue);
                this.refresh();
            }
            catch (Exception e) {
                ActiveMQJMXPlugin.showUserError("Failed to create Queue", "Failed to create queue: " + queue, e);
            }
        }
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

