/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.event.IChangeListener;
import org.teiid.core.designer.event.IChangeNotifier;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.Stopwatch;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.ui.wizard.IDifferencingWizard;
import org.teiid.designer.compare.ui.wizard.ShowDifferencesPage;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.DefaultIgnorableNotificationSource;
import org.teiid.designer.core.validation.rules.CoreValidationRulesUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelResourceImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.OpenableImpl;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.relational.JdbcImporter;
import org.teiid.designer.jdbc.relational.RelationalModelProcessor;
import org.teiid.designer.jdbc.relational.impl.RelationalModelProcessorImpl;
import org.teiid.designer.jdbc.relational.util.JdbcModelProcessorManager;
import org.teiid.designer.jdbc.relational.util.JdbcRelationalUtil;
import org.teiid.designer.jdbc.ui.ModelerJdbcUiConstants;
import org.teiid.designer.jdbc.ui.util.JdbcUiUtil;
import org.teiid.designer.jdbc.ui.wizards.IJdbcImportInfoProvider;
import org.teiid.designer.jdbc.ui.wizards.IJdbcImportPostProcessor;
import org.teiid.designer.jdbc.ui.wizards.JDBCConnectionInfoProvider;
import org.teiid.designer.jdbc.ui.wizards.JdbcImportMetadataPage;
import org.teiid.designer.jdbc.ui.wizards.JdbcImportObjectsPage;
import org.teiid.designer.jdbc.ui.wizards.JdbcImportOptionsPage;
import org.teiid.designer.jdbc.ui.wizards.JdbcSourceSelectionPage;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.extension.CoreModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.CoreModelExtensionConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.IPropertiesContext;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class JdbcImportWizard
extends AbstractWizard
implements IPropertiesContext,
IDifferencingWizard,
IJdbcImportInfoProvider,
ModelerJdbcUiConstants,
ModelerJdbcUiConstants.Images {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(JdbcImportWizard.class);
    private static final String TITLE = JdbcImportWizard.getString("title");
    private static final ImageDescriptor IMAGE = UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importDatabase.gif");
    private static final String COPY_ERROR_MESSAGE = JdbcImportWizard.getString("copyErrorMessage");
    private static final String IMPORT_ERROR_MESSAGE = JdbcImportWizard.getString("importErrorMessage");
    private static final String UNDERSCORE_ONE = "_";
    private static final String UNDERSCORE_TWO = "__";
    private boolean doNotFinish = false;
    private JdbcImporter importer;
    private IContainer folder;
    private String modelName;
    private IStatus status;
    JdbcSourceSelectionPage srcPg;
    private JdbcImportOptionsPage optionsPg;
    private ShowDifferencesPage diffsPg;
    DifferenceReport drDifferenceReport;
    ProcessorPack ppProcessorPack;
    private Properties designerProperties;
    private boolean openProjectExists = true;
    private IProject newProject;
    boolean controlsHaveBeenCreated = false;
    private boolean isVirtual;
    private boolean isVdbSourceModel;
    private IJdbcImportPostProcessor[] postProcessors;
    private IConnectionProfile connectionProfile;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public JdbcImportWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), TITLE, IMAGE);
    }

    public boolean canFinish() {
        boolean bCanFinish = false;
        boolean bUpdateSelected = false;
        if (this.optionsPg != null) {
            bUpdateSelected = this.optionsPg.updateSelected();
        }
        boolean bDiffsDisplayed = false;
        if (this.diffsPg != null) {
            bDiffsDisplayed = this.diffsPg.isVisible();
        }
        boolean bUpdateStepsPending = false;
        if (bUpdateSelected && !bDiffsDisplayed) {
            bUpdateStepsPending = true;
        }
        bCanFinish = super.canFinish() && this.getFolder() != null && !bUpdateStepsPending;
        return bCanFinish;
    }

    protected void connectionEstablished() {
    }

    protected ShowDifferencesPage createDifferencesPage() {
        return new ShowDifferencesPage((IDifferencingWizard)this);
    }

    protected IWizardPage createMetadataPage() {
        JdbcImportMetadataPage page = new JdbcImportMetadataPage();
        page.setImporter(this.importer);
        return page;
    }

    protected IWizardPage createObjectsPage() {
        JdbcImportObjectsPage page = new JdbcImportObjectsPage();
        page.setImporter(this.importer);
        return page;
    }

    protected JdbcImportOptionsPage createOptionsPage() {
        JdbcImportOptionsPage page = new JdbcImportOptionsPage();
        page.setImporter(this.importer);
        return page;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.controlsHaveBeenCreated = true;
    }

    public void dispose() {
        try {
            this.importer.disconnect();
        }
        catch (SQLException err) {
            JdbcUiUtil.showAccessError(err);
        }
        super.dispose();
    }

    public boolean finish() {
        if (this.doNotFinish) {
            return false;
        }
        if (!this.srcPg.connect()) {
            return false;
        }
        boolean result = false;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Changing Sql Connections", (Object)new DefaultIgnorableNotificationSource((Object)JdbcImportWizard.this, JdbcImportWizard.this.modelName));
                boolean succeeded = false;
                try {
                    JdbcImportWizard.this.runFinish(monitor);
                    if (JdbcImportWizard.this.getDesignerProperties() != null) {
                        DesignerPropertiesUtil.setSourceModelName((Properties)JdbcImportWizard.this.getDesignerProperties(), (String)JdbcImportWizard.this.modelName);
                    }
                    succeeded = true;
                }
                finally {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            switch (this.status.getSeverity()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    Util.log(this.status);
                    WidgetUtil.showError((String)IMPORT_ERROR_MESSAGE);
                }
            }
            result = true;
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                err = ((InvocationTargetException)err).getTargetException();
            }
            JdbcUiUtil.showError(err, IMPORT_ERROR_MESSAGE);
        }
        return result;
    }

    @Override
    public JdbcDatabase getDatabase() {
        return this.importer.getDatabase();
    }

    @Override
    public List getDifferenceReports() {
        ArrayList<DifferenceReport> reports = new ArrayList<DifferenceReport>();
        if (this.drDifferenceReport == null || this.diffTargetChanged(this.drDifferenceReport)) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            JdbcSource src = JdbcImportWizard.this.getSource();
                            RelationalModelProcessor processor = JdbcModelProcessorManager.createRelationalModelProcessor((String)JdbcImportWizard.this.srcPg.getMetadataProcessor());
                            processor.setMoveRatherThanCopyAdds(!JdbcImportWizard.this.isUpdatedModel());
                            boolean includeIncompleteFKs = JdbcImportWizard.this.getDatabase().getIncludes().includeIncompleteFKs();
                            processor.setIncludeIncompleteFKs(includeIncompleteFKs);
                            IFile modelFile = JdbcImportWizard.this.getFolder().getFile((IPath)new Path(JdbcImportWizard.this.getModelName()));
                            ModelResource resrc = ModelerCore.create((IFile)modelFile);
                            ModelAnnotation modelAnnotation = resrc.getModelAnnotation();
                            modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
                            ModelType type = ModelType.PHYSICAL_LITERAL;
                            JdbcImportWizard.this.isVirtual = JdbcImportWizard.this.optionsPg.isVirtual();
                            if (JdbcImportWizard.this.isVirtual) {
                                type = ModelType.VIRTUAL_LITERAL;
                            }
                            modelAnnotation.setModelType(type);
                            if (resrc instanceof ModelResourceImpl) {
                                ((ModelResourceImpl)resrc).setModelType(type);
                            }
                            if (processor instanceof RelationalModelProcessorImpl) {
                                JdbcImportWizard.this.drDifferenceReport = ((RelationalModelProcessorImpl)processor).generateDifferenceReport(resrc, JdbcImportWizard.this.getDatabase(), src.getImportSettings(), monitor);
                            }
                            JdbcImportWizard.this.ppProcessorPack = new ProcessorPack(processor, src, modelFile, resrc);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            monitor.done();
                        }
                        catch (Exception err) {
                            throw new InvocationTargetException(err);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            }
            catch (Throwable err) {
                if (err instanceof InvocationTargetException) {
                    err = ((InvocationTargetException)err).getTargetException();
                }
                JdbcUiUtil.showError(err, IMPORT_ERROR_MESSAGE);
            }
        }
        if (this.drDifferenceReport != null) {
            reports.add(this.drDifferenceReport);
        }
        return reports;
    }

    private boolean diffTargetChanged(DifferenceReport diffReport) {
        boolean result = false;
        String diffReportTargetModel = this.getDifferenceTargetModelName(diffReport);
        if (diffReportTargetModel != null && !diffReportTargetModel.equalsIgnoreCase(this.getModelName())) {
            result = true;
        }
        return result;
    }

    private String getDifferenceTargetModelName(DifferenceReport diffReport) {
        String targetModelName = null;
        String uriStr = diffReport.getResultUri();
        URI uri = URI.createURI((String)uriStr);
        if (uri.isFile()) {
            File theFile = new File(uri.toFileString());
            targetModelName = theFile.getName();
        }
        return targetModelName;
    }

    IContainer getFolder() {
        return this.folder;
    }

    private IJdbcImportInfoProvider getImportInfoProvider() {
        return this;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public ModelResource getModelResource() {
        return this.ppProcessorPack.getModelResource();
    }

    @Override
    public String getPassword() {
        String result = null;
        IWizardPage[] pages = this.getPages();
        if (pages != null) {
            int i = 0;
            while (i < pages.length) {
                if (pages[i] instanceof JdbcSourceSelectionPage) {
                    result = ((JdbcSourceSelectionPage)pages[i]).getPassword();
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private IJdbcImportPostProcessor[] getPostProcessors() {
        block11: {
            if (this.postProcessors == null) {
                IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.jdbc.ui", "jdbcImportPostProcessor");
                if (extensionPoint == null) {
                    Util.log(4, Util.getString(String.valueOf(I18N_PREFIX) + "noExtensionPointFound", (Object)"jdbcImportPostProcessor"));
                    this.postProcessors = new IJdbcImportPostProcessor[0];
                    return this.postProcessors;
                }
                try {
                    IExtension[] extensions = extensionPoint.getExtensions();
                    if (extensions.length != 0) {
                        ArrayList<Object> temp = new ArrayList<Object>(extensions.length);
                        int i = 0;
                        while (i < extensions.length) {
                            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                            int j = 0;
                            while (j < elements.length) {
                                try {
                                    Object obj = elements[j].createExecutableExtension("name");
                                    if (obj instanceof IJdbcImportPostProcessor) {
                                        temp.add(obj);
                                    } else {
                                        Object[] params = new Object[]{obj.getClass(), elements[j].getDeclaringExtension().getUniqueIdentifier()};
                                        Util.log(4, Util.getString(String.valueOf(I18N_PREFIX) + "incorrectClass", params));
                                    }
                                }
                                catch (Exception exception) {
                                    Object[] params = new Object[]{elements[j].getAttribute("name"), elements[j].getDeclaringExtension().getUniqueIdentifier()};
                                    Util.log(4, Util.getString(String.valueOf(I18N_PREFIX) + "initError", params));
                                }
                                ++j;
                            }
                            ++i;
                        }
                        this.postProcessors = new IJdbcImportPostProcessor[temp.size()];
                        temp.toArray(this.postProcessors);
                        break block11;
                    }
                    this.postProcessors = new IJdbcImportPostProcessor[0];
                }
                catch (Exception theException) {
                    Util.log(4, (Throwable)theException, Util.getString(String.valueOf(I18N_PREFIX) + "unexpectedErrorProcessingExtensions", (Object)"jdbcImportPostProcessor"));
                    this.postProcessors = new IJdbcImportPostProcessor[0];
                }
            }
        }
        return this.postProcessors;
    }

    @Override
    public JdbcSource getSource() {
        return this.importer.getSource();
    }

    public void init(IWorkbench workbench, IStructuredSelection inputSelection) {
        block19: {
            IStructuredSelection selection = inputSelection;
            Object seletedObj = selection.getFirstElement();
            boolean isSourceModel = false;
            try {
                if (seletedObj instanceof IFile) {
                    ModelResource modelResource = ModelUtil.getModelResource((IFile)((IFile)seletedObj), (boolean)false);
                    isSourceModel = ModelUtilities.isPhysical((ModelResource)modelResource);
                }
            }
            catch (Exception e) {
                Util.log((Throwable)e);
            }
            if (!isSourceModel && ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
                selection = new StructuredSelection((Object)ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject());
            }
            this.importer = new JdbcImporter();
            if (!selection.isEmpty() && selection.getFirstElement() instanceof IProject && ((IProject)selection.getFirstElement()).isOpen()) {
                Object obj = selection.getFirstElement();
                IContainer folder = ModelUtil.getContainer((Object)obj);
                try {
                    if (folder != null && folder.getProject().getNature("org.teiid.designer.core.modelNature") != null) {
                        this.folder = folder;
                    }
                }
                catch (CoreException err) {
                    Util.log((Throwable)err);
                    WidgetUtil.showError((Throwable)err);
                }
                ModelResource model = null;
                try {
                    model = JdbcRelationalUtil.getPhysicalModifiableRelationalModel((Object)obj);
                    if (model == null) break block19;
                    Iterator iter = model.getAllRootEObjects().iterator();
                    while (iter.hasNext()) {
                        if (!(iter.next() instanceof JdbcSource)) continue;
                        this.importer.setUpdatedModel(model);
                        String name = FileUtils.getFilenameWithoutExtension((String)model.getItemName());
                        String validName = CoreValidationRulesUtil.getValidString((String)name, null, (int)-1);
                        if (validName != null) {
                            name = validName;
                            while (name.indexOf(UNDERSCORE_TWO) > -1) {
                                name = name.replaceAll(UNDERSCORE_TWO, UNDERSCORE_ONE);
                            }
                        }
                        this.modelName = String.valueOf(name) + ".xmi";
                        break;
                    }
                }
                catch (ModelWorkspaceException err) {
                    if (model != null && !model.hasErrors()) {
                        Util.log((Throwable)err);
                    }
                    WidgetUtil.showError((Throwable)err);
                }
            } else {
                this.openProjectExists = ModelerUiViewUtils.workspaceHasOpenModelProjects();
                if (!this.openProjectExists) {
                    this.newProject = ModelerUiViewUtils.queryUserToCreateModelProject();
                    if (this.newProject != null) {
                        selection = new StructuredSelection((Object)this.newProject);
                        this.openProjectExists = true;
                    } else {
                        this.openProjectExists = false;
                    }
                }
            }
        }
        this.srcPg = new JdbcSourceSelectionPage(this.importer.getSource());
        this.srcPg.setImporter(this.importer);
        this.srcPg.addChangeListener(new IChangeListener(){

            public void stateChanged(IChangeNotifier notifier) {
                if (JdbcImportWizard.this.controlsHaveBeenCreated) {
                    boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Changing Sql Connections", (Object)this);
                    boolean succeeded = false;
                    try {
                        JdbcImportWizard.this.sqlConnectionChanged(JdbcImportWizard.this.srcPg);
                        succeeded = true;
                    }
                    finally {
                        if (started) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                }
            }
        });
        this.optionsPg = this.createOptionsPage();
        if (this.importer.getUpdatedModel() != null) {
            this.optionsPg.setPageComplete(false);
        }
        this.diffsPg = this.createDifferencesPage();
        this.addPage((IWizardPage)this.srcPg);
        this.addPage(this.createMetadataPage());
        this.addPage(this.createObjectsPage());
        this.addPage((IWizardPage)this.optionsPg);
        this.addPage((IWizardPage)this.diffsPg);
    }

    boolean isUpdatedModel() {
        return this.importer.getUpdatedModel() != null;
    }

    void runFinish(IProgressMonitor monitor) throws InvocationTargetException {
        Stopwatch totalWatch = new Stopwatch();
        totalWatch.start();
        Stopwatch sWatch = new Stopwatch();
        try {
            try {
                sWatch.start();
                if (this.ppProcessorPack == null) {
                    JdbcSource src = this.getSource();
                    RelationalModelProcessor processor = JdbcModelProcessorManager.createRelationalModelProcessor((String)this.srcPg.getMetadataProcessor());
                    boolean includeIncompleteFKs = this.getDatabase().getIncludes().includeIncompleteFKs();
                    processor.setIncludeIncompleteFKs(includeIncompleteFKs);
                    processor.setMoveRatherThanCopyAdds(!this.isUpdatedModel());
                    IFile modelFile = this.getFolder().getFile((IPath)new Path(this.getModelName()));
                    ModelResource resrc = ModelerCore.create((IFile)modelFile);
                    ModelAnnotation modelAnnotation = resrc.getModelAnnotation();
                    modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
                    ModelType type = ModelType.PHYSICAL_LITERAL;
                    this.isVirtual = this.optionsPg.isVirtual();
                    this.isVdbSourceModel = this.importer.isVdbSourceModel();
                    if (this.isVirtual) {
                        type = ModelType.VIRTUAL_LITERAL;
                    }
                    modelAnnotation.setModelType(type);
                    if (resrc instanceof ModelResourceImpl) {
                        ((ModelResourceImpl)resrc).setModelType(type);
                    }
                    ModelUtilities.initializeModelContainers((ModelResource)resrc, (String)"Jdbc Import", (Object)this);
                    if (this.isVdbSourceModel && this.srcPg.isTeiidConnection()) {
                        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
                        CoreModelExtensionAssistant assistant = (CoreModelExtensionAssistant)registry.getModelExtensionAssistant(CoreModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
                        assistant.saveModelExtensionDefinition((Object)resrc);
                        assistant.setPropertyValue((Object)modelAnnotation, CoreModelExtensionConstants.PropertyIds.LOCKED, Boolean.TRUE.toString());
                        assistant.setPropertyValue((Object)modelAnnotation, CoreModelExtensionConstants.PropertyIds.VDB_NAME, this.srcPg.getVdbName());
                    }
                    this.status = processor.execute(resrc, this.getDatabase(), src.getImportSettings(), monitor);
                    this.ppProcessorPack = new ProcessorPack(processor, src, modelFile, resrc);
                } else {
                    this.status = this.ppProcessorPack.getProcessor().execute(this.ppProcessorPack.getModelResource(), this.getDatabase(), this.ppProcessorPack.getJdbcSource().getImportSettings(), monitor);
                }
                sWatch.stop();
                if (!monitor.isCanceled() && this.status.getSeverity() != 4) {
                    IJdbcImportPostProcessor[] processors = this.getPostProcessors();
                    int i = 0;
                    while (i < processors.length) {
                        try {
                            processors[i].postProcess(this.getImportInfoProvider());
                        }
                        catch (Exception theException) {
                            Util.log(4, (Throwable)theException, Util.getString(String.valueOf(I18N_PREFIX) + "postProcessingError", processors[i].getClass()));
                        }
                        ++i;
                    }
                }
                if (this.status.getSeverity() != 4) {
                    sWatch.start(true);
                    List objs = this.ppProcessorPack.getModelResource().getAllRootEObjects();
                    Iterator iter = objs.iterator();
                    while (iter.hasNext()) {
                        if (!(iter.next() instanceof JdbcSource)) continue;
                        iter.remove();
                        break;
                    }
                    this.ppProcessorPack.getJdbcSource().setJdbcDriver(null);
                    objs.add(this.ppProcessorPack.getJdbcSource());
                    sWatch.stop();
                    sWatch.start(true);
                    if (this.connectionProfile != null) {
                        JDBCConnectionInfoProvider provider = new JDBCConnectionInfoProvider();
                        provider.setConnectionInfo(this.ppProcessorPack.getModelResource(), this.connectionProfile);
                    }
                    if (this.isVirtual) {
                        this.ppProcessorPack.getModelResource().getModelAnnotation().setModelType(ModelType.VIRTUAL_LITERAL);
                        ((ModelResourceImpl)this.ppProcessorPack.getModelResource()).setModelType(ModelType.VIRTUAL_LITERAL);
                    }
                    ((OpenableImpl)this.ppProcessorPack.getModelResource()).forceSave(monitor);
                    sWatch.stop();
                    sWatch.start(true);
                    IResource resrc = this.folder.findMember(this.getModelName());
                    if (resrc != null) {
                        resrc.refreshLocal(2, monitor);
                    }
                    sWatch.stop();
                    sWatch.start(true);
                    ModelEditorManager.activate((IFile)this.ppProcessorPack.getModelFile(), (boolean)true);
                    sWatch.stop();
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                monitor.done();
                this.ppProcessorPack = null;
                totalWatch.stop();
            }
            catch (Exception err) {
                throw new InvocationTargetException(err);
            }
        }
        finally {
            monitor.done();
            this.ppProcessorPack = null;
            totalWatch.stop();
        }
    }

    void setFolder(IContainer folder) {
        CoreArgCheck.isNotNull((Object)folder);
        this.folder = folder;
    }

    void setModelName(String name) {
        CoreArgCheck.isNotEmpty((String)name);
        this.modelName = name;
    }

    ModelResource getUpdatedModel() {
        return this.importer.getUpdatedModel();
    }

    void setUpdatedModel(ModelResource model) throws ModelWorkspaceException {
        this.importer.setUpdatedModel(model);
    }

    void sqlConnectionChanged(JdbcSourceSelectionPage page) {
        Connection sqlConnection = page.getConnection();
        this.connectionProfile = page.getConnectionProfile();
        if (sqlConnection == null) {
            this.importer.setDatabase(null);
        } else {
            try {
                ModelResource model;
                IResource resrc;
                JdbcSource src = (JdbcSource)ModelerCore.getModelEditor().copy((EObject)page.getSource());
                this.importer.setSource(src);
                JdbcDatabase db = JdbcPlugin.getJdbcDatabase((JdbcSource)src, (Connection)sqlConnection);
                JdbcPlugin.ensureNonNullImportSettings((JdbcSource)src);
                this.importer.setDatabase(db);
                if (this.getModelName() == null) {
                    String tempModelName = CoreValidationRulesUtil.getValidString((String)db.getName(), null, (int)-1);
                    if (tempModelName == null) {
                        tempModelName = db.getName();
                    }
                    String validName = tempModelName = FileUtils.toFileNameWithExtension((String)tempModelName, (String)".xmi");
                    while (validName.indexOf(UNDERSCORE_TWO) > -1) {
                        validName = validName.replaceAll(UNDERSCORE_TWO, UNDERSCORE_ONE);
                    }
                    tempModelName = validName;
                    if (!CoreStringUtil.isEmpty((String)tempModelName) && ModelerCore.getWorkspace().validateName(tempModelName, 1).isOK()) {
                        this.modelName = tempModelName;
                    }
                }
                if (this.folder != null && (resrc = this.folder.findMember(this.modelName)) != null && (model = JdbcRelationalUtil.getPhysicalModifiableRelationalModel((Object)resrc)) != null) {
                    this.importer.setUpdatedModel(model);
                    this.optionsPg.setPageComplete(false);
                }
                this.connectionProfile = page.getConnectionProfile();
                this.connectionEstablished();
            }
            catch (Exception err) {
                JdbcUiUtil.showError(err, COPY_ERROR_MESSAGE);
            }
        }
        this.getContainer().updateButtons();
    }

    JdbcNode findNode(IPath path, JdbcNode parent) throws JdbcException {
        return this.importer.findNode(path, parent);
    }

    public void setProperties(Properties props) {
        String profileName;
        this.designerProperties = props;
        if (this.folder == null) {
            IProject project = DesignerPropertiesUtil.getProject((Properties)this.designerProperties);
            IContainer srcFolder = DesignerPropertiesUtil.getSourcesFolder((Properties)this.designerProperties);
            if (srcFolder != null) {
                this.setFolder(srcFolder);
            } else if (project != null) {
                this.setFolder((IContainer)project);
            }
        }
        if (this.connectionProfile == null && (profileName = DesignerPropertiesUtil.getConnectionProfileName((Properties)this.designerProperties)) != null && !profileName.isEmpty()) {
            this.srcPg.selectConnectionProfile(profileName);
        }
    }

    public Properties getDesignerProperties() {
        return this.designerProperties;
    }

    class ProcessorPack {
        private RelationalModelProcessor rmpProcessor;
        private JdbcSource src;
        private IFile modelFile;
        private ModelResource resrc;

        public ProcessorPack() {
        }

        public ProcessorPack(RelationalModelProcessor rmpProcessor, JdbcSource src, IFile modelFile, ModelResource resrc) {
            this.rmpProcessor = rmpProcessor;
            this.src = src;
            this.modelFile = modelFile;
            this.resrc = resrc;
        }

        public void setProcessor(RelationalModelProcessor rmpProcessor) {
            this.rmpProcessor = rmpProcessor;
        }

        public RelationalModelProcessor getProcessor() {
            return this.rmpProcessor;
        }

        public void setJdbcSource(JdbcSource src) {
            this.src = src;
        }

        public JdbcSource getJdbcSource() {
            return this.src;
        }

        public void setModelFile(IFile modelFile) {
            this.modelFile = modelFile;
        }

        public IFile getModelFile() {
            return this.modelFile;
        }

        public void setModelResource(ModelResource resrc) {
            this.resrc = resrc;
        }

        public ModelResource getModelResource() {
            return this.resrc;
        }
    }
}

