/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.ui.wizards;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.DatatoolsPlugin;
import org.teiid.designer.datatools.JdbcTranslatorHelper;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.ui.InternalModelerJdbcUiPluginConstants;
import org.teiid.designer.type.IDataTypeManagerService;

public class JDBCConnectionInfoProvider
extends ConnectionInfoHelper
implements IConnectionInfoProvider {
    public static final String SAVE_PWD_KEY = "org.eclipse.datatools.connectivity.db.savePWD";
    public static final String DRIVER_DEFN_TYPE_KEY = "org.eclipse.datatools.connectivity.drivers.defnType";
    public static final String USERNAME_KEY = "org.eclipse.datatools.connectivity.db.username";
    public static final String DRIVER_CLASS_KEY = "org.eclipse.datatools.connectivity.db.driverClass";
    public static final String DRIVER_DEFN_ID_KEY = "org.eclipse.datatools.connectivity.db.driverDefinitionID";
    public static final String DATABASE_NAME_KEY = "org.eclipse.datatools.connectivity.db.databaseName";
    public static final String PASSWORD_KEY = "org.eclipse.datatools.connectivity.db.password";
    public static final String URL_KEY = "org.eclipse.datatools.connectivity.db.URL";
    public static final String VERSION_KEY = "org.eclipse.datatools.connectivity.db.version";
    public static final String VENDOR_KEY = "org.eclipse.datatools.connectivity.db.vendor";
    String DRIVER_CLASS = "driver-class";
    String VENDOR = "vendor";
    String VERSION = "version";
    String DATABASE_NAME = "databaseName";
    String URL = "connection-url";
    String USERNAME = "user-name";
    String PASSWORD = "password";
    String JARLIST = "jarList";
    String UNKNOWN = "unknown";
    public static final String JDBC_IMPORT_DRIVER_CLASS = "com.metamatrix.modeler.jdbc.JdbcSource.driverClass";
    public static final String JDBC_IMPORT_URL = "com.metamatrix.modeler.jdbc.JdbcSource.url";
    public static final String JDBC_IMPORT_USERNAME = "com.metamatrix.modeler.jdbc.JdbcSource.username";
    public static final String JDBC_IMPORT_DRIVER_NAME = "com.metamatrix.modeler.jdbc.JdbcSource.driverName";

    public void setConnectionInfo(ModelResource modelResource, IConnectionProfile connectionProfile) {
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        CoreArgCheck.isNotNull((Object)connectionProfile, (String)"connectionProfile");
        try {
            Properties connectionProps = this.getCommonProfileProperties(connectionProfile);
            connectionProps.put("connection:connectionProfileInstanceID", connectionProfile.getProviderId());
            Properties baseProps = connectionProfile.getBaseProperties();
            String driverClassName = null;
            boolean enoughProps = true;
            if (baseProps.get(DRIVER_CLASS_KEY) != null) {
                driverClassName = baseProps.get(DRIVER_CLASS_KEY).toString();
                connectionProps.put("connection:" + this.DRIVER_CLASS, baseProps.get(DRIVER_CLASS_KEY));
            } else {
                enoughProps = false;
            }
            if (baseProps.get(URL_KEY) != null) {
                connectionProps.put("connection:" + this.URL, baseProps.get(URL_KEY));
            } else {
                enoughProps = false;
            }
            if (baseProps.get(USERNAME_KEY) != null) {
                connectionProps.put("connection:" + this.USERNAME, baseProps.get(USERNAME_KEY));
            } else {
                enoughProps = false;
            }
            if (baseProps.get(this.JARLIST) != null) {
                connectionProps.put("connection:" + this.JARLIST, baseProps.get(this.JARLIST));
            } else {
                enoughProps = false;
            }
            if (!enoughProps) {
                throw new ModelWorkspaceException(InternalModelerJdbcUiPluginConstants.Util.getString("JDBCConnectionInfoProvider.notEnoughConnectionProviders", (Object)modelResource.getItemName()));
            }
            this.getHelper().removeProperties(modelResource, "connectionProfile:");
            this.getHelper().removeProperties(modelResource, "connection:");
            this.getHelper().removeProperties(modelResource, "translator:");
            this.getHelper().removeProperties(modelResource, "jdbcConnection:");
            String translatorName = JdbcTranslatorHelper.getTranslator((IConnectionProfile)connectionProfile);
            if (translatorName.equals("jdbc-simple")) {
                translatorName = JdbcTranslatorHelper.getTranslatorFromDriverName((String)driverClassName);
            }
            connectionProps.put("translator:name", translatorName);
            this.getHelper().setProperties(modelResource, connectionProps);
        }
        catch (ModelWorkspaceException e) {
            DatatoolsPlugin.Util.log(4, (Throwable)e, DatatoolsPlugin.Util.getString("errorSettingConnectionProfilePropertiesForModelResource", (Object)modelResource.getItemName()));
        }
    }

    public Properties getTeiidRelatedProperties(IConnectionProfile connectionProfile) {
        Properties connectionProps = new Properties();
        Properties baseProps = connectionProfile.getBaseProperties();
        if (baseProps.get(this.DRIVER_CLASS) != null) {
            connectionProps.put(this.DRIVER_CLASS, baseProps.get(this.DRIVER_CLASS));
        } else if (baseProps.get(DRIVER_CLASS_KEY) != null) {
            connectionProps.put(this.DRIVER_CLASS, baseProps.get(DRIVER_CLASS_KEY));
        }
        if (baseProps.get(this.URL) != null) {
            connectionProps.put(this.URL, baseProps.get(this.URL));
        } else if (baseProps.get(URL_KEY) != null) {
            connectionProps.put(this.URL, baseProps.get(URL_KEY));
        }
        if (baseProps.get(this.USERNAME) != null) {
            connectionProps.put(this.USERNAME, baseProps.get(this.USERNAME));
        } else if (baseProps.get(USERNAME_KEY) != null) {
            connectionProps.put(this.USERNAME, baseProps.get(USERNAME_KEY));
        }
        if (baseProps.get(this.PASSWORD) != null) {
            connectionProps.put(this.PASSWORD, baseProps.get(this.PASSWORD));
        } else if (baseProps.get(PASSWORD_KEY) != null) {
            connectionProps.put(this.PASSWORD, baseProps.get(PASSWORD_KEY));
        }
        if (baseProps.get(this.JARLIST) != null) {
            connectionProps.put(this.JARLIST, baseProps.get(this.JARLIST));
        }
        return connectionProps;
    }

    private JdbcSource findJdbcSource(IResource resource) throws ModelWorkspaceException {
        ModelResource mr = ModelUtil.getModelResource((IFile)((IFile)resource), (boolean)true);
        if (mr != null) {
            List allEObjects = mr.getEObjects();
            for (EObject nextEObject : allEObjects) {
                if (!(nextEObject instanceof JdbcSource)) continue;
                return (JdbcSource)nextEObject;
            }
        } else {
            throw new ModelWorkspaceException(InternalModelerJdbcUiPluginConstants.Util.getString("JDBCConnectionInfoProvider.errorFindingModelResourceForModelFile", (Object)resource.getName()));
        }
        return null;
    }

    public Properties getModelJdbcConnectionProperties(ModelResource modelResource) throws ModelWorkspaceException {
        JdbcSource jdbcSource;
        CoreArgCheck.isNotNull((Object)modelResource, (String)"modelResource");
        Properties result = new Properties();
        if (ModelUtil.isPhysical((Object)modelResource.getEmfResource()) && (jdbcSource = this.findJdbcSource(modelResource.getCorrespondingResource())) != null) {
            if (jdbcSource.getDriverClass() != null) {
                result.put(this.DRIVER_CLASS, jdbcSource.getDriverClass());
            }
            if (jdbcSource.getUrl() != null) {
                result.put(this.URL, jdbcSource.getUrl());
            }
            if (jdbcSource.getUsername() != null) {
                result.put(this.USERNAME, jdbcSource.getUsername());
            }
            if (jdbcSource.getPassword() != null) {
                result.put(this.PASSWORD, jdbcSource.getPassword());
            }
        }
        return result;
    }

    public String getPasswordPropertyKey() {
        return PASSWORD_KEY;
    }

    public String getDataSourcePasswordPropertyKey() {
        return this.PASSWORD;
    }

    public String getDataSourceType() {
        return ModelerCore.getTeiidDataTypeManagerService().getDataSourceType(IDataTypeManagerService.DataSourceTypes.JDBC);
    }

    public boolean requiresPassword(IConnectionProfile connectionProfile) {
        return true;
    }
}

