/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.connectivity;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.drivers.jdbc.JDBCConnection;
import org.teiid.datatools.connectivity.ConnectivityUtil;
import org.teiid.datatools.connectivity.Messages;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public class TeiidJDBCConnection
extends JDBCConnection {
    public TeiidJDBCConnection(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
    }

    private Connection connect(Driver jdbcDriver, String connectURL, Properties connectionProps) throws Exception {
        if (jdbcDriver == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.TeiidJDBCConnection.noDriverFound, connectURL));
        }
        try {
            return jdbcDriver.connect(connectURL, connectionProps);
        }
        catch (SQLException ex) {
            String msg = Messages.getString(Messages.TeiidJDBCConnection.invalidUserPassword, connectURL);
            throw new Exception(msg, ex);
        }
    }

    protected Object createConnection(ClassLoader classloader) throws Throwable {
        TeiidServerVersion teiidServerVersion;
        Properties props = this.getConnectionProfile().getBaseProperties();
        Properties connectionProps = new Properties();
        String driverClass = null;
        driverClass = this.getDriverDefinition() != null ? this.getDriverDefinition().getProperty("org.eclipse.datatools.connectivity.db.driverClass") : props.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
        String connectURL = props.getProperty("org.eclipse.datatools.connectivity.db.URL");
        String uid = props.getProperty("org.eclipse.datatools.connectivity.db.username");
        String passToken = props.getProperty("org.eclipse.datatools.connectivity.db.password");
        String urlStorageKey = ConnectivityUtil.buildSecureStorageKey(((Object)((Object)this)).getClass(), connectURL, passToken);
        String pwd = ConnectivityUtil.getSecureStorageProvider().getFromSecureStorage(urlStorageKey, "jdbc_password");
        String nameValuePairs = props.getProperty("org.eclipse.datatools.connectivity.db.connectionProperties");
        String propDelim = ",";
        if (uid != null) {
            connectionProps.setProperty("user", uid);
        }
        if (pwd != null) {
            connectionProps.setProperty("password", pwd);
        }
        if (nameValuePairs != null && nameValuePairs.length() > 0) {
            String[] pairs = this.parseString(nameValuePairs, ",");
            String addPairs = "";
            int i = 0;
            while (i < pairs.length) {
                String[] namevalue = this.parseString(pairs[i], "=");
                connectionProps.setProperty(namevalue[0], namevalue[1]);
                if (i == 0 || i < pairs.length - 1) {
                    addPairs = String.valueOf(addPairs) + propDelim;
                }
                addPairs = String.valueOf(addPairs) + pairs[i];
                ++i;
            }
        }
        Driver jdbcDriver = null;
        try {
            jdbcDriver = (Driver)classloader.loadClass(driverClass).newInstance();
        }
        catch (Throwable throwable) {}
        if (jdbcDriver != null) {
            return this.connect(jdbcDriver, connectURL, connectionProps);
        }
        String teiidVersion = props.getProperty("org.eclipse.datatools.connectivity.db.version");
        if (teiidVersion != null && (jdbcDriver = ConnectivityUtil.getTeiidDriver((ITeiidServerVersion)(teiidServerVersion = new TeiidServerVersion(teiidVersion)), driverClass)) != null) {
            return this.connect(jdbcDriver, connectURL, connectionProps);
        }
        throw new Exception(Messages.getString(Messages.TeiidJDBCConnection.noDriverFound, connectURL));
    }
}

