/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.refactor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.refactor.PathPair;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbModelEntry;
import org.teiid.designer.vdb.VdbPlugin;
import org.teiid.designer.vdb.VdbUtil;

public class VdbResourceChange
extends ResourceChange {
    private final Set<PathPair> replacements = new HashSet<PathPair>();
    private String projectName;
    private String parentFolder;
    private String vdbName;

    public VdbResourceChange(String projectName, String parentFolder, String vdbName) {
        CoreArgCheck.isNotNull((Object)projectName);
        CoreArgCheck.isNotNull((Object)parentFolder);
        CoreArgCheck.isNotNull((Object)vdbName);
        this.projectName = projectName;
        this.parentFolder = parentFolder;
        this.vdbName = vdbName;
    }

    public VdbResourceChange(IFile vdbFile) {
        CoreArgCheck.isNotNull((Object)vdbFile);
        this.projectName = vdbFile.getProject().getName();
        this.parentFolder = vdbFile.getParent().getName();
        this.vdbName = vdbFile.getName();
    }

    private IFile findVdb(IWorkspaceRoot workspaceRoot, IProject project) {
        if (!project.isAccessible()) {
            return null;
        }
        Collection resources = WorkspaceResourceFinderUtil.findIResourceInProjectByName((String)this.vdbName, (IProject)project);
        if (resources.isEmpty()) {
            return null;
        }
        for (IFile vdbFile : resources) {
            IContainer container = vdbFile.getParent();
            if (this.parentFolder.equals(container.getName())) {
                return vdbFile;
            }
            for (PathPair pathPair : this.replacements) {
                Path sourcePath = new Path(pathPair.getSourcePath());
                Path targetPath = new Path(pathPair.getTargetPath());
                if (!container.getFullPath().isPrefixOf((IPath)sourcePath) && !container.getFullPath().isPrefixOf((IPath)targetPath)) continue;
                return vdbFile;
            }
        }
        return null;
    }

    private IFile findVdb() {
        IWorkspaceRoot workspaceRoot = ModelerCore.getWorkspace().getRoot();
        IProject vdbProject = workspaceRoot.getProject(this.projectName);
        if (!vdbProject.isAccessible()) {
            for (PathPair pathPair : this.replacements) {
                Path sourcePath = new Path(pathPair.getSourcePath());
                Path targetPath = new Path(pathPair.getTargetPath());
                vdbProject = workspaceRoot.getProject(sourcePath.segment(0));
                IFile vdbFile = this.findVdb(workspaceRoot, vdbProject);
                if (vdbFile != null) {
                    return vdbFile;
                }
                vdbProject = workspaceRoot.getProject(targetPath.segment(0));
                vdbFile = this.findVdb(workspaceRoot, vdbProject);
                if (vdbFile == null) continue;
                return vdbFile;
            }
        }
        IFile vdbFile = this.findVdb(workspaceRoot, vdbProject);
        return vdbFile;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public String getVdbName() {
        return this.vdbName;
    }

    protected IResource getModifiedResource() {
        return this.findVdb();
    }

    private Change getUndoChange() {
        VdbResourceChange change = new VdbResourceChange(this.projectName, this.parentFolder, this.vdbName);
        for (PathPair pathPair : this.replacements) {
            change.addReplacement(pathPair.getTargetPath(), pathPair.getSourcePath());
        }
        return change;
    }

    protected IStatus performTask(IProgressMonitor monitor) {
        IFile vdbFile = this.findVdb();
        if (vdbFile == null) {
            String msg = VdbPlugin.UTIL.getString(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".syncVdbFailure", new Object[]{this.projectName, this.parentFolder, this.vdbName});
            Status status = new Status(2, VdbPlugin.ID, msg);
            return status;
        }
        try {
            vdbFile.getProject().refreshLocal(2, monitor);
            VdbUtil.synchronizeVdb(vdbFile, false, true);
            Vdb actualVdb = new Vdb(vdbFile, monitor);
            for (VdbModelEntry entry : actualVdb.getModelEntries()) {
                for (PathPair pathPair : this.replacements) {
                    if (!entry.getName().equals((Object)pathPair.getSourcePath())) continue;
                    actualVdb.removeEntry(entry);
                    actualVdb.save(monitor);
                }
            }
        }
        catch (Exception ex) {
            return new Status(4, VdbPlugin.ID, ex.getMessage());
        }
        return Status.OK_STATUS;
    }

    public void addReplacements(Set<PathPair> replacedResourcePaths) {
        this.replacements.addAll(replacedResourcePaths);
    }

    public void addReplacement(String invalidResourcePath, String newResourcePath) {
        PathPair resourcePair = new PathPair(invalidResourcePath, newResourcePath);
        this.replacements.add(resourcePair);
    }

    public Set<PathPair> getReplacedResources() {
        return this.replacements;
    }

    public String getName() {
        return VdbPlugin.UTIL.getString(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".name", (Object)this.vdbName);
    }

    public Change perform(IProgressMonitor pm) {
        Job job = new Job(this.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                return VdbResourceChange.this.performTask(monitor);
            }
        };
        job.schedule();
        return this.getUndoChange();
    }
}

