/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.manifest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.vdb.TranslatorOverride;
import org.teiid.designer.vdb.manifest.PropertyElement;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="")
public class TranslatorElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="type", required=true)
    private String type;
    @XmlAttribute(name="description", required=false)
    private String description;
    @XmlElement(name="property", required=true, type=PropertyElement.class)
    private List<PropertyElement> properties = new ArrayList<PropertyElement>();

    TranslatorElement() {
    }

    TranslatorElement(TranslatorOverride translatorOverride) {
        this.name = translatorOverride.getName();
        this.type = translatorOverride.getType();
        this.description = translatorOverride.getDescription();
        TranslatorOverrideProperty[] translatorOverridePropertyArray = translatorOverride.getProperties();
        int n = translatorOverridePropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            TranslatorOverrideProperty prop = translatorOverridePropertyArray[n2];
            if (!StringUtilities.isEmpty((String)prop.getOverriddenValue())) {
                this.properties.add(new PropertyElement(prop.getDefinition().getId(), prop.getOverriddenValue()));
            }
            ++n2;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public List<PropertyElement> getProperties() {
        return this.properties;
    }

    public String getType() {
        return this.type;
    }
}

