/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.connections;

import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.teiid.designer.vdb.VdbPlugin;
import org.teiid.designer.vdb.connections.SourceHandler;
import org.teiid.designer.vdb.connections.VdbSourceConnection;

public class SourceHandlerExtensionManager {
    private static boolean extensionsLoaded;
    private static SourceHandler vdbSourceHandler;

    public static Object[] findApplicableActions(Object obj) {
        if (!extensionsLoaded) {
            SourceHandlerExtensionManager.loadExtensions();
        }
        Object[] actions = null;
        if (vdbSourceHandler != null) {
            try {
                actions = vdbSourceHandler.getApplicableActions(obj);
            }
            catch (Exception e) {
                String message = VdbPlugin.UTIL.getString("errorFindingApplicableActionsFor", obj);
                VdbPlugin.UTIL.log(4, (Throwable)e, message);
            }
        }
        return actions;
    }

    public static VdbSourceConnection findVdbSourceConnection(String sourceModelName, Properties properties) {
        if (!extensionsLoaded) {
            SourceHandlerExtensionManager.loadExtensions();
        }
        VdbSourceConnection sourceConnection = null;
        if (vdbSourceHandler != null) {
            try {
                sourceConnection = vdbSourceHandler.ensureVdbSourceConnection(sourceModelName, properties);
            }
            catch (Exception e) {
                String message = VdbPlugin.UTIL.getString("errorFindingVdbSourceConnection", (Object)sourceModelName);
                VdbPlugin.UTIL.log(4, (Throwable)e, message);
            }
        }
        return sourceConnection;
    }

    public static SourceHandler getVdbConnectionFinder() {
        if (!extensionsLoaded) {
            SourceHandlerExtensionManager.loadExtensions();
        }
        return vdbSourceHandler;
    }

    private static void loadExtensions() {
        extensionsLoaded = true;
        String id = "sourceHandler";
        String classTag = "class";
        String className = "name";
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.vdb", id);
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions != null & extensions.length > 0) {
            String message;
            IConfigurationElement[] elements = extensions[0].getConfigurationElements();
            try {
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals(classTag)) {
                        vdbSourceHandler = (SourceHandler)elements[j].createExecutableExtension(className);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                message = VdbPlugin.UTIL.getString("errorloadingExtensionsErrorMessage", (Object)extensions[0].getUniqueIdentifier());
                VdbPlugin.UTIL.log(4, (Throwable)e, message);
            }
            if (extensions.length > 1) {
                int i = 1;
                while (i < extensions.length) {
                    message = VdbPlugin.UTIL.getString("unexpectedExtensionErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                    VdbPlugin.UTIL.log(4, message);
                    ++i;
                }
            }
        }
    }
}

