/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipOutputStream;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.core.translators.TranslatorPropertyDefinition;
import org.teiid.designer.core.util.VdbHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.metamodels.function.FunctionPlugin;
import org.teiid.designer.metamodels.function.ScalarFunction;
import org.teiid.designer.metamodels.function.extension.FunctionModelExtensionConstants;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionConstants;
import org.teiid.designer.vdb.TranslatorOverride;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbFileEntry;
import org.teiid.designer.vdb.VdbIndexedEntry;
import org.teiid.designer.vdb.VdbSource;
import org.teiid.designer.vdb.VdbSourceInfo;
import org.teiid.designer.vdb.manifest.ModelElement;
import org.teiid.designer.vdb.manifest.ProblemElement;
import org.teiid.designer.vdb.manifest.PropertyElement;
import org.teiid.designer.vdb.manifest.SourceElement;

@ThreadSafe
public final class VdbModelEntry
extends VdbIndexedEntry {
    private String modelUuid;
    private final AtomicBoolean visible = new AtomicBoolean(true);
    final CopyOnWriteArraySet<VdbEntry> imports = new CopyOnWriteArraySet();
    final CopyOnWriteArraySet<VdbModelEntry> importedBy = new CopyOnWriteArraySet();
    final CopyOnWriteArraySet<String> importVdbNames = new CopyOnWriteArraySet();
    final CopyOnWriteArraySet<VdbFileEntry> udfJars = new CopyOnWriteArraySet();
    private final String modelClass;
    private final boolean builtIn;
    private final String type;
    final VdbSourceInfo sourceInfo;
    private transient ModelElement element;

    public static String createDefaultSourceName(IPath path) {
        return path.removeFileExtension().lastSegment();
    }

    VdbModelEntry(Vdb vdb, IPath name, IProgressMonitor monitor) throws Exception {
        super(vdb, name, monitor);
        Resource model = this.findModel();
        this.builtIn = this.getFinder().isBuiltInResource(model);
        this.modelClass = this.findModelClass(model);
        this.sourceInfo = new VdbSourceInfo(vdb);
        if (ModelUtil.isXmiFile((Resource)model)) {
            ModelResource mr = ModelerCore.getModelEditor().findModelResource(model);
            EmfResource emfModel = (EmfResource)model;
            this.type = emfModel.getModelType().getName();
            this.modelUuid = ModelUtil.getUuidString((Object)mr);
            if (ModelUtil.isPhysical((Object)model)) {
                String defaultName = VdbModelEntry.createDefaultSourceName(name);
                ConnectionInfoHelper helper = new ConnectionInfoHelper();
                String translator = helper.getTranslatorName(mr);
                if (translator == null) {
                    translator = "";
                }
                String jndiName = defaultName;
                String jndiProp = helper.getJndiProperty(mr);
                if (!CoreStringUtil.isEmpty((String)jndiProp)) {
                    jndiName = jndiProp;
                }
                this.sourceInfo.add(defaultName, jndiName, translator);
                Properties translatorProps = helper.getTranslatorOverrideProperties(mr);
                if (!translatorProps.isEmpty()) {
                    this.updateTranslatorOverrides(translatorProps);
                }
            }
            this.visible.set(true);
        } else {
            this.type = "OTHER";
        }
        if (this.description.get() == null) {
            this.description.set("");
        }
    }

    private void updateUdfJars(Resource model) throws Exception {
        if (model == null) {
            return;
        }
        ModelResource mdlResrc = ModelerCore.getModelEditor().findModelResource(model);
        if (mdlResrc == null) {
            return;
        }
        this.udfJars.clear();
        IProject project = mdlResrc.getModelProject().getProject();
        List jarResources = VdbHelper.getUdfJarResources((IProject)project);
        EList children = model.getContents();
        for (EObject eObj : children) {
            String udfJarPath = null;
            if (eObj instanceof ScalarFunction) {
                udfJarPath = VdbModelEntry.getUdfJarPath((ScalarFunction)eObj);
            } else if (eObj instanceof Procedure && ((Procedure)eObj).isFunction()) {
                udfJarPath = VdbModelEntry.getUdfJarPath((Procedure)eObj);
            }
            if (udfJarPath == null || udfJarPath.trim().length() == 0) continue;
            for (IResource jarResource : jarResources) {
                IPath path;
                if (!(jarResource instanceof IFile) || !(path = ((IFile)jarResource).getProjectRelativePath()).toString().equals(udfJarPath)) continue;
                this.udfJars.add(new VdbFileEntry(this.getVdb(), jarResource.getFullPath(), VdbFileEntry.FileEntryType.UDFJar, (IProgressMonitor)new NullProgressMonitor()));
            }
        }
    }

    public static String getUdfJarPath(ScalarFunction scalarFunc) {
        String udfJarPath = null;
        ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(FunctionModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
        if (assistant != null) {
            try {
                udfJarPath = assistant.getPropertyValue((Object)scalarFunc, FunctionModelExtensionConstants.PropertyIds.UDF_JAR_PATH);
            }
            catch (Exception ex) {
                ModelerCore.Util.log(4, (Throwable)ex, FunctionPlugin.Util.getString("FunctionUtil.ErrorGettingJarPath", (Object)scalarFunc.getName()));
            }
        }
        return udfJarPath;
    }

    public static String getUdfJarPath(Procedure proc) {
        String udfJarPath = null;
        ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
        if (assistant != null) {
            try {
                udfJarPath = assistant.getPropertyValue((Object)proc, RelationalModelExtensionConstants.PropertyIds.UDF_JAR_PATH);
            }
            catch (Exception ex) {
                String msg = RelationalPlugin.Util.getString("ProcedureVirtualFunctionRule.errorGettingJarPath", (Object)proc.getName());
                RelationalPlugin.Util.log(4, (Throwable)ex, msg);
            }
        }
        return udfJarPath;
    }

    VdbModelEntry(Vdb vdb, ModelElement element, IProgressMonitor monitor) throws Exception {
        super(vdb, element, monitor);
        this.element = element;
        this.type = element.getType();
        this.visible.set(element.isVisible());
        this.sourceInfo = new VdbSourceInfo(vdb);
        if (element.getSources() != null && !element.getSources().isEmpty()) {
            for (SourceElement source : element.getSources()) {
                this.sourceInfo.add(source.getName(), source.getJndiName(), source.getTranslatorName() == null ? "" : source.getTranslatorName());
            }
        }
        if ("FUNCTION".equals(this.type) || "VIRTUAL".equals(this.type) || "PHYSICAL".equals(this.type)) {
            this.updateUdfJars(this.findModel());
        }
        for (ProblemElement problem : element.getProblems()) {
            this.addProblem(new VdbIndexedEntry.Problem((VdbIndexedEntry)this, problem));
        }
        boolean builtIn = false;
        String modelClass = null;
        for (PropertyElement property : element.getProperties()) {
            String name = property.getName();
            if ("builtIn".equals(name)) {
                builtIn = Boolean.parseBoolean(property.getValue());
                continue;
            }
            if ("modelClass".equals(name)) {
                modelClass = property.getValue();
                continue;
            }
            if ("modelUuid".equals(name)) {
                this.modelUuid = property.getValue();
                continue;
            }
            if ("import-vdb-reference".equals(name)) {
                this.importVdbNames.add(property.getValue());
                continue;
            }
            if ("supports-multi-source-bindings".equals(name)) {
                this.sourceInfo.setIsMultiSource(Boolean.parseBoolean(property.getValue()));
                continue;
            }
            if ("multisource.addColumn".equals(name)) {
                this.sourceInfo.setAddColumn(Boolean.parseBoolean(property.getValue()));
                continue;
            }
            if (!"multisource.columnName".equals(name)) continue;
            this.sourceInfo.setColumnAlias(property.getValue());
        }
        this.builtIn = builtIn;
        this.modelClass = modelClass;
        this.getVdb().registerImportVdbs(this.importVdbNames, this.getName().toString(), monitor);
        this.getVdb().synchronizeUdfJars(this.udfJars);
    }

    @Override
    protected void clean() {
        super.clean();
        for (VdbEntry entry : this.imports) {
            if (!(entry instanceof VdbModelEntry)) continue;
            VdbModelEntry vdbModelEntry = (VdbModelEntry)entry;
            vdbModelEntry.importedBy.remove(this);
            if (!vdbModelEntry.isBuiltIn()) continue;
            entry.dispose();
        }
        this.imports.clear();
    }

    @Override
    final void dispose() {
        super.dispose();
        ArrayList<VdbModelEntry> importedByModels = new ArrayList<VdbModelEntry>(this.importedBy);
        for (VdbModelEntry entry : importedByModels) {
            this.importedBy.remove(entry);
            this.getVdb().removeEntry(entry);
        }
        this.clean();
    }

    private String findModelClass(Resource resource) throws Exception {
        return ModelUtil.getModelClass((Object)resource);
    }

    public final boolean containsUdf() throws Exception {
        boolean hasUdf = false;
        if ("FUNCTION".equals(this.getType())) {
            hasUdf = true;
        } else {
            Resource modelResc = this.findModel();
            boolean isRelational = false;
            isRelational = ModelUtil.getModelClass((Object)modelResc).equals("Relational");
            if (isRelational) {
                try {
                    ModelResource mr = ModelerCore.getModelEditor().findModelResource(modelResc);
                    List eObjs = mr.getEObjects();
                    for (EObject eObj : eObjs) {
                        if (!(eObj instanceof Procedure) || !((Procedure)eObj).isFunction()) continue;
                        hasUdf = true;
                        break;
                    }
                }
                catch (ModelWorkspaceException modelWorkspaceException) {}
            }
        }
        return hasUdf;
    }

    public final Set<VdbModelEntry> getImportedBy() {
        return Collections.unmodifiableSet(this.importedBy);
    }

    public final Set<? extends VdbEntry> getImports() {
        return Collections.unmodifiableSet(this.imports);
    }

    public final Set<String> getImportVdbNames() {
        return Collections.unmodifiableSet(this.importVdbNames);
    }

    public final Set<VdbFileEntry> getUdfJars() {
        return Collections.unmodifiableSet(this.udfJars);
    }

    public VdbSourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public final String getType() {
        return this.type;
    }

    void initializeImports() {
        block0: for (PropertyElement property : this.element.getProperties()) {
            if (!"imports".equals(property.getName())) continue;
            for (VdbModelEntry entry : this.getVdb().modelEntries) {
                if (!property.getValue().equals(entry.getName().toString())) continue;
                entry.importedBy.add(this);
                this.imports.add(entry);
                continue block0;
            }
        }
        this.element = null;
    }

    public final String getModelUuid() {
        return this.modelUuid;
    }

    public final String getModelClass() {
        return this.modelClass;
    }

    public final boolean isBuiltIn() {
        return this.builtIn;
    }

    public final boolean isVisible() {
        return this.visible.get();
    }

    @Override
    final void save(ZipOutputStream out, IProgressMonitor monitor) throws Exception {
        super.save(out, monitor);
    }

    public void setJndiName(int index, String name) {
        String oldName;
        CoreArgCheck.isTrue((index < this.sourceInfo.getSourceCount() ? 1 : 0) != 0, (String)"index out of range");
        if (StringUtilities.isEmpty((String)name)) {
            name = null;
        }
        if (StringUtilities.equals((String)name, (String)(oldName = this.sourceInfo.getSource(index).getJndiName()))) {
            return;
        }
        this.sourceInfo.getSource(index).setJndiName(name);
    }

    public final void setSourceName(int index, String name) {
        String oldName;
        CoreArgCheck.isTrue((index < this.sourceInfo.getSourceCount() ? 1 : 0) != 0, (String)"index out of range");
        if (StringUtilities.isEmpty((String)name)) {
            name = null;
        }
        if (StringUtilities.equals((String)name, (String)(oldName = this.sourceInfo.getSource(index).getName()))) {
            return;
        }
        this.sourceInfo.getSource(index).setName(name);
    }

    public final void setTranslatorName(int index, String name) {
        String oldName;
        CoreArgCheck.isTrue((index < this.sourceInfo.getSourceCount() ? 1 : 0) != 0, (String)"index out of range");
        if (StringUtilities.isEmpty((String)name)) {
            name = null;
        }
        if (StringUtilities.equals((String)name, (String)(oldName = this.sourceInfo.getSource(index).getTranslatorName()))) {
            return;
        }
        this.sourceInfo.getSource(index).setTranslatorName(name);
    }

    public final TranslatorOverride getTranslatorOverride() {
        if (!this.sourceInfo.isEmpty()) {
            Set<TranslatorOverride> overrides = this.getVdb().getTranslators();
            for (TranslatorOverride to : overrides) {
                for (VdbSource source : this.sourceInfo.getSources()) {
                    String translatorName = source.getTranslatorName();
                    if (translatorName == null || !translatorName.toString().equalsIgnoreCase(to.getType())) continue;
                    return to;
                }
            }
        }
        return null;
    }

    void updateTranslatorOverrides(Properties props) {
        if (this.sourceInfo.isMultiSource()) {
            return;
        }
        if (props.size() == 1 && ((String)props.keySet().toArray()[0]).equalsIgnoreCase("name")) {
            return;
        }
        TranslatorOverride to = this.getTranslatorOverride();
        String oldTranslator = this.sourceInfo.getSource(0).getTranslatorName();
        String newTranslator = null;
        if (to == null) {
            String toName = null;
            if (!oldTranslator.startsWith(this.sourceInfo.getSource(0).getName())) {
                toName = String.valueOf(this.sourceInfo.getSource(0).getName()) + '_' + oldTranslator;
            }
            to = new TranslatorOverride(this.getVdb(), toName, oldTranslator, null);
            newTranslator = toName;
            this.sourceInfo.getSource(0).setTranslatorName(toName);
            this.getVdb().addTranslator(to, (IProgressMonitor)new NullProgressMonitor());
        }
        TranslatorOverrideProperty[] toProps = to.getProperties();
        Set<Object> keys = props.keySet();
        for (Object nextKey : keys) {
            boolean existing = "name".equals(nextKey);
            TranslatorOverrideProperty[] translatorOverridePropertyArray = toProps;
            int n = toProps.length;
            int n2 = 0;
            while (n2 < n) {
                TranslatorOverrideProperty toProp = translatorOverridePropertyArray[n2];
                if (toProp.getDefinition().getId().equals(nextKey)) {
                    toProp.setValue(props.getProperty((String)nextKey));
                    existing = true;
                    break;
                }
                ++n2;
            }
            if (existing) continue;
            to.addProperty(new TranslatorOverrideProperty(new TranslatorPropertyDefinition((String)nextKey, "dummy"), props.getProperty((String)nextKey)));
        }
        this.getVdb().setModified(this, "modelEntry.translator", oldTranslator, newTranslator);
    }

    public final void setVisible(boolean visible) {
        boolean oldVisible = this.isVisible();
        if (oldVisible == visible) {
            return;
        }
        this.visible.set(visible);
        this.getVdb().setModified(this, "modelentry.visible", oldVisible, visible);
    }

    @Override
    public void synchronize(IProgressMonitor monitor) throws Exception {
        if (this.getSynchronization() != VdbEntry.Synchronization.NotSynchronized) {
            return;
        }
        this.synchronizeModelEntry(monitor);
        super.synchronize(monitor);
    }

    void synchronizeModelEntry(IProgressMonitor monitor) throws Exception {
        IFile workspaceFile = this.findFileInWorkspace();
        if (workspaceFile == null) {
            return;
        }
        this.clean();
        Resource model = this.findModel();
        if (ModelUtil.isPhysical((Object)model) && !this.getSourceInfo().isMultiSource()) {
            Properties translatorProps;
            ModelResource mr = ModelerCore.getModelEditor().findModelResource((IResource)workspaceFile);
            ConnectionInfoHelper helper = new ConnectionInfoHelper();
            String translatorName = this.sourceInfo.getSource(0).getTranslatorName();
            String resourceTranslatorName = helper.getTranslatorName(mr);
            if (!CoreStringUtil.isEmpty((String)resourceTranslatorName) && !CoreStringUtil.equals((String)translatorName, (String)resourceTranslatorName)) {
                this.sourceInfo.getSource(0).setTranslatorName(resourceTranslatorName == null ? "" : resourceTranslatorName);
            }
            if (!(translatorProps = helper.getTranslatorProperties(mr)).isEmpty()) {
                this.updateTranslatorOverrides(translatorProps);
            }
            String jndiName = this.sourceInfo.getSource(0).getJndiName();
            String resourceJndiName = helper.getJndiProperty(mr);
            if (!CoreStringUtil.isEmpty((String)resourceJndiName) && !CoreStringUtil.equals((String)jndiName, (String)resourceJndiName)) {
                this.sourceInfo.getSource(0).setJndiName(resourceJndiName == null ? "" : resourceJndiName);
            }
        }
        if (this.containsUdf()) {
            this.updateUdfJars(model);
        }
        this.synchronizeIndex(monitor);
        if (!this.getVdb().isPreview()) {
            this.importVdbNames.clear();
            Resource[] refs = this.getFinder().findReferencesFrom(model, true, false);
            if (refs != null) {
                Resource[] resourceArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource importedModel = resourceArray[n2];
                    URI uri = URI.create(importedModel.getURI().toString());
                    IFile[] modelFiles = ModelerCore.getWorkspace().getRoot().findFilesForLocationURI(uri);
                    IPath name = modelFiles[0].getFullPath();
                    String importVdbName = ModelUtil.getModelAnnotationPropertyValue((IFile)modelFiles[0], (String)"core:vdb-name");
                    if (importVdbName != null) {
                        this.importVdbNames.add(importVdbName);
                    } else {
                        VdbModelEntry importedEntry = null;
                        for (VdbModelEntry entry : this.getVdb().getModelEntries()) {
                            if (!name.equals((Object)entry.getName())) continue;
                            importedEntry = entry;
                            break;
                        }
                        if (importedEntry == null) {
                            importedEntry = (VdbModelEntry)this.getVdb().addEntry(name, monitor);
                        }
                        this.imports.add(importedEntry);
                        if (importedEntry instanceof VdbModelEntry) {
                            importedEntry.importedBy.add(this);
                        }
                    }
                    ++n2;
                }
            }
            this.getVdb().registerImportVdbs(this.importVdbNames, this.getName().toString(), monitor);
            this.getVdb().synchronizeUdfJars(this.udfJars);
        }
    }

    void replaceImport(VdbEntry oldEntry, VdbEntry newEntry) {
        this.imports.remove(oldEntry);
        this.imports.add(newEntry);
    }

    @Override
    protected void toString(StringBuilder builder) {
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", visible?=");
        builder.append(this.visible);
        builder.append(", built-in?=");
        builder.append(this.builtIn);
        for (VdbSource source : this.sourceInfo.getSources()) {
            builder.append(", source=");
            builder.append(source);
        }
        builder.append(", index=");
        builder.append(this.getIndexName());
        builder.append(", problems?=");
        builder.append(!this.getProblems().isEmpty());
        builder.append(", imports=[");
        Iterator<VdbEntry> iter = this.imports.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next().getName());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(']');
    }
}

