/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.util.concurrent.atomic.AtomicReference;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.manifest.ImportVdbElement;

public class VdbImportVdbEntry {
    private final Vdb vdb;
    private String name;
    final AtomicReference<Integer> version = new AtomicReference();
    final AtomicReference<Boolean> importDataPolicies = new AtomicReference();

    public VdbImportVdbEntry(Vdb vdb, String importVdbName) {
        this.vdb = vdb;
        this.name = importVdbName;
        this.version.set(1);
        this.importDataPolicies.set(false);
    }

    VdbImportVdbEntry(Vdb vdb, ImportVdbElement element) {
        this(vdb, element.getName());
        this.version.set(element.getVersion());
        this.importDataPolicies.set(element.isImportDataPolicies());
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version.get();
    }

    public void setVersion(int version) {
        int oldVersion = this.version.get();
        if (version == oldVersion) {
            return;
        }
        this.version.set(version);
        this.vdb.setModified(this, "importVdbEntryVersion", oldVersion, version);
    }

    public boolean isImportDataPolicies() {
        return this.importDataPolicies.get();
    }

    public void setImportDataPolicies(boolean importDataPolicies) {
        boolean oldImportDataPolicies = this.importDataPolicies.get();
        if (importDataPolicies == oldImportDataPolicies) {
            return;
        }
        this.importDataPolicies.set(importDataPolicies);
        this.vdb.setModified(this, "importVdbEntryDataPolicies", oldImportDataPolicies, importDataPolicies);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.vdb == null ? 0 : this.vdb.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VdbImportVdbEntry other = (VdbImportVdbEntry)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.vdb == null ? other.vdb != null : !this.vdb.equals(other.vdb));
    }
}

