/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.io.File;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.teiid.core.designer.util.ChecksumUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.OperationUtil;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.core.designer.util.ZipUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.manifest.EntryElement;
import org.teiid.designer.vdb.manifest.PropertyElement;

@ThreadSafe
public abstract class VdbEntry
implements StringConstants {
    private IPath name;
    private final Vdb vdb;
    private final AtomicReference<Synchronization> synchronization = new AtomicReference<Synchronization>(Synchronization.NotApplicable);
    private long checksum;
    final AtomicReference<String> description = new AtomicReference();
    private final int hashcode;
    private final ReadWriteLock checksumLock = new ReentrantReadWriteLock();

    VdbEntry(Vdb vdb, EntryElement element, IProgressMonitor monitor) throws Exception {
        this(vdb, Path.fromPortableString((String)element.getPath()));
        for (PropertyElement property : element.getProperties()) {
            String name = property.getName();
            if (!"checksum".equals(name)) continue;
            this.checksum = Long.parseLong(property.getValue());
        }
        IFile workspaceFile = this.findFileInWorkspace();
        if (workspaceFile != null) {
            this.setSynchronization(this.checksum == this.computeChecksum(workspaceFile) ? Synchronization.Synchronized : Synchronization.NotSynchronized);
        }
        this.description.set(element.getDescription() == null ? "" : element.getDescription());
    }

    private VdbEntry(Vdb vdb, IPath name) {
        this.vdb = vdb;
        this.name = name;
        this.hashcode = 31 + name.hashCode();
        if (this.description.get() == null) {
            this.description.set("");
        }
    }

    VdbEntry(Vdb vdb, IPath name, IProgressMonitor monitor) throws Exception {
        this(vdb, name);
        this.setSynchronization(this.synchronizeEntry(monitor));
    }

    private long computeChecksum(final IFile file) throws Exception {
        return (Long)OperationUtil.perform((OperationUtil.ReturningUnreliable)new OperationUtil.ReturningUnreliable<Long>(){
            private InputStream stream = null;

            public void doIfFails() {
                VdbEntry.this.setSynchronization(Synchronization.NotSynchronized);
            }

            public void finallyDo() throws Exception {
                if (this.stream != null) {
                    this.stream.close();
                }
            }

            public Long tryToDo() throws Exception {
                this.stream = file.getContents();
                if (this.stream == null) {
                    return -1L;
                }
                return ChecksumUtil.computeChecksum((InputStream)this.stream).getValue();
            }
        });
    }

    void dispose() {
        new File(this.vdb.getFolder(), this.name.toString()).delete();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VdbEntry other = (VdbEntry)object;
        return !(this.name == null ? other.name != null : !this.name.equals((Object)other.name));
    }

    public final boolean fileExistsInWorkspace() {
        return this.findFileInWorkspace() != null;
    }

    public final IFile findFileInWorkspace() {
        IResource resource = ModelerCore.getWorkspace().getRoot().findMember(this.name);
        if (resource == null && this.vdb != null && this.vdb.getFile() != null && this.vdb.getFile().getProject() != null) {
            IProject vdbProject = this.vdb.getFile().getProject();
            resource = vdbProject.findMember(this.name);
        }
        if (!(resource instanceof IFile)) {
            this.setSynchronization(Synchronization.NotApplicable);
            return null;
        }
        return (IFile)resource;
    }

    public final long getChecksum() {
        this.checksumLock.readLock().lock();
        try {
            long l = this.checksum;
            return l;
        }
        finally {
            this.checksumLock.readLock().unlock();
        }
    }

    public final String getDescription() {
        return this.description.get();
    }

    public final IPath getName() {
        return this.name;
    }

    public void setName(IPath name) {
        this.name = name;
    }

    public final Synchronization getSynchronization() {
        return this.synchronization.get();
    }

    final Vdb getVdb() {
        return this.vdb;
    }

    public final int hashCode() {
        return this.hashcode;
    }

    void save(ZipOutputStream out, IProgressMonitor monitor) throws Exception {
        String zipName = this.name.toString();
        if (zipName.startsWith("/")) {
            zipName = zipName.substring(1, zipName.length());
        }
        ZipEntry zipEntry = new ZipEntry(zipName);
        zipEntry.setComment(this.description.get());
        this.save(out, zipEntry, new File(this.vdb.getFolder(), this.name.toString()), monitor);
    }

    protected final void save(ZipOutputStream out, ZipEntry zipEntry, File file, IProgressMonitor monitor) throws Exception {
        ZipUtil.copy((File)file, (ZipEntry)zipEntry, (ZipOutputStream)out);
    }

    public final void setDescription(String description) {
        String oldDescription = this.description.get();
        if (StringUtilities.equals((String)description, (String)oldDescription)) {
            return;
        }
        this.description.set(description);
        this.vdb.setModified(this, "entry.description", oldDescription, description);
    }

    public void setSynchronization(Synchronization synchronization) {
        Synchronization oldSynchronization = this.getSynchronization();
        if (oldSynchronization == synchronization) {
            return;
        }
        this.synchronization.set(synchronization);
        this.vdb.notifyChangeListeners(this, "entry.synchronization", (Object)oldSynchronization, (Object)synchronization);
    }

    public void synchronize(IProgressMonitor monitor) throws Exception {
        if (this.synchronization.get() != Synchronization.NotSynchronized) {
            return;
        }
        this.setSynchronization(this.synchronizeEntry(monitor));
    }

    private Synchronization synchronizeEntry(IProgressMonitor monitor) throws Exception {
        IFile workspaceFile = this.findFileInWorkspace();
        if (workspaceFile == null) {
            return Synchronization.NotApplicable;
        }
        long oldChecksum = 0L;
        this.checksumLock.writeLock().lock();
        try {
            oldChecksum = this.checksum;
            this.checksum = this.computeChecksum(workspaceFile);
            FileUtils.copy((File)workspaceFile.getLocation().toFile(), (File)new File(this.vdb.getFolder(), this.name.toString()).getParentFile(), (boolean)true);
        }
        finally {
            this.checksumLock.writeLock().unlock();
        }
        this.vdb.setModified(this, "entry.checksum", oldChecksum, this.checksum);
        return Synchronization.Synchronized;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("(name=");
        builder.append(this.name);
        builder.append(", synchronization=");
        builder.append(this.synchronization);
        builder.append(", description=");
        builder.append(this.description);
        this.toString(builder);
        builder.append(')');
        return builder.toString();
    }

    protected void toString(StringBuilder builder) {
    }

    public static enum Synchronization {
        Synchronized,
        NotSynchronized,
        NotApplicable;

    }
}

