/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;
import org.fusesource.ide.camel.model.catalog.Dependency;

public class MavenUtils {
    public static void updateMavenDependencies(List<Dependency> compDeps) throws CoreException {
        RiderDesignEditor editor = Activator.getDiagramEditor();
        if (editor == null) {
            Activator.getLogger().error("Unable to add component dependencies because Editor instance can't be determined.");
            return;
        }
        IProject project = editor.getCamelContextFile().getProject();
        if (project == null) {
            Activator.getLogger().error("Unable to add component dependencies because selected project can't be determined.");
            return;
        }
        IPath pomPathValue = project.getProject().getRawLocation() != null ? project.getProject().getRawLocation().append("pom.xml") : ResourcesPlugin.getWorkspace().getRoot().getLocation().append(project.getFullPath().append("pom.xml"));
        String pomPath = pomPathValue.toOSString();
        File pomFile = new File(pomPath);
        Model model = MavenPlugin.getMaven().readModel(pomFile);
        ArrayList<Dependency> missingDeps = new ArrayList<Dependency>();
        List deps = model.getDependencies();
        for (Dependency conDep : compDeps) {
            boolean found = false;
            for (org.apache.maven.model.Dependency pomDep : deps) {
                if (!pomDep.getGroupId().equalsIgnoreCase(conDep.getGroupId()) || !pomDep.getArtifactId().equalsIgnoreCase(conDep.getArtifactId())) continue;
                if (!pomDep.getVersion().equalsIgnoreCase(conDep.getVersion())) {
                    pomDep.setVersion(conDep.getVersion());
                }
                found = true;
                break;
            }
            if (found) continue;
            missingDeps.add(conDep);
        }
        for (Dependency missDep : missingDeps) {
            org.apache.maven.model.Dependency dep = new org.apache.maven.model.Dependency();
            dep.setGroupId(missDep.getGroupId());
            dep.setArtifactId(missDep.getArtifactId());
            dep.setVersion(missDep.getVersion());
            model.addDependency(dep);
        }
        if (missingDeps.size() > 0) {
            OutputStream os = null;
            try {
                try {
                    os = new BufferedOutputStream(new FileOutputStream(pomFile));
                    MavenPlugin.getMaven().writeModel(model, os);
                    IFile pomIFile = project.getProject().getFile("pom.xml");
                    if (pomIFile != null) {
                        pomIFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (Exception ex) {
                    Activator.getLogger().error((Throwable)ex);
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e) {
                        Activator.getLogger().error((Throwable)e);
                    }
                }
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    Activator.getLogger().error((Throwable)e);
                }
            }
        }
    }
}

