/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.utils;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.editor.RiderDesignEditor;

public class DiagramUtils {
    private static int TEXT_MAX_LENGTH = 20;
    private static String TEXT_FILL_CHARS = "...";

    public static Anchor getAnchor(PictogramElement element) {
        AnchorContainer container;
        EList anchors;
        if (element instanceof AnchorContainer && (anchors = (container = (AnchorContainer)element).getAnchors()) != null && anchors.size() > 0) {
            Anchor answer = (Anchor)anchors.get(0);
            return answer;
        }
        return null;
    }

    public static void setGridVisible(boolean visible) {
        GraphicalViewer graphicalViewer;
        RiderDesignEditor editor = Activator.getDiagramEditor();
        if (editor != null && (graphicalViewer = editor.getGraphicalViewer()) != null && graphicalViewer.getEditPartRegistry() != null) {
            ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)graphicalViewer.getEditPartRegistry().get(LayerManager.ID);
            IFigure gridFigure = rootEditPart.getLayer((Object)"Grid Layer");
            gridFigure.setVisible(visible);
            editor.getDiagramBehavior().refreshContent();
        }
    }

    public static String filterFigureLabel(String originalLabel) {
        String label = originalLabel;
        if (label.length() > TEXT_MAX_LENGTH) {
            label = label.substring(0, TEXT_MAX_LENGTH - TEXT_FILL_CHARS.length());
            label = String.valueOf(label) + TEXT_FILL_CHARS;
        }
        return label;
    }
}

