/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.propertysheet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.fusesource.ide.camel.editor.propertysheet.CamelComponentUtils;
import org.fusesource.ide.camel.model.Endpoint;
import org.fusesource.ide.camel.model.catalog.components.Component;
import org.fusesource.ide.camel.model.catalog.components.UriParameter;
import org.fusesource.ide.camel.model.catalog.components.UriParameterKind;

public class PropertiesUtils {
    public static UriParameter getUriParam(String name, Component c) {
        return PropertiesUtils.getUriParam(name, c.getUriParameters());
    }

    public static UriParameter getUriParam(String name, List<UriParameter> uriParams) {
        for (UriParameter p : uriParams) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static Component getComponentFor(Endpoint selectedEP) {
        int protocolSeparatorIdx;
        if (selectedEP != null && selectedEP.getUri() != null && (protocolSeparatorIdx = selectedEP.getUri().indexOf(":")) != -1) {
            return CamelComponentUtils.getComponentModel(selectedEP.getUri().substring(0, protocolSeparatorIdx));
        }
        return null;
    }

    public static List<UriParameter> getPathProperties(Endpoint selectedEP) {
        Component componentModel;
        int protocolSeparatorIdx;
        ArrayList<UriParameter> result = new ArrayList<UriParameter>();
        if (selectedEP != null && selectedEP.getUri() != null && (protocolSeparatorIdx = selectedEP.getUri().indexOf(":")) != -1 && (componentModel = CamelComponentUtils.getComponentModel(selectedEP.getUri().substring(0, protocolSeparatorIdx))) != null) {
            for (UriParameter p : componentModel.getUriParameters()) {
                if (p.getKind() == null || !p.getKind().equalsIgnoreCase("path")) continue;
                result.add(p);
            }
        }
        return result;
    }

    public static List<UriParameter> getPropertiesFor(Endpoint selectedEP, UriParameterKind kind) {
        Component componentModel;
        int protocolSeparatorIdx;
        ArrayList<UriParameter> result = new ArrayList<UriParameter>();
        if (selectedEP != null && selectedEP.getUri() != null && (protocolSeparatorIdx = selectedEP.getUri().indexOf(":")) != -1 && (componentModel = CamelComponentUtils.getComponentModel(selectedEP.getUri().substring(0, protocolSeparatorIdx))) != null) {
            for (UriParameter p : componentModel.getUriParameters()) {
                if (kind == UriParameterKind.CONSUMER) {
                    if (p.getLabel() == null || !p.getLabel().equalsIgnoreCase("consumer")) continue;
                    result.add(p);
                    continue;
                }
                if (kind == UriParameterKind.PRODUCER) {
                    if (p.getLabel() == null || !p.getLabel().equalsIgnoreCase("producer")) continue;
                    result.add(p);
                    continue;
                }
                if (kind != UriParameterKind.BOTH || p.getLabel() != null) continue;
                result.add(p);
            }
        }
        return result;
    }

    public static String getPropertyFromUri(Endpoint selectedEP, UriParameter p, Component c) {
        if (p.getKind() != null && p.getKind().equalsIgnoreCase("parameter")) {
            int idx = selectedEP.getUri().indexOf(String.valueOf(p.getName()) + "=");
            if (idx != -1) {
                return selectedEP.getUri().substring(idx + (String.valueOf(p.getName()) + "=").length(), selectedEP.getUri().indexOf(38, idx + 1) != -1 ? selectedEP.getUri().indexOf(38, idx + 1) : selectedEP.getUri().length());
            }
            if (p.getDefaultValue() != null && p.getDefaultValue().trim().length() > 0) {
                return p.getDefaultValue();
            }
        } else if (p.getKind() != null && p.getKind().equalsIgnoreCase("path")) {
            String delimiters = PropertiesUtils.getDelimitersAsString(c.getSyntax(), c.getUriParameters());
            String uri = selectedEP.getUri().substring(selectedEP.getUri().indexOf(":") + 1, selectedEP.getUri().indexOf("?") != -1 ? selectedEP.getUri().indexOf("?") : selectedEP.getUri().length());
            if (delimiters.length() < 1) {
                return uri;
            }
            return PropertiesUtils.getPathMap(selectedEP, c).get(p.getName());
        }
        return null;
    }

    private static int getFieldIndex(String delimiters, String syntax, String fieldName) {
        int idx = -1;
        StringTokenizer syntaxTok = new StringTokenizer(syntax, delimiters);
        while (syntaxTok.hasMoreTokens()) {
            ++idx;
            String fName = syntaxTok.nextToken();
            if (fName.equals(fieldName)) break;
        }
        return idx;
    }

    private static String getDelimitersAsString(String syntax, List<UriParameter> params) {
        String syntaxWithoutScheme;
        String delimiterString = syntax;
        delimiterString = syntaxWithoutScheme = delimiterString.substring(delimiterString.indexOf(":") + 1);
        Collections.sort(params, new Comparator<UriParameter>(){

            @Override
            public int compare(UriParameter o1, UriParameter o2) {
                return o2.getName().length() - o1.getName().length();
            }
        });
        for (UriParameter p : params) {
            if (!CamelComponentUtils.isUriPathParameter(p)) continue;
            delimiterString = delimiterString.replace(p.getName(), "");
        }
        return delimiterString;
    }

    private static Map<String, String> getPathMap(Endpoint selectedEP, Component c) {
        HashMap<String, String> retVal = new HashMap<String, String>();
        List<UriParameter> pathParams = PropertiesUtils.getPathProperties(selectedEP);
        String delimiters = PropertiesUtils.getDelimitersAsString(c.getSyntax(), pathParams);
        String uri = selectedEP.getUri().substring(selectedEP.getUri().indexOf(":") + 1, selectedEP.getUri().indexOf("?") != -1 ? selectedEP.getUri().indexOf("?") : selectedEP.getUri().length());
        HashMap<Integer, UriParameter> fieldMapping = new HashMap<Integer, UriParameter>();
        for (UriParameter param : pathParams) {
            int idx = PropertiesUtils.getFieldIndex(delimiters, c.getSyntax().substring(c.getSyntax().indexOf(":") + 1), param.getName());
            fieldMapping.put(idx, param);
        }
        int lastPos = 0;
        int skippedDelimiters = 0;
        int field = 0;
        while (field < delimiters.length() + 1) {
            boolean required;
            UriParameter uriParam = (UriParameter)fieldMapping.get(field);
            boolean bl = required = uriParam.getRequired() != null && uriParam.getRequired().equalsIgnoreCase("true");
            if (skippedDelimiters > 0 && !required) {
                retVal.put(uriParam.getName(), null);
                --skippedDelimiters;
            } else {
                int foundPos = -1;
                int delIdx = field + skippedDelimiters;
                while (delIdx < delimiters.length()) {
                    char delim = delimiters.charAt(delIdx);
                    int pos = uri.indexOf(delim, lastPos);
                    if (pos != -1) {
                        foundPos = pos;
                        break;
                    }
                    ++skippedDelimiters;
                    ++delIdx;
                }
                if (foundPos != -1) {
                    retVal.put(uriParam.getName(), uri.substring(lastPos, foundPos));
                    lastPos = foundPos + 1;
                } else {
                    String v = uri.substring(lastPos);
                    if (delimiters.endsWith("/") && field == delimiters.length()) {
                        v = "/" + v;
                    }
                    String fieldName = null;
                    while (fieldName == null && uriParam != null) {
                        if (field == 0 && (uriParam.getRequired() == null || uriParam.getRequired().equalsIgnoreCase("false"))) {
                            uriParam = (UriParameter)fieldMapping.get(++field);
                            continue;
                        }
                        fieldName = uriParam.getName();
                    }
                    retVal.put(fieldName, v);
                    break;
                }
            }
            ++field;
        }
        return retVal;
    }

    public static Object getTypedPropertyFromUri(Endpoint selectedEP, UriParameter p, Component c) {
        String val = PropertiesUtils.getPropertyFromUri(selectedEP, p, c);
        if (CamelComponentUtils.isBooleanProperty(p)) {
            return Boolean.parseBoolean(val);
        }
        if (CamelComponentUtils.isTextProperty(p)) {
            return val;
        }
        if (CamelComponentUtils.isNumberProperty(p)) {
            return val;
        }
        return null;
    }

    public static void updateURIParams(Endpoint selectedEP, UriParameter p, Object value, Component c, IObservableMap modelMap) {
        if (p.getKind().equalsIgnoreCase("path")) {
            String newUri = "";
            String syntax = c.getSyntax();
            List<UriParameter> pathParams = PropertiesUtils.getPathProperties(selectedEP);
            for (UriParameter pparam : pathParams) {
                String val = "";
                val = p.getName().equals(pparam.getName()) ? value.toString() : modelMap.get((Object)pparam.getName()).toString();
                if (val.trim().length() < 1) {
                    val = pparam.getDefaultValue();
                }
                if (val != null && val.startsWith("/") && !CamelComponentUtils.isFileProperty(pparam)) {
                    val = val.substring(1);
                }
                if (val == null) continue;
                syntax = syntax.replace(pparam.getName(), val);
            }
            newUri = String.valueOf(newUri) + syntax + "?";
            for (UriParameter uriParam : c.getUriParameters()) {
                if (uriParam.getKind().equalsIgnoreCase("path")) continue;
                String pName = uriParam.getName();
                String pValue = PropertiesUtils.getPropertyFromUri(selectedEP, uriParam, c);
                if (pValue == null || pValue.trim().length() < 1 || uriParam.getDefaultValue() != null && uriParam.getDefaultValue().trim().length() > 0 && pValue.equals(uriParam.getDefaultValue())) continue;
                if (!newUri.endsWith("?")) {
                    newUri = String.valueOf(newUri) + "&";
                }
                newUri = String.valueOf(newUri) + String.format("%s=%s", pName, pValue);
            }
            if (newUri.endsWith("?")) {
                newUri = newUri.substring(0, newUri.length() - 1);
            }
            selectedEP.setUri(newUri);
        } else {
            boolean valueDeleted = value == null || value.toString().trim().length() < 1 || p.getDefaultValue() != null && value.toString().equals(p.getDefaultValue());
            String val = PropertiesUtils.getPropertyFromUri(selectedEP, p, c);
            String key = String.format("%s=", p.getName());
            int idx = selectedEP.getUri().indexOf(key);
            if (val != null && idx != -1) {
                boolean firstParam;
                String newUri = "";
                boolean bl = firstParam = idx == -1 || selectedEP.getUri().charAt(idx - 1) == '?';
                String string = valueDeleted ? selectedEP.getUri().substring(0, firstParam ? idx : idx - 1) : (newUri = selectedEP.getUri().substring(0, idx + key.length()));
                if (!valueDeleted) {
                    newUri = String.valueOf(newUri) + value.toString();
                }
                if ((newUri = valueDeleted && firstParam ? String.valueOf(newUri) + selectedEP.getUri().substring(idx + key.length() + val.length()) : String.valueOf(newUri) + selectedEP.getUri().substring(idx + key.length() + val.length())).indexOf("?&") != -1) {
                    newUri = newUri.replace("?&", "?");
                }
                if (newUri.endsWith("?")) {
                    newUri = newUri.substring(0, newUri.indexOf("?"));
                }
                selectedEP.setUri(newUri);
            } else {
                String newUri = selectedEP.getUri();
                if (!valueDeleted) {
                    if (selectedEP.getUri().indexOf(63) == -1) {
                        newUri = String.valueOf(newUri) + '?';
                    }
                    if (selectedEP.getUri().indexOf(61) != -1) {
                        newUri = String.valueOf(newUri) + '&';
                    }
                    newUri = String.valueOf(newUri) + String.format("%s=%s", p.getName(), value.toString());
                }
                selectedEP.setUri(newUri);
            }
        }
    }

    public static String getUsedProtocol(Endpoint selectedEP) {
        return selectedEP.getUri().substring(0, selectedEP.getUri().indexOf(58));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IPackageFragment getPackage(IJavaProject javaProject, IPackageFragmentRoot pkgFragmentRoot) {
        String packName = null;
        IJavaElement[] packages = null;
        try {
            if (pkgFragmentRoot == null) return null;
            if (!pkgFragmentRoot.exists()) return null;
            packages = pkgFragmentRoot.getChildren();
            if (packages.length == 1) {
                packName = javaProject.getElementName();
                IStatus status = PropertiesUtils.validatePackageName(packName, javaProject);
                if (status.getSeverity() != 0) return null;
                return pkgFragmentRoot.getPackageFragment(packName);
            }
            int noOfPackages = 0;
            IPackageFragment thePackage = null;
            IJavaElement[] iJavaElementArray = packages;
            int n = packages.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (noOfPackages != true) return null;
                    packName = thePackage.getElementName();
                    return pkgFragmentRoot.getPackageFragment(packName);
                }
                IJavaElement pack = iJavaElementArray[n2];
                IPackageFragment pkg = (IPackageFragment)pack;
                if (!(pkg.hasSubpackages() && !pkg.hasChildren() || pkg.isDefaultPackage())) {
                    thePackage = pkg;
                    if (++noOfPackages > 1) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IStatus validatePackageName(String text, IJavaProject project) {
        if (project == null || !project.exists()) {
            return JavaConventions.validatePackageName((String)text, (String)"1.3", (String)"1.3");
        }
        return JavaConventionsUtil.validatePackageName((String)text, (IJavaElement)project);
    }
}

