/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.propertysheet;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.fusesource.ide.camel.editor.AbstractNodes;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.editor.NodeSelectionSupport;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;

public abstract class NodeSectionSupport
extends AbstractPropertySection {
    protected AbstractNode node;
    private RouteContainer nodeContainer;
    private WorkbenchPart lastPart;
    private NodeSelectionSupport nodeListener = new NodeSelectionSupport(){

        @Override
        protected void onNodeChanged(AbstractNode node) {
            super.onNodeChanged(node);
            NodeSectionSupport.this.setSelectedNode(node);
        }
    };
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            NodeSectionSupport.this.nodeListener.selectionChanged((IWorkbenchPart)NodeSectionSupport.this.lastPart, event.getSelection());
        }
    };

    public void setInput(IWorkbenchPart part, ISelection selection) {
        WorkbenchPart workbenchPart;
        if (part instanceof WorkbenchPart && this.lastPart != (workbenchPart = (WorkbenchPart)part)) {
            this.lastPart = workbenchPart;
            ISelectionProvider selectionProvider = workbenchPart.getSite().getSelectionProvider();
            try {
                selectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
            }
            catch (Exception exception) {}
            selectionProvider.addSelectionChangedListener(this.selectionChangedListener);
        }
        super.setInput(part, selection);
        AbstractNode newNode = this.getSelectedNode(selection);
        this.setSelectedNode(newNode);
    }

    protected AbstractNode getSelectedNode(ISelection selection) {
        return AbstractNodes.getSelectedNode(selection);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        ISelection selection = null;
        AbstractNode newNode = null;
        if (this.lastPart != null && (newNode = this.getSelectedNode(selection = this.lastPart.getSite().getSelectionProvider().getSelection())) != null) {
            this.setSelectedNode(newNode);
        }
        Activator.getLogger().debug("After " + (Object)((Object)this) + " about to be shown selection " + selection + " node: " + newNode + " last part: " + this.lastPart);
    }

    protected void setSelectedNode(AbstractNode newNode) {
        if (newNode != null) {
            if (newNode instanceof RouteContainer) {
                this.nodeContainer = (RouteContainer)newNode;
            } else {
                RouteContainer parent = newNode.getParent();
                if (parent != null) {
                    this.nodeContainer = parent;
                }
            }
            if (newNode == null) {
                return;
            }
            this.node = newNode;
            this.onNodeChanged(this.node);
        }
    }

    protected abstract void onNodeChanged(AbstractNode var1);

    public AbstractNode getNode() {
        return this.node;
    }

    public RouteContainer getNodeContainer() {
        if (this.nodeContainer == null && this.node != null) {
            this.nodeContainer = this.node.getParent();
        }
        return this.nodeContainer;
    }
}

