/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.propertysheet;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.model.catalog.CamelModelFactory;
import org.fusesource.ide.camel.model.catalog.Dependency;
import org.fusesource.ide.camel.model.catalog.components.Component;
import org.fusesource.ide.camel.model.catalog.components.ComponentProperty;
import org.fusesource.ide.camel.model.catalog.components.UriParameter;
import org.fusesource.ide.commons.util.IOUtils;
import org.fusesource.ide.commons.util.JsonHelper;
import org.fusesource.ide.commons.util.Strings;
import org.jboss.dmr.ModelNode;

public final class CamelComponentUtils {
    private static final String CAMEL_COMPONENT_DESCRIPTOR_FILE_MASK = "META-INF/services/org/apache/camel/descriptors/%s.xml";
    private static HashMap<String, Component> knownComponents = new HashMap();

    public static Component getComponentModel(String protocol) {
        String componentClass = CamelComponentUtils.getComponentClass(protocol);
        if (knownComponents.containsKey(componentClass)) {
            return knownComponents.get(componentClass);
        }
        Component c = CamelComponentUtils.buildModelForComponent(protocol, componentClass);
        if (c != null) {
            knownComponents.put(componentClass, c);
            return CamelComponentUtils.getComponentModel(protocol);
        }
        return null;
    }

    public static boolean isBooleanProperty(UriParameter p) {
        return p.getJavaType().equalsIgnoreCase("boolean") || p.getJavaType().equalsIgnoreCase("java.lang.Boolean");
    }

    public static boolean isTextProperty(UriParameter p) {
        return p.getChoice() == null && (p.getJavaType().equalsIgnoreCase("String") || p.getJavaType().equalsIgnoreCase("java.lang.String") || p.getJavaType().equalsIgnoreCase("java.net.URL") || p.getJavaType().equalsIgnoreCase("java.net.URI") || p.getJavaType().equalsIgnoreCase("Text"));
    }

    public static boolean isNumberProperty(UriParameter p) {
        return p.getChoice() == null && (p.getJavaType().equalsIgnoreCase("int") || p.getJavaType().equalsIgnoreCase("Integer") || p.getJavaType().equalsIgnoreCase("java.lang.Integer") || p.getJavaType().equalsIgnoreCase("long") || p.getJavaType().equalsIgnoreCase("java.lang.Long") || p.getJavaType().equalsIgnoreCase("double") || p.getJavaType().equalsIgnoreCase("java.lang.Double") || p.getJavaType().equalsIgnoreCase("float") || p.getJavaType().equalsIgnoreCase("java.lang.Float") || p.getJavaType().equalsIgnoreCase("Number"));
    }

    public static boolean isChoiceProperty(UriParameter p) {
        return p.getChoice() != null && p.getChoice().trim().length() > 0;
    }

    public static boolean isFileProperty(UriParameter p) {
        return p.getJavaType().equalsIgnoreCase("file") || p.getJavaType().equalsIgnoreCase("java.io.file");
    }

    public static boolean isExpressionProperty(UriParameter p) {
        return p.getJavaType().equalsIgnoreCase("expression") || p.getJavaType().equalsIgnoreCase("org.apache.camel.Expression");
    }

    public static boolean isListProperty(UriParameter p) {
        return p.getJavaType().toLowerCase().startsWith("java.util.list") || p.getJavaType().toLowerCase().startsWith("java.util.collection");
    }

    public static boolean isMapProperty(UriParameter p) {
        return p.getJavaType().toLowerCase().startsWith("java.util.map");
    }

    public static boolean isUriPathParameter(UriParameter p) {
        return p.getKind() != null && p.getKind().equalsIgnoreCase("path");
    }

    public static boolean isUriOptionParameter(UriParameter p) {
        return p.getKind() != null && p.getKind().equalsIgnoreCase("parameter");
    }

    public static boolean isUnsupportedProperty(UriParameter p) {
        return CamelComponentUtils.isListProperty(p) || CamelComponentUtils.isMapProperty(p) || p.getJavaType().toLowerCase().startsWith("java.util.date");
    }

    public static String[] getChoices(UriParameter p) {
        String[] choices = p.getChoice().split(",");
        ArrayList<String> res = new ArrayList<String>();
        res.add(" ");
        String[] stringArray = choices;
        int n = choices.length;
        int n2 = 0;
        while (n2 < n) {
            String choice = stringArray[n2];
            res.add(choice);
            ++n2;
        }
        return res.toArray(new String[res.size()]);
    }

    protected static String getComponentClass(String scheme) {
        String compClass = null;
        ArrayList components = CamelModelFactory.getModelForVersion((String)Activator.getDefault().getCamelVersion()).getComponentModel().getSupportedComponents();
        for (Component c : components) {
            if (!c.supportsScheme(scheme)) continue;
            compClass = c.getClazz();
            break;
        }
        if (compClass == null) {
            try {
                IMavenProjectFacade m2facade = MavenPlugin.getMavenProjectRegistry().create(Activator.getDiagramEditor().getCamelContextFile().getProject(), (IProgressMonitor)new NullProgressMonitor());
                Set deps = m2facade.getMavenProject((IProgressMonitor)new NullProgressMonitor()).getArtifacts();
                ZipFile zf = null;
                ZipEntry ze = null;
                for (Artifact dep : deps) {
                    zf = new ZipFile(dep.getFile());
                    ze = zf.getEntry(String.format("META-INF/services/org/apache/camel/component/%s", scheme));
                    if (ze != null) break;
                    ze = null;
                    zf = null;
                }
                if (ze != null) {
                    Properties p = new Properties();
                    p.load(zf.getInputStream(ze));
                    compClass = p.getProperty("class");
                }
            }
            catch (Exception ex) {
                Activator.getLogger().error((Throwable)ex);
                compClass = null;
            }
        }
        return compClass;
    }

    protected static String getComponentJSon(String scheme) {
        String json = null;
        try {
            IMavenProjectFacade m2facade = MavenPlugin.getMavenProjectRegistry().create(Activator.getDiagramEditor().getCamelContextFile().getProject(), (IProgressMonitor)new NullProgressMonitor());
            Set deps = m2facade.getMavenProject((IProgressMonitor)new NullProgressMonitor()).getArtifacts();
            ZipFile zf = null;
            ZipEntry ze = null;
            for (Artifact dep : deps) {
                zf = new ZipFile(dep.getFile());
                ze = zf.getEntry(String.format("META-INF/services/org/apache/camel/component/%s", scheme));
                if (ze != null) break;
                ze = null;
                zf = null;
            }
            if (ze != null) {
                Properties p = new Properties();
                p.load(zf.getInputStream(ze));
                String compClass = p.getProperty("class");
                String packageName = compClass.substring(0, compClass.lastIndexOf("."));
                String folder = packageName.replaceAll("\\.", "/");
                ze = zf.getEntry(String.format("%s/%s.json", folder, scheme));
                if (ze != null) {
                    json = IOUtils.loadText((InputStream)zf.getInputStream(ze), null);
                }
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            json = null;
        }
        return json;
    }

    protected static Component buildModelForComponent(String scheme, String clazz) {
        Component resModel = null;
        resModel = CamelModelFactory.getModelForVersion((String)Activator.getDefault().getCamelVersion()).getComponentModel().getComponentForScheme(scheme);
        if (resModel == null) {
            resModel = CamelComponentUtils.buildModelFromJSON(scheme, CamelComponentUtils.getComponentJSon(scheme), clazz);
        }
        return resModel;
    }

    protected static Component buildModelFromJSON(String scheme, String oJSONBlob, String clazz) {
        Component resModel = null;
        try {
            if (oJSONBlob != null) {
                resModel = CamelComponentUtils.buildModelFromJSonBlob(oJSONBlob, clazz);
                resModel.setScheme(scheme);
                CamelComponentUtils.saveModel(resModel);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Activator.getLogger().error((Throwable)ex);
        }
        return resModel;
    }

    private static void saveModel(Component component) {
        knownComponents.put(component.getClazz(), component);
    }

    public static URLClassLoader getProjectClassLoader() {
        try {
            IProject project = Activator.getDiagramEditor().getCamelContextFile().getProject();
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            IPackageFragmentRoot[] pfroots = javaProject.getAllPackageFragmentRoots();
            ArrayList<URL> urls = new ArrayList<URL>();
            IPackageFragmentRoot[] iPackageFragmentRootArray = pfroots;
            int n = pfroots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                URL rUrl = root.getPath().toFile().toURI().toURL();
                urls.add(rUrl);
                ++n2;
            }
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), CamelComponentUtils.class.getClassLoader());
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            return null;
        }
    }

    protected static Component buildModelFromJSonBlob(String json, String clazz) {
        Component resModel = new Component();
        resModel.setClazz(clazz);
        try {
            ModelNode model = JsonHelper.getModelNode((String)json);
            ModelNode componentNode = model.get("component");
            Map props = JsonHelper.getAsMap((ModelNode)componentNode);
            Iterator it = props.keySet().iterator();
            String grpId = null;
            String artId = null;
            String ver = null;
            while (it.hasNext()) {
                String propName = (String)it.next();
                ModelNode valueNode = componentNode.get(propName);
                if (propName.equals("kind")) {
                    resModel.setKind(valueNode.asString());
                    continue;
                }
                if (propName.equals("scheme")) {
                    resModel.setScheme(valueNode.asString());
                    continue;
                }
                if (propName.equals("syntax")) {
                    resModel.setSyntax(valueNode.asString());
                    continue;
                }
                if (propName.equals("title")) {
                    resModel.setTitle(valueNode.asString());
                    continue;
                }
                if (propName.equals("description")) {
                    resModel.setDescription(valueNode.asString());
                    continue;
                }
                if (propName.equals("label")) {
                    ArrayList<String> al = new ArrayList<String>();
                    al.addAll(Arrays.asList(valueNode.asString().split(",")));
                    resModel.setTags(al);
                    continue;
                }
                if (propName.equals("consumerOnly")) {
                    resModel.setConsumerOnly(valueNode.asString());
                    continue;
                }
                if (propName.equals("producerOnly")) {
                    resModel.setProducerOnly(valueNode.asString());
                    continue;
                }
                if (propName.equals("javaType")) {
                    resModel.setClazz(valueNode.asString());
                    continue;
                }
                if (propName.equals("groupId")) {
                    grpId = valueNode.asString();
                    continue;
                }
                if (propName.equals("artifactId")) {
                    artId = valueNode.asString();
                    continue;
                }
                if (!propName.equals("version")) continue;
                ver = valueNode.asString();
            }
            if (!(Strings.isBlank(grpId) || Strings.isBlank(artId) || Strings.isBlank(ver))) {
                ArrayList<Dependency> depList = new ArrayList<Dependency>();
                Dependency dep = new Dependency();
                dep.setGroupId(grpId);
                dep.setArtifactId(artId);
                dep.setVersion(ver);
                depList.add(dep);
                resModel.setDependencies(depList);
            }
            ArrayList<ComponentProperty> cProps = new ArrayList<ComponentProperty>();
            ModelNode componentPropertiesNode = model.get("componentProperties");
            Map cprops = JsonHelper.getAsMap((ModelNode)componentPropertiesNode);
            it = cprops.keySet().iterator();
            while (it.hasNext()) {
                ComponentProperty cp = new ComponentProperty();
                String propName = (String)it.next();
                ModelNode valueNode = componentNode.get(propName);
                if (propName.equals("defaultValue")) {
                    cp.setDefaultValue(valueNode.asString());
                } else if (propName.equals("deprecated")) {
                    cp.setDeprecated(valueNode.asString());
                } else if (propName.equals("description")) {
                    cp.setDescription(valueNode.asString());
                } else if (propName.equals("javaType")) {
                    cp.setJavaType(valueNode.asString());
                } else if (propName.equals("kind")) {
                    cp.setKind(valueNode.asString());
                } else if (propName.equals("name")) {
                    cp.setName(valueNode.asString());
                } else if (propName.equals("type")) {
                    cp.setType(valueNode.asString());
                }
                cProps.add(cp);
            }
            resModel.setComponentProperties(cProps);
            ModelNode propsNode = model.get("properties");
            props = JsonHelper.getAsMap((ModelNode)propsNode);
            it = props.keySet().iterator();
            ArrayList<UriParameter> uriParams = new ArrayList<UriParameter>();
            while (it.hasNext()) {
                String propName = (String)it.next();
                ModelNode valueNode = propsNode.get(propName);
                UriParameter param = new UriParameter();
                param.setName(propName);
                if (valueNode.hasDefined("choice")) {
                    param.setChoice(valueNode.get("choice").asString());
                }
                if (valueNode.hasDefined("defaultValue")) {
                    param.setDefaultValue(valueNode.get("defaultValue").asString());
                }
                if (valueNode.hasDefined("deprecated")) {
                    param.setDeprecated(valueNode.get("deprecated").asString());
                }
                if (valueNode.hasDefined("description")) {
                    param.setDescription(valueNode.get("description").asString());
                }
                if (valueNode.hasDefined("javaType")) {
                    param.setJavaType(valueNode.get("javaType").asString());
                }
                if (valueNode.hasDefined("kind")) {
                    param.setKind(valueNode.get("kind").asString());
                }
                if (valueNode.hasDefined("label")) {
                    param.setLabel(valueNode.get("label").asString());
                }
                if (valueNode.hasDefined("name")) {
                    param.setName(valueNode.get("name").asString());
                }
                if (valueNode.hasDefined("required")) {
                    param.setRequired(valueNode.get("required").asString());
                }
                if (valueNode.hasDefined("type")) {
                    param.setType(valueNode.get("type").asString());
                }
                uriParams.add(param);
            }
            resModel.setUriParameters(uriParams);
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
            resModel = null;
        }
        return resModel;
    }
}

