/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.editor;

import java.util.ArrayList;
import org.apache.camel.model.DataFormatDefinition;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.fusesource.ide.camel.editor.Activator;
import org.fusesource.ide.camel.editor.editor.RiderEditor;
import org.fusesource.ide.camel.model.Endpoint;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.commons.camel.tools.BeanDef;
import org.fusesource.ide.commons.camel.tools.Strings;
import org.fusesource.ide.commons.ui.Selections;

public class GlobalConfigEditor
extends EditorPart {
    private RiderEditor parentEditor;
    private Composite parent;
    private TreeViewer treeViewer;
    private Button btnAdd;
    private Button btnModify;
    private Button btnDelete;

    public GlobalConfigEditor(RiderEditor parentEditor) {
        this.parentEditor = parentEditor;
    }

    public void doSave(IProgressMonitor arg0) {
        this.parentEditor.doSave(arg0);
    }

    public void doSaveAs() {
        this.parentEditor.doSaveAs();
    }

    public void init(IEditorSite editorSite, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)editorSite);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite p) {
        this.parent = new Composite(p, 0x800000);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        this.parent.setLayout((Layout)gl);
        this.treeViewer = new TreeViewer(this.parent, 2820);
        this.treeViewer.setContentProvider((IContentProvider)new GlobalConfigContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new GlobalConfigLabelProvider());
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 10));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selObj = Selections.getFirstSelection((ISelection)event.getSelection());
                if (selObj != null) {
                    GlobalConfigEditor.this.btnModify.setEnabled(GlobalConfigEditor.this.supportsEdit(selObj));
                    GlobalConfigEditor.this.btnDelete.setEnabled(GlobalConfigEditor.this.supportsDelete(selObj));
                } else {
                    GlobalConfigEditor.this.btnModify.setEnabled(false);
                    GlobalConfigEditor.this.btnDelete.setEnabled(false);
                }
            }
        });
        this.btnAdd = new Button(this.parent, 2056);
        this.btnAdd.setText("Add");
        GridData gd = new GridData(4, 1, false, false, 1, 1);
        gd.minimumWidth = 120;
        gd.widthHint = 120;
        this.btnAdd.setLayoutData((Object)gd);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalConfigEditor.this.createNewEntry();
            }
        });
        this.btnModify = new Button(this.parent, 2056);
        this.btnModify.setText("Edit");
        this.btnModify.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        this.btnModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalConfigEditor.this.modifyEntry();
            }
        });
        this.btnDelete = new Button(this.parent, 2056);
        this.btnDelete.setText("Remove");
        this.btnDelete.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalConfigEditor.this.deleteEntries();
            }
        });
        this.treeViewer.setInput((Object)this.parentEditor.getModel());
        this.treeViewer.setSelection(this.treeViewer.getSelection());
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void reload() {
        this.treeViewer.setInput((Object)this.parentEditor.getModel());
        this.treeViewer.refresh();
    }

    private void createNewEntry() {
        System.err.println("TODO!");
    }

    private void modifyEntry() {
        System.err.println("TODO!");
    }

    private void deleteEntries() {
        if (!this.treeViewer.getSelection().isEmpty()) {
            IStructuredSelection sel = (IStructuredSelection)this.treeViewer.getSelection();
            for (Object selObj : sel.toList()) {
                if (!(selObj instanceof BeanDef)) {
                    if (selObj instanceof Endpoint) {
                        String id = ((Endpoint)selObj).getId();
                        this.parentEditor.getModel().removeEndpoint(id);
                    } else {
                        if (!(selObj instanceof DataFormatDefinition)) continue;
                        this.parentEditor.getModel().removeDataFormat(((DataFormatDefinition)selObj).getId());
                    }
                }
                this.parentEditor.markDirty();
            }
            this.reload();
        }
    }

    private boolean isSupportedObjectType(Object element) {
        return element instanceof BeanDef || element instanceof Endpoint || element instanceof DataFormatDefinition;
    }

    private boolean supportsEdit(Object element) {
        return this.isSupportedObjectType(element) && !(element instanceof BeanDef);
    }

    private boolean supportsDelete(Object element) {
        return this.isSupportedObjectType(element) && !(element instanceof BeanDef);
    }

    class GlobalConfigContentProvider
    implements ITreeContentProvider {
        GlobalConfigContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parent) {
            return this.getElements(parent);
        }

        public Object[] getElements(Object parent) {
            ArrayList<Object> childElements = new ArrayList<Object>();
            if (parent instanceof RouteContainer) {
                RouteContainer rc = (RouteContainer)parent;
                childElements.addAll(rc.getModel().beanMap().values());
                for (String epId : rc.getModel().endpointUris().keySet()) {
                    String uri = (String)rc.getCamelContextEndpointUris().get(epId);
                    Endpoint ep = new Endpoint(uri);
                    ep.setId(epId);
                    childElements.add(ep);
                }
                if (rc.getModel().getContextElement().getDataFormats() != null && rc.getModel().getContextElement().getDataFormats().getDataFormats() != null) {
                    childElements.addAll(rc.getModel().getContextElement().getDataFormats().getDataFormats());
                }
            }
            return childElements.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    class GlobalConfigLabelProvider
    extends StyledCellLabelProvider {
        GlobalConfigLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString text = new StyledString();
            if (element instanceof BeanDef) {
                BeanDef bean = (BeanDef)element;
                text.append(bean.getId());
                cell.setImage(this.getIconForElement(bean));
                text.append(" (" + Strings.capitalize((String)bean.getBeanType()) + ") ", StyledString.COUNTER_STYLER);
                cell.setText(text.toString());
                cell.setStyleRanges(text.getStyleRanges());
            } else if (element instanceof Endpoint) {
                Endpoint value = (Endpoint)element;
                text.append(value.getId());
                cell.setImage(this.getIconForElement(value));
                text.append(" (Endpoint)", StyledString.COUNTER_STYLER);
                cell.setText(text.toString());
                cell.setStyleRanges(text.getStyleRanges());
            } else if (element instanceof DataFormatDefinition) {
                DataFormatDefinition value = (DataFormatDefinition)element;
                text.append(value.getId());
                cell.setImage(this.getIconForElement(value));
                text.append(" (Eip)", StyledString.COUNTER_STYLER);
                cell.setText(text.toString());
                cell.setStyleRanges(text.getStyleRanges());
            }
            super.update(cell);
        }

        private Image getIconForElement(Object element) {
            if (element instanceof BeanDef) {
                return Activator.getDefault().getImage("beandef.gif");
            }
            if (element instanceof DataFormatDefinition) {
                return Activator.getDefault().getImage("dataformat.gif");
            }
            if (element instanceof Endpoint) {
                return Activator.getDefault().getImage("endpointdef.png");
            }
            return null;
        }
    }
}

