/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.server.IConfigurationPropertyProvider;

public class BaseConfigPropertyProvider
implements IConfigurationPropertyProvider {
    private Properties configProps = new Properties();
    private File propertyFile = null;

    public BaseConfigPropertyProvider(File propertyFile) {
        this.propertyFile = propertyFile;
        this.loadPropertiesFromFile();
    }

    @Override
    public String getConfigurationProperty(String propertyName) {
        return this.getConfigurationProperty(propertyName, null);
    }

    @Override
    public String getConfigurationProperty(String propertyName, String defaultValue) {
        return this.configProps.getProperty(propertyName, defaultValue);
    }

    public Enumeration<Object> getPropertyKeys() {
        return this.configProps.keys();
    }

    private void loadPropertiesFromFile() {
        block14: {
            this.configProps.clear();
            BufferedInputStream bis = null;
            try {
                try {
                    bis = new BufferedInputStream(new FileInputStream(this.propertyFile));
                    this.configProps.load(bis);
                }
                catch (IOException ex) {
                    Activator.getLogger().error((Throwable)ex);
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void reload() {
        this.loadPropertiesFromFile();
    }
}

