/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metadata.runtime.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.container.EObjectFinder;
import org.teiid.designer.core.index.EntryResult;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.metadata.runtime.AnnotationRecord;
import org.teiid.designer.metadata.runtime.ColumnRecord;
import org.teiid.designer.metadata.runtime.ColumnSetRecord;
import org.teiid.designer.metadata.runtime.DatatypeRecord;
import org.teiid.designer.metadata.runtime.FileRecord;
import org.teiid.designer.metadata.runtime.ForeignKeyRecord;
import org.teiid.designer.metadata.runtime.MetadataRecord;
import org.teiid.designer.metadata.runtime.ModelRecord;
import org.teiid.designer.metadata.runtime.ProcedureParameterRecord;
import org.teiid.designer.metadata.runtime.ProcedureRecord;
import org.teiid.designer.metadata.runtime.PropertyRecord;
import org.teiid.designer.metadata.runtime.TableRecord;
import org.teiid.designer.metadata.runtime.TransformationRecord;
import org.teiid.designer.metadata.runtime.UniqueKeyRecord;
import org.teiid.designer.metadata.runtime.VdbRecord;
import org.teiid.designer.metadata.runtime.impl.AbstractMetadataRecord;
import org.teiid.designer.metadata.runtime.impl.AnnotationRecordImpl;
import org.teiid.designer.metadata.runtime.impl.ColumnRecordImpl;
import org.teiid.designer.metadata.runtime.impl.ColumnSetRecordImpl;
import org.teiid.designer.metadata.runtime.impl.DatatypeRecordImpl;
import org.teiid.designer.metadata.runtime.impl.FileRecordImpl;
import org.teiid.designer.metadata.runtime.impl.ForeignKeyRecordImpl;
import org.teiid.designer.metadata.runtime.impl.ModelRecordImpl;
import org.teiid.designer.metadata.runtime.impl.ProcedureParameterRecordImpl;
import org.teiid.designer.metadata.runtime.impl.ProcedureRecordImpl;
import org.teiid.designer.metadata.runtime.impl.PropertyRecordImpl;
import org.teiid.designer.metadata.runtime.impl.TableRecordImpl;
import org.teiid.designer.metadata.runtime.impl.TransformationRecordImpl;
import org.teiid.designer.metadata.runtime.impl.UniqueKeyRecordImpl;
import org.teiid.designer.metadata.runtime.impl.VdbRecordImpl;

public class RecordFactory {
    public static final int INDEX_RECORD_BLOCK_SIZE = 8160;
    public static final int NONVERSIONED_RECORD_INDEX_VERSION = 0;
    public static final int DELIMITER_INDEX_VERSION = 1;
    public static final int TABLE_MATERIALIZATION_INDEX_VERSION = 2;
    public static final int COLUMN_NATIVE_TYPE_INDEX_VERSION = 3;
    public static final int COLUMN_INPUT_PARAMETER_FLAG_INDEX_VERSION = 4;
    public static final int ANNOTATION_TAGS_INDEX_VERSION = 5;
    public static final int TRANSFORMATION_UUID_INDEX_VERSION = 6;
    public static final int COLUMN_NULL_DISTINCT_INDEX_VERSION = 7;
    public static final int PRIMITIVE_TYPE_ID_INDEX_VERSION = 8;
    public static final int PROCEDURE_UPDATE_COUNT_VERSION = 9;
    public static final int TABLE_CARDINALITY_MINUS_ONE_VERSION = 10;
    public static final int CURRENT_INDEX_VERSION = 10;

    public static Collection getMetadataRecord(IEntryResult[] queryResult, EObjectFinder container) {
        ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(queryResult.length);
        int i = 0;
        while (i < queryResult.length) {
            MetadataRecord record = RecordFactory.getMetadataRecord(queryResult[i], container);
            if (record != null) {
                records.add(record);
            }
            ++i;
        }
        return records;
    }

    public static Collection getMetadataRecord(IEntryResult[] queryResult) {
        ArrayList<MetadataRecord> records = new ArrayList<MetadataRecord>(queryResult.length);
        int i = 0;
        while (i < queryResult.length) {
            MetadataRecord record = RecordFactory.getMetadataRecord(queryResult[i]);
            if (record != null) {
                records.add(record);
            }
            ++i;
        }
        return records;
    }

    private static MetadataRecord getMetadataRecord(char[] record) {
        if (record == null || record.length == 0) {
            return null;
        }
        switch (record[0]) {
            case 'A': {
                return RecordFactory.createModelRecord(record);
            }
            case 'B': {
                return RecordFactory.createTableRecord(record);
            }
            case 'D': {
                return null;
            }
            case 'E': {
                return RecordFactory.createProcedureRecord(record);
            }
            case 'F': {
                return RecordFactory.createProcedureParameterRecord(record);
            }
            case 'G': {
                return RecordFactory.createColumnRecord(record);
            }
            case 'C': 
            case 'H': 
            case 'L': {
                return RecordFactory.createColumnSetRecord(record);
            }
            case 'I': 
            case 'K': {
                return RecordFactory.createUniqueKeyRecord(record);
            }
            case 'J': {
                return RecordFactory.createForeignKeyRecord(record);
            }
            case 'M': {
                return RecordFactory.createDatatypeRecord(record);
            }
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': {
                return RecordFactory.createTransformationRecord(record);
            }
            case 'V': {
                return RecordFactory.createVdbRecord(record);
            }
            case 'W': {
                return RecordFactory.createAnnotationRecord(record);
            }
            case 'X': {
                return RecordFactory.createPropertyRecord(record);
            }
            case 'Z': {
                return RecordFactory.createFileRecord(record);
            }
        }
        throw new IllegalArgumentException("Invalid record type for creating MetadataRecord " + record[0]);
    }

    public static MetadataRecord getMetadataRecord(IEntryResult queryResult) {
        return RecordFactory.getMetadataRecord(queryResult, null);
    }

    public static MetadataRecord getMetadataRecord(IEntryResult queryResult, EObjectFinder container) {
        MetadataRecord record = RecordFactory.getMetadataRecord(queryResult.getWord());
        if (record instanceof AbstractMetadataRecord) {
            ((AbstractMetadataRecord)record).setEObjectFinder(container);
        }
        return record;
    }

    public static IEntryResult joinEntryResults(IEntryResult result, IEntryResult[] continuationResults, int blockSize) {
        CoreArgCheck.isNotNull((Object)result);
        char[] baseResult = result.getWord();
        if (baseResult.length < blockSize || baseResult[blockSize - 1] != '&') {
            return result;
        }
        String baseStr = new String(baseResult);
        String objectID = RecordFactory.extractUUIDString(result);
        StringBuffer sb = new StringBuffer();
        sb.append(baseStr.substring(0, blockSize - 1));
        IEntryResult[] sortedResults = RecordFactory.sortContinuationResults(objectID, continuationResults);
        int i = 0;
        while (i < sortedResults.length) {
            int beginIndex;
            char[] continuation = sortedResults[i].getWord();
            int segNumber = RecordFactory.getContinuationSegmentNumber(objectID, sortedResults[i]);
            int j = beginIndex = objectID.length() + Integer.toString(segNumber).length() + 5;
            while (j < continuation.length) {
                if (j < blockSize - 1) {
                    sb.append(continuation[j]);
                }
                ++j;
            }
            ++i;
        }
        return new EntryResult(sb.toString().toCharArray(), result.getFileReferences());
    }

    private static IEntryResult[] sortContinuationResults(String objectID, IEntryResult[] continuationResults) {
        if (continuationResults.length < 10) {
            return continuationResults;
        }
        IEntryResult[] sortedResults = new IEntryResult[continuationResults.length];
        int i = 0;
        while (i < continuationResults.length) {
            int segNumber = RecordFactory.getContinuationSegmentNumber(objectID, continuationResults[i]);
            sortedResults[segNumber - 1] = continuationResults[i];
            ++i;
        }
        return sortedResults;
    }

    public static int getContinuationSegmentNumber(String objectID, IEntryResult continuationResult) {
        char[] record = continuationResult.getWord();
        int segNumber = -1;
        int index = objectID.length() + 4;
        if (record[index + 1] == '\u00a0') {
            segNumber = Character.getNumericValue(record[index]);
        } else if (record[index + 2] == '\u00a0') {
            char[] temp = new char[]{record[index], record[index + 1]};
            String segCount = new String(temp);
            segNumber = Integer.parseInt(segCount);
        } else if (record[index + 3] == '\u00a0') {
            char[] temp = new char[]{record[index], record[index + 1], record[index + 2]};
            String segCount = new String(temp);
            segNumber = Integer.parseInt(segCount);
        }
        return segNumber;
    }

    public static String extractUUIDString(IEntryResult result) {
        CoreArgCheck.isNotNull((Object)result);
        char[] word = result.getWord();
        String baseStr = new String(word);
        int beginIndex = baseStr.indexOf("mmuuid");
        int endIndex = word.length;
        CoreArgCheck.isNonNegative((int)beginIndex);
        int i = beginIndex;
        while (i < word.length) {
            if (word[i] == '\u00a0') {
                endIndex = i;
                break;
            }
            ++i;
        }
        CoreArgCheck.isTrue((beginIndex < endIndex ? 1 : 0) != 0, (String)"begin index should be less than end index");
        return baseStr.substring(beginIndex, endIndex);
    }

    public static ModelRecord createModelRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ModelRecordImpl model = new ModelRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        model.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RecordFactory.setRecordHeaderValues(model, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        model.setMaxSetSize(Integer.parseInt((String)tokens.get(tokenIndex++)));
        model.setModelType(Integer.parseInt((String)tokens.get(tokenIndex++)));
        model.setPrimaryMetamodelUri(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        char[] supportFlags = ((String)tokens.get(tokenIndex++)).toCharArray();
        model.setVisible(RecordFactory.getBooleanValue(supportFlags[0]));
        model.setSupportsDistinct(RecordFactory.getBooleanValue(supportFlags[1]));
        model.setSupportsJoin(RecordFactory.getBooleanValue(supportFlags[2]));
        model.setSupportsOrderBy(RecordFactory.getBooleanValue(supportFlags[3]));
        model.setSupportsOuterJoin(RecordFactory.getBooleanValue(supportFlags[4]));
        model.setSupportsWhereAll(RecordFactory.getBooleanValue(supportFlags[5]));
        RecordFactory.setRecordFooterValues(model, tokens, tokenIndex);
        return model;
    }

    public static VdbRecord createVdbRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        VdbRecordImpl vdb = new VdbRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        vdb.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RecordFactory.setRecordHeaderValues(vdb, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        vdb.setVersion(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        vdb.setIdentifier(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        vdb.setProducerName(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        vdb.setProducerVersion(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        vdb.setProvider(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        vdb.setTimeLastChanged(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        vdb.setTimeLastProduced(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        List uuids = RecordFactory.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        vdb.setModelIDs(uuids);
        vdb.setDescription(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        RecordFactory.setRecordFooterValues(vdb, tokens, tokenIndex);
        return vdb;
    }

    public static TransformationRecord createTransformationRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        TransformationRecordImpl transform = new TransformationRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        transform.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        char recordType = ((String)tokens.get(tokenIndex++)).charAt(0);
        transform.setTransformationType(RecordFactory.getObjectValue(transform.getTransformTypeForRecordType(recordType)));
        transform.setFullName(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        transform.setTransformedObjectID(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        if (RecordFactory.includeTransformationUUID(indexVersion)) {
            transform.setUUID(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        }
        transform.setTransformation(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        List bindings = RecordFactory.getStrings((String)tokens.get(tokenIndex++), indexVersion);
        transform.setBindings(bindings);
        List schemaPaths = RecordFactory.getStrings((String)tokens.get(tokenIndex++), indexVersion);
        transform.setSchemaPaths(schemaPaths);
        RecordFactory.setRecordFooterValues(transform, tokens, tokenIndex);
        return transform;
    }

    public static TableRecord createTableRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        TableRecordImpl table = new TableRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        table.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RecordFactory.setRecordHeaderValues(table, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        table.setCardinality(Integer.parseInt((String)tokens.get(tokenIndex++)));
        table.setTableType(Integer.parseInt((String)tokens.get(tokenIndex++)));
        char[] supportFlags = ((String)tokens.get(tokenIndex++)).toCharArray();
        table.setVirtual(RecordFactory.getBooleanValue(supportFlags[0]));
        table.setSystem(RecordFactory.getBooleanValue(supportFlags[1]));
        table.setSupportsUpdate(RecordFactory.getBooleanValue(supportFlags[2]));
        if (RecordFactory.includeMaterializationFlag(indexVersion)) {
            table.setMaterialized(RecordFactory.getBooleanValue(supportFlags[3]));
        }
        List uuids = RecordFactory.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        table.setColumnIDs(uuids);
        table.setPrimaryKeyID(tokens.get(tokenIndex++));
        uuids = RecordFactory.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        table.setForeignKeyIDs(uuids);
        uuids = RecordFactory.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        table.setIndexIDs(uuids);
        uuids = RecordFactory.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        table.setUniqueKeyIDs(uuids);
        uuids = RecordFactory.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        table.setAccessPatternIDs(uuids);
        if (RecordFactory.includeMaterializationFlag(indexVersion)) {
            table.setMaterializedTableID(tokens.get(tokenIndex++));
            table.setMaterializedStageTableID(tokens.get(tokenIndex++));
        }
        if (table.getTableType() == TableRecord.Type.TemporaryTable.ordinal()) {
            table.setTempTable(true);
        }
        RecordFactory.setRecordFooterValues(table, tokens, tokenIndex);
        return table;
    }

    public static ColumnRecord createColumnRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ColumnRecordImpl column = new ColumnRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        column.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RecordFactory.setRecordHeaderValues(column, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        char[] supportFlags = ((String)tokens.get(tokenIndex++)).toCharArray();
        column.setSelectable(RecordFactory.getBooleanValue(supportFlags[0]));
        column.setUpdatable(RecordFactory.getBooleanValue(supportFlags[1]));
        column.setAutoIncrementable(RecordFactory.getBooleanValue(supportFlags[2]));
        column.setCaseSensitive(RecordFactory.getBooleanValue(supportFlags[3]));
        column.setSigned(RecordFactory.getBooleanValue(supportFlags[4]));
        column.setCurrency(RecordFactory.getBooleanValue(supportFlags[5]));
        column.setFixedLength(RecordFactory.getBooleanValue(supportFlags[6]));
        if (RecordFactory.includeInputParameterFlag(indexVersion)) {
            column.setTransformationInputParameter(RecordFactory.getBooleanValue(supportFlags[7]));
        }
        column.setNullType(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setSearchType(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setScale(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setPrecision(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setPosition(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setCharOctetLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        column.setRadix(Integer.parseInt((String)tokens.get(tokenIndex++)));
        if (RecordFactory.includeColumnNullDistinctValues(indexVersion)) {
            column.setDistinctValues(Integer.parseInt((String)tokens.get(tokenIndex++)));
            column.setNullValues(Integer.parseInt((String)tokens.get(tokenIndex++)));
        }
        column.setMinValue(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        column.setMaxValue(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        column.setFormat(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        column.setRuntimeType(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        if (RecordFactory.includeColumnNativeType(indexVersion)) {
            column.setNativeType(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        }
        column.setDatatypeUUID(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        column.setDefaultValue(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        RecordFactory.setRecordFooterValues(column, tokens, tokenIndex);
        return column;
    }

    public static ColumnSetRecord createColumnSetRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ColumnSetRecordImpl columnSet = new ColumnSetRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        columnSet.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RecordFactory.setRecordHeaderValues(columnSet, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        List uuids = RecordFactory.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        columnSet.setColumnIDs(uuids);
        RecordFactory.setRecordFooterValues(columnSet, tokens, tokenIndex);
        return columnSet;
    }

    public static ForeignKeyRecord createForeignKeyRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ForeignKeyRecordImpl fkRecord = new ForeignKeyRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        fkRecord.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RecordFactory.setRecordHeaderValues(fkRecord, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        List uuids = RecordFactory.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        fkRecord.setColumnIDs(uuids);
        fkRecord.setUniqueKeyID(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        RecordFactory.setRecordFooterValues(fkRecord, tokens, tokenIndex);
        return fkRecord;
    }

    public static UniqueKeyRecord createUniqueKeyRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        UniqueKeyRecordImpl ukRecord = new UniqueKeyRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        ukRecord.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RecordFactory.setRecordHeaderValues(ukRecord, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        List columnUUIDs = RecordFactory.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        ukRecord.setColumnIDs(columnUUIDs);
        List fkUUIDs = RecordFactory.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        ukRecord.setForeignKeyIDs(fkUUIDs);
        RecordFactory.setRecordFooterValues(ukRecord, tokens, tokenIndex);
        return ukRecord;
    }

    public static DatatypeRecord createDatatypeRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        DatatypeRecordImpl dt = new DatatypeRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        dt.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        dt.setRecordType(((String)tokens.get(tokenIndex++)).toCharArray()[0]);
        dt.setDatatypeID(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setBasetypeID(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setFullName((String)tokens.get(tokenIndex++));
        dt.setUUID(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setNameInSource(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setVarietyType(Short.parseShort((String)tokens.get(tokenIndex++)));
        List props = RecordFactory.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        dt.setVarietyProps(props);
        dt.setRuntimeTypeName(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setJavaClassName(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        dt.setType(Short.parseShort((String)tokens.get(tokenIndex++)));
        dt.setSearchType(Short.parseShort((String)tokens.get(tokenIndex++)));
        dt.setNullType(Short.parseShort((String)tokens.get(tokenIndex++)));
        char[] booleanValues = ((String)tokens.get(tokenIndex++)).toCharArray();
        dt.setSigned(RecordFactory.getBooleanValue(booleanValues[0]));
        dt.setAutoIncrement(RecordFactory.getBooleanValue(booleanValues[1]));
        dt.setCaseSensitive(RecordFactory.getBooleanValue(booleanValues[2]));
        dt.setLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        dt.setPrecisionLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        dt.setScale(Integer.parseInt((String)tokens.get(tokenIndex++)));
        dt.setRadix(Integer.parseInt((String)tokens.get(tokenIndex++)));
        if (RecordFactory.includePrimitiveTypeIdValue(indexVersion)) {
            dt.setPrimitiveTypeID(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        }
        RecordFactory.setRecordFooterValues(dt, tokens, tokenIndex);
        return dt;
    }

    public static ProcedureRecord createProcedureRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ProcedureRecordImpl procRd = new ProcedureRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        procRd.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RecordFactory.setRecordHeaderValues(procRd, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        char[] booleanValues = ((String)tokens.get(tokenIndex++)).toCharArray();
        procRd.setFunction(RecordFactory.getBooleanValue(booleanValues[0]));
        procRd.setVirtual(RecordFactory.getBooleanValue(booleanValues[1]));
        List uuids = RecordFactory.getIDs((String)tokens.get(tokenIndex++), indexVersion);
        procRd.setParameterIDs(uuids);
        procRd.setResultSetID(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        if (RecordFactory.includeProcedureUpdateCount(indexVersion)) {
            procRd.setUpdateCount(Integer.parseInt((String)tokens.get(tokenIndex++)));
        }
        RecordFactory.setRecordFooterValues(procRd, tokens, tokenIndex);
        return procRd;
    }

    public static ProcedureParameterRecord createProcedureParameterRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ProcedureParameterRecordImpl paramRd = new ProcedureParameterRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        paramRd.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RecordFactory.setRecordHeaderValues(paramRd, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        paramRd.setDefaultValue(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        paramRd.setRuntimeType(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        paramRd.setDatatypeUUID(RecordFactory.getObjectValue((String)tokens.get(tokenIndex++)));
        paramRd.setLength(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setRadix(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setScale(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setNullType(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setPrecision(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setPosition(Integer.parseInt((String)tokens.get(tokenIndex++)));
        paramRd.setType(Integer.parseInt((String)tokens.get(tokenIndex++)));
        char[] flags = ((String)tokens.get(tokenIndex++)).toCharArray();
        paramRd.setOptional(RecordFactory.getBooleanValue(flags[0]));
        RecordFactory.setRecordFooterValues(paramRd, tokens, tokenIndex);
        return paramRd;
    }

    public static AnnotationRecord createAnnotationRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        AnnotationRecordImpl annotation = new AnnotationRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        annotation.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        RecordFactory.setRecordHeaderValues(annotation, (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++), (String)tokens.get(tokenIndex++));
        if (RecordFactory.includeAnnotationProperties(indexVersion)) {
            // empty if block
        }
        int n = ++tokenIndex;
        annotation.setDescription((String)tokens.get(n));
        RecordFactory.setRecordFooterValues(annotation, tokens, ++tokenIndex);
        return annotation;
    }

    public static PropertyRecord createPropertyRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        PropertyRecordImpl property = new PropertyRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        property.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        String recordType = (String)tokens.get(tokenIndex++);
        property.setRecordType(recordType.toCharArray()[0]);
        String objectID = (String)tokens.get(tokenIndex++);
        property.setUUID(RecordFactory.getObjectValue(objectID));
        property.setPropertyName((String)tokens.get(tokenIndex++));
        property.setPropertyValue((String)tokens.get(tokenIndex++));
        if (!RecordFactory.includeAnnotationProperties(indexVersion)) {
            char isExtension = ((String)tokens.get(tokenIndex++)).charAt(0);
            property.setExtension(RecordFactory.getBooleanValue(isExtension));
        }
        RecordFactory.setRecordFooterValues(property, tokens, tokenIndex);
        return property;
    }

    public static FileRecord createFileRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        FileRecordImpl file = new FileRecordImpl();
        int indexVersion = RecordFactory.getIndexVersion(record);
        file.setIndexVersion(indexVersion);
        int tokenIndex = 0;
        String recordType = (String)tokens.get(tokenIndex++);
        file.setRecordType(recordType.toCharArray()[0]);
        file.setPathInVdb((String)tokens.get(tokenIndex++));
        return file;
    }

    public static int getIndexVersion(char[] record) {
        CoreArgCheck.isNotNull((Object)record);
        int endIndex = record.length;
        int beginIndex = endIndex - 6 > 0 ? endIndex - 6 : 1;
        int version = 0;
        int i = beginIndex;
        while (i < endIndex) {
            if (record[i] == '\u00a1') {
                char versionPart1 = record[i + 1];
                char versionPart2 = record[i + 2];
                if (Character.isDigit(versionPart1) && Character.isDigit(versionPart2)) {
                    version = Character.digit(versionPart1, 10) * 10 + Character.digit(versionPart2, 10);
                }
            }
            ++i;
        }
        return version;
    }

    public static String getObjectValue(String str) {
        if (str != null && str.length() == 1 && str.charAt(0) == ' ') {
            return null;
        }
        return str;
    }

    public static boolean getBooleanValue(char b) {
        return b == '1';
    }

    public static List getIDs(String values, int indexVersionNumber) {
        if (CoreStringUtil.isEmpty((String)values)) {
            return Collections.EMPTY_LIST;
        }
        if (values.length() == 1 && values.charAt(0) == ' ') {
            return Collections.EMPTY_LIST;
        }
        char listDelimiter = RecordFactory.getListDelimiter(indexVersionNumber);
        List tokens = CoreStringUtil.split((String)values, (String)String.valueOf(listDelimiter));
        ArrayList<String> result = new ArrayList<String>(tokens.size());
        Iterator iter = tokens.iterator();
        while (iter.hasNext()) {
            String token = RecordFactory.getObjectValue((String)iter.next());
            if (token == null) continue;
            result.add(token);
        }
        return result;
    }

    public static List getStrings(String values, int indexVersionNumber) {
        if (CoreStringUtil.isEmpty((String)values)) {
            return Collections.EMPTY_LIST;
        }
        if (values.length() == 1 && values.charAt(0) == ' ') {
            return Collections.EMPTY_LIST;
        }
        char listDelimiter = RecordFactory.getListDelimiter(indexVersionNumber);
        List tokens = CoreStringUtil.split((String)values, (String)String.valueOf(listDelimiter));
        ArrayList<String> result = new ArrayList<String>(tokens.size());
        for (String token : tokens) {
            if (token == null) continue;
            result.add(token);
        }
        return result;
    }

    public static char getListDelimiter(int indexVersionNumber) {
        if (indexVersionNumber < 1) {
            return ',';
        }
        return '\u001f';
    }

    public static boolean includeMaterializationFlag(int indexVersionNumber) {
        return indexVersionNumber >= 2;
    }

    public static boolean includeMaterializedTables(int indexVersionNumber) {
        return indexVersionNumber >= 2;
    }

    public static boolean includeColumnNativeType(int indexVersionNumber) {
        return indexVersionNumber >= 3;
    }

    public static boolean includeColumnNullDistinctValues(int indexVersionNumber) {
        return indexVersionNumber >= 7;
    }

    public static boolean includePrimitiveTypeIdValue(int indexVersionNumber) {
        return indexVersionNumber >= 8;
    }

    public static boolean includeInputParameterFlag(int indexVersionNumber) {
        return indexVersionNumber >= 4;
    }

    public static boolean includeAnnotationProperties(int indexVersionNumber) {
        return indexVersionNumber < 5;
    }

    public static boolean includeTransformationUUID(int indexVersionNumber) {
        return indexVersionNumber >= 6;
    }

    private static boolean includeProcedureUpdateCount(int indexVersionNumber) {
        return indexVersionNumber >= 9;
    }

    private static boolean includeTableCardinalityOfMinusOne(int indexVersionNumber) {
        return indexVersionNumber >= 10;
    }

    public static int getCurrentIndexVersionNumber() {
        return 10;
    }

    private static void setRecordHeaderValues(AbstractMetadataRecord record, String recordType, String upperName, String objectID, String fullName, String nameInSource, String parentObjectID) {
        record.setRecordType(recordType.toCharArray()[0]);
        record.setUUID(RecordFactory.getObjectValue(objectID));
        record.setFullName(fullName);
        record.setNameInSource(RecordFactory.getObjectValue(nameInSource));
        record.setParentUUID(RecordFactory.getObjectValue(parentObjectID));
    }

    private static void setRecordFooterValues(AbstractMetadataRecord record, List tokens, int tokenIndex) {
        record.setResourcePath(RecordFactory.getOptionalToken(tokens, tokenIndex++));
        record.setName(RecordFactory.getOptionalToken(tokens, tokenIndex++));
        String version = RecordFactory.getOptionalToken(tokens, tokenIndex++);
        if (version != null && version.length() > 0) {
            if (version.charAt(0) == '\u00a1') {
                version = version.substring(1);
            }
            try {
                record.setIndexVersion(Integer.parseInt(version));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static String getOptionalToken(List tokens, int tokenIndex) {
        if (tokens.size() > tokenIndex) {
            return (String)tokens.get(tokenIndex);
        }
        return null;
    }
}

