/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.workspace;

import java.io.File;
import java.io.InputStream;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.common.xmi.XMIHeader;
import org.teiid.designer.common.xmi.XMIHeaderReader;

public class ModelFileUtil {
    public static final String DOT_PROJECT = ".project";
    public static final String FILE_COLON = "file:";
    public static final String EXTENSION_XML = "xml";
    public static final String EXTENSION_XMI = "xmi";
    public static final String EXTENSION_XSD = "xsd";
    public static final String EXTENSION_VDB = "vdb";
    public static final String EXTENSION_ECORE = "ecore";
    public static final String EXTENSION_WSDL = "wsdl";
    public static final String UML_MODEL_URI = "http://www.eclipse.org/uml2/3.0.0/UML";
    public static final String XML_SERVICE_MODEL_URI = "http://www.metamatrix.com/metamodels/XmlService";
    public static final String RELATIONSHIP_MODEL_URI = "http://www.metamatrix.com/metamodels/Relationship";
    private static XmiHeaderCache CACHE;

    public static void setCache(XmiHeaderCache cache) {
        CACHE = cache;
    }

    public static boolean isModelFile(File resource) {
        if (resource == null) {
            return false;
        }
        if (!resource.exists()) {
            String extension = FileUtils.getExtension((String)resource.getAbsolutePath());
            return ModelFileUtil.isModelFileExtension(extension, true);
        }
        if (ModelFileUtil.isXsdFile(resource)) {
            return true;
        }
        if (ModelFileUtil.isVdbArchiveFile(resource)) {
            return false;
        }
        if (!EXTENSION_XMI.equals(ModelFileUtil.getFileExtension(resource))) {
            return false;
        }
        XMIHeader header = ModelFileUtil.getXmiHeader(resource);
        if (header != null) {
            if (header.getXmiVersion() != null && header.getXmiVersion().startsWith("1.")) {
                return false;
            }
            String uri = header.getPrimaryMetamodelURI();
            if (uri == null) {
                return false;
            }
            if (uri.equalsIgnoreCase(XML_SERVICE_MODEL_URI) || uri.equalsIgnoreCase(RELATIONSHIP_MODEL_URI) || uri.equalsIgnoreCase(UML_MODEL_URI)) {
                return false;
            }
            if (header.getUUID() != null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isXsdFile(File resource) {
        return EXTENSION_XSD.equals(ModelFileUtil.getFileExtension(resource));
    }

    public static boolean isVdbArchiveFile(File resource) {
        return EXTENSION_VDB.equals(ModelFileUtil.getFileExtension(resource));
    }

    public static String getFileExtension(File resource) {
        if (resource != null) {
            return FileUtils.getExtension((File)resource);
        }
        return "";
    }

    public static boolean isModelFileExtension(String extension, boolean caseSensitive) {
        String exten;
        if (extension == null) {
            return false;
        }
        String string = exten = caseSensitive ? extension : extension.toLowerCase();
        if (EXTENSION_XMI.equals(exten)) {
            return true;
        }
        if (EXTENSION_XSD.equals(exten)) {
            return true;
        }
        if (EXTENSION_VDB.equals(exten)) {
            return false;
        }
        return false;
    }

    public static XMIHeader getXmiHeader(File resource) {
        if (resource != null && resource.isFile() && resource.exists() && resource.canRead()) {
            XMIHeader header;
            if (CACHE != null && (header = CACHE.getCachedXmiHeader(resource)) != null) {
                return header;
            }
            try {
                header = XMIHeaderReader.readHeader(resource);
                if (CACHE != null) {
                    CACHE.setXmiHeaderToCache(resource, header);
                }
                return header;
            }
            catch (TeiidDesignerException e) {
                CoreModelerPlugin.Util.log((Throwable)e);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }

    public static XMIHeader getXmiHeader(InputStream resourceStream) {
        if (resourceStream != null) {
            try {
                return XMIHeaderReader.readHeader(resourceStream);
            }
            catch (TeiidDesignerException e) {
                CoreModelerPlugin.Util.log((Throwable)e);
            }
        }
        return null;
    }

    public static interface XmiHeaderCache {
        public XMIHeader getCachedXmiHeader(File var1);

        public void setXmiHeaderToCache(File var1, XMIHeader var2);
    }
}

