/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.xsd;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.designer.common.xsd.TerminatingXsdHeaderContentHandler;
import org.teiid.designer.common.xsd.XsdHeader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XsdHeaderReader {
    private static final String XML_DECLARATION_PREFIX_STRING = "<?xml version=";

    public static XsdHeader readHeader(InputStream istream) throws TeiidDesignerException {
        XsdHeaderReader reader = new XsdHeaderReader();
        return reader.read(istream);
    }

    public static XsdHeader readHeader(File file) throws TeiidDesignerException {
        XsdHeaderReader reader = new XsdHeaderReader();
        return reader.read(file);
    }

    public XsdHeader read(InputStream istream) throws TeiidDesignerException {
        if (istream == null) {
            throw new IllegalArgumentException("XsdHeaderReader.The_InputStream_reference_may_not_be_null._1");
        }
        TerminatingXsdHeaderContentHandler handler = new TerminatingXsdHeaderContentHandler();
        try {
            Thread.currentThread().setContextClassLoader(XsdHeaderReader.class.getClassLoader());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            parser.parse(new InputSource(istream), (DefaultHandler)handler);
        }
        catch (SAXException e) {
            if (!"SchemaFoundException".equals(e.getMessage())) {
                if ("SchemaNotFoundException".equals(e.getMessage())) {
                    return null;
                }
                if (e instanceof SAXParseException) {
                    return null;
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (Throwable e) {
            throw new TeiidDesignerException(e, "XsdHeaderReader.Error_in_parsing_file_1");
        }
        return handler.getXsdHeader();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XsdHeader read(File file) throws TeiidDesignerException {
        XsdHeader xsdHeader;
        FileInputStream fis;
        block17: {
            if (file == null) {
                throw new IllegalArgumentException("XsdHeaderReader.The_file_reference_may_not_be_null_2");
            }
            if (!file.exists()) {
                throw new IllegalArgumentException("XsdHeaderReader.The_file_0_does_not_exist_and_therefore_cannot_be_read._3");
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException("XsdHeaderReader.The_file_0_does_not_have_read_privileges._4");
            }
            if (!XsdHeaderReader.isXmlFile(file)) {
                return null;
            }
            fis = null;
            BufferedInputStream bis = null;
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                xsdHeader = this.read(bis);
                if (bis == null) break block17;
            }
            catch (FileNotFoundException e) {
                try {
                    throw new TeiidDesignerException((Throwable)e, "XsdHeaderReader.Error_in_parsing_file_1");
                }
                catch (Throwable throwable) {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fis == null) throw throwable;
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
        if (fis == null) return xsdHeader;
        try {
            fis.close();
            return xsdHeader;
        }
        catch (IOException iOException) {}
        return xsdHeader;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isXmlFile(File file) {
        FileInputStream fis;
        block12: {
            fis = null;
            fis = new FileInputStream(file);
            byte[] buf = new byte[32];
            fis.read(buf);
            if (!new String(buf).startsWith(XML_DECLARATION_PREFIX_STRING)) break block12;
            if (fis == null) return true;
            try {
                fis.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
            catch (IOException iOException) {
                try {
                    if (fis == null) return false;
                }
                catch (Throwable throwable) {
                    if (fis == null) throw throwable;
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    fis.close();
                    return false;
                }
                catch (IOException iOException3) {}
                return false;
            }
        }
        if (fis == null) return false;
        try {
            fis.close();
            return false;
        }
        catch (IOException iOException) {}
        return false;
    }
}

