/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.common.vdb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.common.vdb.TerminatingVdbHeaderContentHandler;
import org.teiid.designer.common.vdb.VdbHeader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class VdbHeaderReader {
    private static final String XML_DECLARATION_PREFIX_STRING = "<?xml version=";
    private static final String VDB_FILE_EXTENSION = ".vdb";
    private static final String MANIFEST_MODEL_NAME = "MetaMatrix-VdbManifestModel.xmi";
    private static final String LOWER_CASE_MANIFEST_MODEL_NAME = "MetaMatrix-VdbManifestModel.xmi".toLowerCase();

    public static VdbHeader readHeader(File file) throws TeiidDesignerException {
        if (file != null && file.isFile() && file.exists() && file.length() > 0L) {
            String lowerCaseFileName = file.getName().toLowerCase();
            if (lowerCaseFileName.endsWith(VDB_FILE_EXTENSION)) {
                VdbHeader header;
                InputStream iStream;
                ZipFile zipFile;
                block25: {
                    block26: {
                        zipFile = null;
                        iStream = null;
                        header = null;
                        zipFile = new ZipFile(file);
                        iStream = VdbHeaderReader.getManifestStreamFromVdbArchive(zipFile);
                        if (iStream != null) break block25;
                        if (iStream == null) break block26;
                        try {
                            iStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return null;
                }
                try {
                    try {
                        VdbHeaderReader reader = new VdbHeaderReader();
                        header = reader.read(iStream);
                    }
                    catch (IOException e) {
                        throw new TeiidDesignerRuntimeException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    if (iStream != null) {
                        try {
                            iStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (iStream != null) {
                    try {
                        iStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return header;
            }
            if (LOWER_CASE_MANIFEST_MODEL_NAME.equals(lowerCaseFileName)) {
                VdbHeaderReader reader = new VdbHeaderReader();
                return reader.read(file);
            }
        }
        return null;
    }

    private VdbHeader read(InputStream istream) throws TeiidDesignerException {
        if (istream == null) {
            throw new IllegalArgumentException("VdbHeaderReader.The_InputStream_reference_may_not_be_null._1");
        }
        TerminatingVdbHeaderContentHandler handler = new TerminatingVdbHeaderContentHandler();
        try {
            Thread.currentThread().setContextClassLoader(VdbHeaderReader.class.getClassLoader());
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            parser.parse(new InputSource(istream), (DefaultHandler)handler);
        }
        catch (SAXException e) {
            if (!"HeaderFoundException".equals(e.getMessage()) && !"XMINotFoundException".equals(e.getMessage())) {
                boolean cfr_ignored_0 = e instanceof SAXParseException;
            }
        }
        catch (IOException iOException) {
        }
        catch (Throwable e) {
            throw new TeiidDesignerException(e, "VdbHeaderReader.Error_in_parsing_file_1");
        }
        return handler.getVdbHeader();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VdbHeader read(File file) throws TeiidDesignerException {
        VdbHeader vdbHeader;
        FileInputStream fis;
        block17: {
            if (file == null) {
                throw new IllegalArgumentException("VdbHeaderReader.The_file_reference_may_not_be_null_2");
            }
            if (!file.exists()) {
                throw new IllegalArgumentException("VdbHeaderReader.The_file_0_does_not_exist_and_therefore_cannot_be_read._3");
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException("VdbHeaderReader.The_file_0_does_not_have_read_privileges._4");
            }
            if (!VdbHeaderReader.isXmlFile(file)) {
                return null;
            }
            fis = null;
            BufferedInputStream bis = null;
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                vdbHeader = this.read(bis);
                if (bis == null) break block17;
            }
            catch (FileNotFoundException e) {
                try {
                    throw new TeiidDesignerException((Throwable)e, "VdbHeaderReader.Error_in_parsing_file_1");
                }
                catch (Throwable throwable) {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fis == null) throw throwable;
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
        if (fis == null) return vdbHeader;
        try {
            fis.close();
            return vdbHeader;
        }
        catch (IOException iOException) {}
        return vdbHeader;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isXmlFile(File file) {
        FileInputStream fis;
        block12: {
            fis = null;
            fis = new FileInputStream(file);
            byte[] buf = new byte[32];
            fis.read(buf);
            if (!new String(buf).startsWith(XML_DECLARATION_PREFIX_STRING)) break block12;
            if (fis == null) return true;
            try {
                fis.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
            catch (IOException iOException) {
                try {
                    if (fis == null) return false;
                }
                catch (Throwable throwable) {
                    if (fis == null) throw throwable;
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    fis.close();
                    return false;
                }
                catch (IOException iOException3) {}
                return false;
            }
        }
        if (fis == null) return false;
        try {
            fis.close();
            return false;
        }
        catch (IOException iOException) {}
        return false;
    }

    private static InputStream getManifestStreamFromVdbArchive(ZipFile zipFile) {
        return VdbHeaderReader.getEntryStreamFromArchive(zipFile, MANIFEST_MODEL_NAME);
    }

    private static InputStream getEntryStreamFromArchive(ZipFile zipFile, String zipEntryName) {
        CoreArgCheck.isNotNull((Object)zipFile);
        CoreArgCheck.isNotEmpty((String)zipEntryName);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry == null || !entry.getName().equalsIgnoreCase(zipEntryName)) continue;
                return zipFile.getInputStream(entry);
            }
        }
        catch (IOException e) {
            throw new TeiidDesignerRuntimeException((Throwable)e);
        }
        return null;
    }
}

