/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.views.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;
import org.teiid.designer.advisor.ui.views.status.ModelProjectStatus;
import org.teiid.designer.advisor.ui.views.status.StatusValidationConstants;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.DefaultIgnorableNotificationSource;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ResourceFilter;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class StatusValidationHelper
implements StatusValidationConstants {
    private static final String TRANSACTION_DESCRIPTION = "Creating new Data Services Project Status";
    private IProject currentProject;
    private Map eResourceToPath;
    private int sourceModelCount = 0;
    private int viewModelCount = 0;
    private int xmlViewModelCount = 0;
    private int webServiceModelCount = 0;
    private int xmlServiceModelCount = 0;
    private int schemaFileCount = 0;
    private int relationalViewModelCount = 0;
    private int vdbCount = 0;
    private boolean modelErrorsExist = false;
    private boolean sourceModelErrors = false;
    private boolean viewModelErrors = false;
    private boolean xmlViewModelErrors = false;
    private boolean schemaModelErrors = false;
    private boolean webServiceModelErrors = false;
    private boolean xmlServiceModelErrors = false;
    private boolean vdbErrors = false;
    private IResource[] allResources;
    private boolean validating = false;

    public StatusValidationHelper() {
    }

    public StatusValidationHelper(IProject project) {
        this.currentProject = project;
    }

    public ModelProjectStatus getCurrentStatus() {
        this.validating = true;
        ModelProjectStatus status = null;
        this.resetInitialState();
        this.setCurrentProject(AdvisorUiPlugin.getStatusManager().getCurrentProject());
        this.loadAndSetResources();
        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)TRANSACTION_DESCRIPTION, (Object)new DefaultIgnorableNotificationSource((Object)this));
        boolean succeeded = false;
        try {
            status = this.createNewStatus();
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.validating = false;
        return status;
    }

    private ModelProjectStatus createNewStatus() {
        if (this.currentProject == null) {
            return StatusValidationConstants.STATUS_MSGS.NO_PROJECT_SELECTED;
        }
        this.processModelTypes(this.allResources);
        boolean incomplete = false;
        boolean hasErrors = false;
        boolean noModels = this.allResources.length == 0;
        Status sourcesStatus = null;
        Status modelStatus = null;
        Status bindingsStatus = null;
        Status viewsStatus = null;
        Status xmlViewsStatus = null;
        Status schemaStatus = null;
        Status webServicesStatus = null;
        IStatus completedStatus = null;
        Status vdbsStatus = null;
        Status testStatus = null;
        if (this.modelErrorsExist) {
            modelStatus = StatusValidationConstants.STATUS_MSGS.MODEL_PROBLEMS_ERROR;
            hasErrors = true;
        } else {
            modelStatus = noModels ? StatusValidationConstants.STATUS_MSGS.NO_MODELS_NO_PROBLEMS : StatusValidationConstants.STATUS_MSGS.MODEL_PROBLEMS_OK;
        }
        if (this.sourceModelCount > 0) {
            sourcesStatus = this.sourceModelErrors ? StatusValidationConstants.STATUS_MSGS.SOURCE_MODELS_HAVE_ERRORS : StatusValidationConstants.STATUS_MSGS.SOURCE_MODELS_ARE_OK;
        } else {
            sourcesStatus = StatusValidationConstants.STATUS_MSGS.NO_SOURCE_MODELS_ARE_DEFINED;
            incomplete = true;
        }
        if (!this.isValidModelProject() || this.isValidModelProject() && !this.connectorBindingErrorsExist()) {
            bindingsStatus = StatusValidationConstants.STATUS_MSGS.CONNECTOR_BINDINGS_OK;
        } else if (sourcesStatus == StatusValidationConstants.STATUS_MSGS.NO_SOURCE_MODELS_ARE_DEFINED) {
            bindingsStatus = StatusValidationConstants.STATUS_MSGS.NO_CONNECTOR_BINDINGS_NO_SOURCES;
            incomplete = true;
        } else {
            bindingsStatus = StatusValidationConstants.STATUS_MSGS.CONNECTOR_BINDINGS_ERROR;
            hasErrors = true;
        }
        if (this.relationalViewModelCount > 0) {
            viewsStatus = this.viewModelErrors ? StatusValidationConstants.STATUS_MSGS.VIEW_MODELS_HAVE_ERRORS : StatusValidationConstants.STATUS_MSGS.VIEW_MODELS_ARE_OK;
        } else {
            viewsStatus = StatusValidationConstants.STATUS_MSGS.NO_VIEW_MODELS_ARE_DEFINED;
            incomplete = true;
        }
        if (this.xmlViewModelCount > 0) {
            xmlViewsStatus = this.xmlViewModelErrors ? StatusValidationConstants.STATUS_MSGS.XML_VIEW_MODELS_HAVE_ERRORS : StatusValidationConstants.STATUS_MSGS.XML_VIEW_MAPPINGS_OK;
        } else if (this.xmlViewModelCount == 0) {
            xmlViewsStatus = StatusValidationConstants.STATUS_MSGS.NO_XML_VIEW_MODELS_ARE_DEFINED;
            incomplete = true;
        }
        if (this.schemaFileCount > 0) {
            schemaStatus = this.schemaModelErrors ? StatusValidationConstants.STATUS_MSGS.SCHEMA_MODELS_HAVE_ERRORS : StatusValidationConstants.STATUS_MSGS.SCHEMA_MODELS_ARE_DEFINED;
        } else {
            schemaStatus = StatusValidationConstants.STATUS_MSGS.NO_SCHEMA_MODELS_ARE_DEFINED;
            incomplete = true;
        }
        if (this.webServiceModelCount > 0 || this.xmlServiceModelCount > 0) {
            webServicesStatus = this.webServiceModelErrors && this.xmlServiceModelErrors ? StatusValidationConstants.STATUS_MSGS.WEB_SERVICE_MODELS_HAVE_ERRORS : StatusValidationConstants.STATUS_MSGS.WEB_SERVICE_MODELS_ARE_OK;
        } else {
            webServicesStatus = StatusValidationConstants.STATUS_MSGS.NO_WEB_SERVICE_MODELS_ARE_DEFINED;
            incomplete = true;
        }
        if (this.vdbCount > 0) {
            vdbsStatus = this.vdbErrors ? StatusValidationConstants.STATUS_MSGS.VDBS_HAVE_ERRORS : StatusValidationConstants.STATUS_MSGS.VDBS_OK;
            testStatus = StatusValidationConstants.STATUS_MSGS.VDBS_OK;
        } else {
            vdbsStatus = StatusValidationConstants.STATUS_MSGS.NO_VDBS_ARE_DEFINED;
            testStatus = StatusValidationConstants.STATUS_MSGS.NO_VDBS_ARE_DEFINED;
        }
        ModelProjectStatus status = null;
        completedStatus = Status.OK_STATUS;
        completedStatus = hasErrors ? StatusValidationConstants.STATUS_MSGS.COMPLETION_ERRORS_EXIST : (incomplete ? StatusValidationConstants.STATUS_MSGS.COMPLETION_INCOMPLETE : StatusValidationConstants.STATUS_MSGS.COMPLETION_OK);
        status = new ModelProjectStatus("org.teiid.designer.advisor.ui", 0, completedStatus.getMessage(), null);
        status.setCurrentModelProject(this.currentProject);
        status.setModelStatus((IStatus)modelStatus);
        status.add((IStatus)modelStatus);
        status.setSourceModelsStatus((IStatus)sourcesStatus);
        status.add((IStatus)sourcesStatus);
        status.setViewModelsStatus((IStatus)viewsStatus);
        status.add((IStatus)viewsStatus);
        status.setXmlViewModelsStatus((IStatus)xmlViewsStatus);
        status.add((IStatus)xmlViewsStatus);
        status.setWebServiceOperationsStatus((IStatus)webServicesStatus);
        status.add((IStatus)webServicesStatus);
        status.setConnectionFactoriesStatus((IStatus)bindingsStatus);
        status.add((IStatus)bindingsStatus);
        status.setXmlSchemaFilesStatus((IStatus)schemaStatus);
        status.add((IStatus)schemaStatus);
        status.setWebServiceOperationsStatus((IStatus)webServicesStatus);
        status.add((IStatus)webServicesStatus);
        status.setVdbsStatus((IStatus)vdbsStatus);
        status.add((IStatus)vdbsStatus);
        status.setTestStatus((IStatus)testStatus);
        status.add((IStatus)testStatus);
        return status;
    }

    private void resetInitialState() {
        this.sourceModelCount = 0;
        this.viewModelCount = 0;
        this.relationalViewModelCount = 0;
        this.xmlViewModelCount = 0;
        this.webServiceModelCount = 0;
        this.xmlServiceModelCount = 0;
        this.schemaFileCount = 0;
        this.vdbCount = 0;
        this.modelErrorsExist = false;
        this.sourceModelErrors = false;
        this.viewModelErrors = false;
        this.xmlViewModelErrors = false;
        this.schemaModelErrors = false;
        this.webServiceModelErrors = false;
        this.xmlServiceModelErrors = false;
        this.vdbErrors = false;
        this.allResources = new IResource[0];
        if (this.eResourceToPath != null) {
            this.eResourceToPath.clear();
        } else {
            this.eResourceToPath = new HashMap();
        }
    }

    private IResource[] getResourcesForCurrentProject() throws CoreException {
        ModelResource[] mrs = ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace().getModelResources();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        ModelResource[] modelResourceArray = mrs;
        int n = mrs.length;
        int n2 = 0;
        while (n2 < n) {
            ModelResource mr = modelResourceArray[n2];
            if (mr.getModelProject().getProject().equals((Object)this.currentProject)) {
                try {
                    resources.add(mr.getCorrespondingResource());
                }
                catch (ModelWorkspaceException e) {
                    AdvisorUiConstants.UTIL.log((Throwable)e);
                }
            }
            ++n2;
        }
        Collection vdbs = WorkspaceResourceFinderUtil.getProjectFileResources((IProject)this.currentProject, (ResourceFilter)WorkspaceResourceFinderUtil.VDB_RESOURCE_FILTER);
        resources.addAll(vdbs);
        if (resources.isEmpty()) {
            return new IResource[0];
        }
        IResource[] resArray = new IResource[resources.size()];
        int i = 0;
        for (IResource res : resources) {
            resArray[i++] = res;
        }
        return resArray;
    }

    private void loadAndSetResources() {
        if (this.isValidModelProject()) {
            try {
                this.allResources = this.getResourcesForCurrentProject();
            }
            catch (CoreException e) {
                AdvisorUiConstants.UTIL.log((Throwable)e);
            }
        }
    }

    private boolean isValidModelProject() {
        return this.currentProject != null && this.currentProject.isAccessible();
    }

    private void processModelTypes(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            boolean resourceHasErrors = this.errorMarkersExist(resource);
            if (resourceHasErrors && !this.modelErrorsExist) {
                this.modelErrorsExist = true;
            }
            if (ModelIdentifier.isPhysicalModelType((IResource)resource)) {
                ++this.sourceModelCount;
                if (resourceHasErrors && !this.sourceModelErrors) {
                    this.sourceModelErrors = true;
                }
            } else if (ModelIdentifier.isRelationalViewModel((IResource)resource)) {
                ++this.relationalViewModelCount;
                if (resourceHasErrors && !this.viewModelErrors) {
                    this.viewModelErrors = true;
                }
            } else if (ModelIdentifier.isWebServicesViewModel((IResource)resource)) {
                ++this.webServiceModelCount;
                if (resourceHasErrors && !this.webServiceModelErrors) {
                    this.webServiceModelErrors = true;
                }
            } else if (ModelIdentifier.isSchemaModel((IResource)resource)) {
                ++this.schemaFileCount;
                if (resourceHasErrors && !this.schemaModelErrors) {
                    this.schemaModelErrors = true;
                }
            }
            if (ModelUtil.isVdbArchiveFile((IResource)resource) && !resource.getName().toUpperCase().startsWith("PREVIEW_")) {
                ++this.vdbCount;
                if (resourceHasErrors && !this.vdbErrors) {
                    this.vdbErrors = true;
                }
            }
            ++n2;
        }
    }

    private boolean errorMarkersExist(IResource resource) {
        if (resource.exists()) {
            IMarker[] markers = null;
            try {
                markers = ((IFile)resource).findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
            catch (CoreException theException) {
                AdvisorUiConstants.UTIL.log((Throwable)theException);
            }
            if (markers != null && markers.length > 0) {
                int i = 0;
                while (i < markers.length) {
                    int severity = markers[i].getAttribute("severity", -1);
                    if (severity == 2) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public boolean connectorBindingErrorsExist() {
        return this.sourceModelCount == 0;
    }

    public IProject getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(IProject project) {
        this.currentProject = project;
    }

    public boolean isValidating() {
        return this.validating;
    }
}

