/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.util;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;

public class LabelLabelLinkRow {
    private Label image;
    private Label label;
    private ImageHyperlink link;
    private Color dimFGColor;
    private Color defFGColor;

    public LabelLabelLinkRow(int id, FormToolkit toolkit, Composite body, String mainLabel, IHyperlinkListener listener) {
        this.image = toolkit.createLabel(body, null);
        this.image.setImage(AdvisorUiPlugin.getImageHelper().UNCHECKED_BOX_IMAGE);
        this.label = toolkit.createLabel(body, mainLabel, 0);
        this.link = toolkit.createImageHyperlink(body, 64);
        this.link.setImage(AdvisorUiPlugin.getImageHelper().LIGHTBULB_IMAGE);
        this.link.addHyperlinkListener(listener);
        this.link.setData((Object)id);
        this.dimFGColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER");
        this.defFGColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_FG");
    }

    public void setImage(Image image) {
        if (!this.image.isDisposed()) {
            this.image.setImage(image);
        }
    }

    public void setText(String label) {
        if (!this.label.isDisposed()) {
            this.label.setText(label);
        }
    }

    public void setImageTooltip(String text) {
        if (!this.image.isDisposed()) {
            this.image.setToolTipText(text);
        }
    }

    public void setLabelTooltip(String text) {
        if (!this.label.isDisposed()) {
            this.label.setToolTipText(text);
        }
    }

    public void setLinkTooltip(String text) {
        if (!this.link.isDisposed()) {
            this.link.setToolTipText(text);
        }
    }

    public void update(Image image, String imageTT, String labelTT, String linkTT) {
        if (image != null) {
            this.setImage(image);
        }
        if (imageTT != null) {
            this.setImageTooltip(imageTT);
        }
        if (labelTT != null) {
            this.setLabelTooltip(labelTT);
        }
        if (linkTT != null) {
            this.setLinkTooltip(linkTT);
        }
    }

    public void dim() {
        this.label.setForeground(this.dimFGColor);
    }

    public void brighten() {
        this.label.setForeground(this.defFGColor);
    }

    public void redraw() {
        this.image.redraw();
    }
}

