/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.core.status;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;
import org.teiid.designer.advisor.ui.core.status.AdvisorStatusManager;
import org.teiid.designer.advisor.ui.core.status.DefaultStatusManager;
import org.teiid.designer.advisor.ui.core.status.IStatusContentProvider;
import org.teiid.designer.advisor.ui.core.status.IStatusRowProvider;
import org.teiid.designer.advisor.ui.views.status.StatusValidationConstants;

public class DefaultStatusProvider
implements IStatusContentProvider {
    private AdvisorStatusManager statusManager = new DefaultStatusManager();
    private IStatusRowProvider[] providers;

    @Override
    public IStatus getDefaultStatus() {
        return StatusValidationConstants.STATUS_MSGS.ADVISOR_NO_PROJECT_SELECTED;
    }

    @Override
    public String getDescription() {
        return "Focused object not selected for advisor.";
    }

    @Override
    public Image getImage(int id) {
        return AdvisorUiPlugin.getImageHelper().EMPTY_BOX_IMAGE;
    }

    @Override
    public String getLinkTooltip(int id) {
        return "Default Status Tooltip";
    }

    @Override
    public IStatusRowProvider[] getRowsProviders() {
        if (this.providers == null) {
            this.initRowProviders();
        }
        return this.providers;
    }

    @Override
    public IStatus getStatus(int id) {
        return this.statusManager.getCurrentStatus().get(id);
    }

    @Override
    public Image getStatusImage(int id) {
        return AdvisorUiPlugin.getImageHelper().CHECKED_BOX_IMAGE;
    }

    @Override
    public String getText(int id) {
        return "Default Advisor Text";
    }

    @Override
    public String getTitle() {
        if (this.statusManager == null || this.statusManager.getCurrentObject() == null) {
            return "Advisor Object Title";
        }
        return ((IProject)this.statusManager.getCurrentObject()).getName();
    }

    private void initRowProviders() {
    }

    @Override
    public String getId() {
        return "defaultStatusProviderId";
    }

    @Override
    public void updateStatus(boolean forceUpdate) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void startup() {
    }
}

