/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.actions;

import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;
import org.teiid.designer.advisor.ui.Messages;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.wizards.NewModelWizard;
import org.teiid.designer.ui.wizards.NewModelWizardInput;

public final class NewModelAction
extends Action
implements AdvisorUiConstants {
    private NewModelWizardInput newModelInput;
    private Properties designerProperties;

    public NewModelAction() {
        this.setText("New Model Action");
        this.setToolTipText("New Model Action Tooltip");
        this.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/new-model-wiz.gif"));
    }

    public NewModelAction(ModelType modelType, String metamodelClass, String builderType, Properties properties) {
        this();
        this.setModelType(modelType);
        this.setMetamodelClass(metamodelClass);
        this.setBuilderType(builderType);
        this.designerProperties = properties;
    }

    private NewModelWizardInput getNewModelInput() {
        if (this.newModelInput == null) {
            this.newModelInput = new NewModelWizardInput();
        }
        return this.newModelInput;
    }

    public void run() {
        block8: {
            IWorkbenchWindow iww = AdvisorUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            boolean successful = false;
            try {
                Properties props = this.designerProperties;
                if (props == null) {
                    props = new Properties();
                }
                NewModelWizard wizard = new NewModelWizard(this.newModelInput, props);
                String viewId = ProductCustomizerMgr.getInstance().getProductCharacteristics().getPrimaryNavigationViewId();
                ISelection theSelection = iww.getSelectionService().getSelection(viewId);
                wizard.init(iww.getWorkbench(), (IStructuredSelection)theSelection);
                WizardDialog dialog = new WizardDialog(iww.getShell(), (IWizard)wizard);
                wizard.updateForProperties();
                String openProjectStatus = DesignerPropertiesUtil.getProjectStatus((Properties)props);
                if (openProjectStatus == null || !"noOpenProject".equalsIgnoreCase(openProjectStatus)) {
                    int result = dialog.open();
                    if (result == 0) {
                        successful = true;
                    }
                    break block8;
                }
                return;
            }
            catch (Exception e) {
                AdvisorUiConstants.UTIL.log(4, (Throwable)e, e.getMessage());
                MessageDialog.openError((Shell)iww.getShell(), (String)Messages.NewModelWizardErrorTitle, (String)Messages.NewModelWizardErrorMessage);
            }
            finally {
                this.notifyResult(successful);
                this.newModelInput = null;
            }
        }
    }

    public void setMetamodelClass(String metamodelClass) {
        this.getNewModelInput().setMetamodelClass(metamodelClass);
    }

    public void setModelType(ModelType type) {
        this.getNewModelInput().setModelType(type);
    }

    public void setBuilderType(String type) {
        this.getNewModelInput().setBuilderType(type);
    }
}

