/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.advisor.ui.actions;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.advisor.ui.AdvisorUiConstants;
import org.teiid.designer.advisor.ui.AdvisorUiPlugin;
import org.teiid.designer.transformation.ui.editors.DefineViewTableDialog;
import org.teiid.designer.ui.viewsupport.DesignerProperties;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public class DefineViewTableAction
extends Action
implements AdvisorUiConstants {
    private Properties designerProperties;

    public DefineViewTableAction() {
        this.setText("Define View Table");
        this.setToolTipText("Define View Table Tooltip");
        this.setImageDescriptor(AdvisorUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/new-view-table.png"));
    }

    public DefineViewTableAction(Properties properties) {
        this();
        this.designerProperties = properties;
    }

    public void run() {
        boolean tempProperties = false;
        if (this.designerProperties == null) {
            tempProperties = true;
            this.designerProperties = new DesignerProperties("unknown");
        }
        if (!ModelerUiViewUtils.workspaceHasOpenModelProjects()) {
            IProject newProject = ModelerUiViewUtils.queryUserToCreateModelProject();
            if (newProject != null) {
                DesignerPropertiesUtil.setProjectName((Properties)this.designerProperties, (String)newProject.getName());
            } else {
                DesignerPropertiesUtil.setProjectStatus((Properties)this.designerProperties, (String)"noOpenProject");
                return;
            }
        }
        IWorkbenchWindow iww = AdvisorUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        DefineViewTableDialog sdDialog = new DefineViewTableDialog(iww.getShell(), this.designerProperties);
        sdDialog.open();
        sdDialog.getReturnCode();
        if (tempProperties) {
            this.designerProperties = null;
        }
    }
}

